/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.workflow.kaleo.definition.internal.parser;

import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.workflow.kaleo.definition.Definition;
import com.liferay.portal.workflow.kaleo.definition.Task;
import com.liferay.portal.workflow.kaleo.definition.TaskForm;
import com.liferay.portal.workflow.kaleo.definition.TaskFormReference;
import com.liferay.portal.workflow.kaleo.definition.exception.KaleoDefinitionValidationException;
import com.liferay.portal.workflow.kaleo.definition.internal.parser.BaseNodeValidator;
import com.liferay.portal.workflow.kaleo.definition.parser.NodeValidator;
import java.util.Set;
import org.osgi.service.component.annotations.Component;

@Component(immediate=true, property={"node.type=TASK"}, service={NodeValidator.class})
public class TaskNodeValidator
extends BaseNodeValidator<Task> {
    @Override
    protected void doValidate(Definition definition, Task task) throws KaleoDefinitionValidationException {
        if (task.getIncomingTransitionsCount() == 0) {
            throw new KaleoDefinitionValidationException.MustSetIncomingTransition(task.getName());
        }
        if (task.getOutgoingTransitionsCount() == 0) {
            throw new KaleoDefinitionValidationException.MustSetOutgoingTransition(task.getName());
        }
        Set assignments = task.getAssignments();
        if (assignments == null || assignments.isEmpty()) {
            throw new KaleoDefinitionValidationException.MustSetAssignments(task.getName());
        }
        Set taskForms = task.getTaskForms();
        for (TaskForm taskForm : taskForms) {
            String formDefinition = taskForm.getFormDefinition();
            TaskFormReference taskFormReference = taskForm.getTaskFormReference();
            if (!Validator.isNull((String)formDefinition) && taskFormReference != null) continue;
            throw new KaleoDefinitionValidationException.MustSetTaskFormDefinitionOrReference(task.getName(), taskForm.getName());
        }
    }
}

