/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.workflow.kaleo.runtime.assignment;

import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.workflow.kaleo.KaleoTaskAssignmentFactory;
import com.liferay.portal.workflow.kaleo.model.KaleoTaskAssignment;
import com.liferay.portal.workflow.kaleo.runtime.assignment.KaleoTaskAssignmentSelector;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.osgi.annotation.versioning.ProviderType;
import org.osgi.service.component.annotations.Reference;

@ProviderType
public abstract class BaseKaleoTaskAssignmentSelector
implements KaleoTaskAssignmentSelector {
    @Reference
    protected KaleoTaskAssignmentFactory kaleoTaskAssignmentFactory;

    protected Collection<KaleoTaskAssignment> getKaleoTaskAssignments(Map<String, ?> results) {
        ArrayList<KaleoTaskAssignment> kaleoTaskAssignments = new ArrayList<KaleoTaskAssignment>();
        if (results.get("roles") != null) {
            this.getRoleKaleoTaskAssignments((List)results.get("roles"), kaleoTaskAssignments);
            return kaleoTaskAssignments;
        }
        if (results.get("user") != null) {
            kaleoTaskAssignments.add(this.getUserKaleoTaskAssignment((User)results.get("user")));
            return kaleoTaskAssignments;
        }
        for (User user : (List)results.get("users")) {
            kaleoTaskAssignments.add(this.getUserKaleoTaskAssignment(user));
        }
        return kaleoTaskAssignments;
    }

    protected void getRoleKaleoTaskAssignments(List<Role> roles, List<KaleoTaskAssignment> kaleoTaskAssignments) {
        if (roles == null) {
            return;
        }
        for (Role role : roles) {
            KaleoTaskAssignment kaleoTaskAssignment = this.kaleoTaskAssignmentFactory.createKaleoTaskAssignment();
            kaleoTaskAssignment.setAssigneeClassName(Role.class.getName());
            kaleoTaskAssignment.setAssigneeClassPK(role.getRoleId());
            kaleoTaskAssignments.add(kaleoTaskAssignment);
        }
    }

    protected KaleoTaskAssignment getUserKaleoTaskAssignment(User user) {
        KaleoTaskAssignment kaleoTaskAssignment = this.kaleoTaskAssignmentFactory.createKaleoTaskAssignment();
        kaleoTaskAssignment.setAssigneeClassName(User.class.getName());
        kaleoTaskAssignment.setAssigneeClassPK(user.getUserId());
        return kaleoTaskAssignment;
    }
}

