/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.workflow.kaleo.runtime.util;

import com.liferay.portal.kernel.exception.DuplicateRoleException;
import com.liferay.portal.kernel.exception.NoSuchRoleException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.service.RoleLocalServiceUtil;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.roles.admin.role.type.contributor.RoleTypeContributor;
import com.liferay.roles.admin.role.type.contributor.provider.RoleTypeContributorProvider;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;
import org.osgi.util.tracker.ServiceTracker;

public class RoleUtil {
    private static final String _LEGACY_TYPE_COMMUNITY_LABEL = "community";
    private static final ServiceTracker<RoleTypeContributorProvider, RoleTypeContributorProvider> _serviceTracker;

    public static Role getRole(String name, int roleType, boolean autoCreate, ServiceContext serviceContext) throws PortalException {
        Role role = null;
        try {
            role = RoleLocalServiceUtil.getRole((long)serviceContext.getCompanyId(), (String)name);
            if (role.getType() != roleType) {
                throw new DuplicateRoleException("Role already exists with name " + name);
            }
        }
        catch (NoSuchRoleException noSuchRoleException) {
            if (!autoCreate) {
                throw noSuchRoleException;
            }
            role = RoleLocalServiceUtil.addRole((long)serviceContext.getUserId(), null, (long)0L, (String)name, null, (Map)HashMapBuilder.put((Object)LocaleUtil.getDefault(), (Object)"This is an autogenerated role from the workflow definition.").build(), (int)roleType, null, null);
        }
        return role;
    }

    public static List<Long> getRoleIds(ServiceContext serviceContext) {
        List roles = RoleLocalServiceUtil.getUserRoles((long)serviceContext.getUserId());
        ArrayList<Long> roleIds = new ArrayList<Long>(roles.size());
        for (Role role : roles) {
            roleIds.add(role.getRoleId());
        }
        return roleIds;
    }

    public static int getRoleType(String roleType) {
        RoleTypeContributorProvider roleTypeContributorProvider = (RoleTypeContributorProvider)_serviceTracker.getService();
        for (RoleTypeContributor roleTypeContributor : roleTypeContributorProvider.getRoleTypeContributors()) {
            if (!roleType.equals(roleTypeContributor.getTypeLabel())) continue;
            return roleTypeContributor.getType();
        }
        if (roleType.equals(_LEGACY_TYPE_COMMUNITY_LABEL)) {
            return 2;
        }
        return 1;
    }

    static {
        Bundle bundle = FrameworkUtil.getBundle(RoleTypeContributorProvider.class);
        ServiceTracker serviceTracker = new ServiceTracker(bundle.getBundleContext(), RoleTypeContributorProvider.class, null);
        serviceTracker.open();
        _serviceTracker = serviceTracker;
    }
}

