/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.workflow.kaleo.runtime.node;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.workflow.kaleo.definition.ExecutionType;
import com.liferay.portal.workflow.kaleo.model.KaleoInstanceToken;
import com.liferay.portal.workflow.kaleo.model.KaleoNode;
import com.liferay.portal.workflow.kaleo.model.KaleoTimer;
import com.liferay.portal.workflow.kaleo.runtime.ExecutionContext;
import com.liferay.portal.workflow.kaleo.runtime.action.KaleoActionExecutor;
import com.liferay.portal.workflow.kaleo.runtime.graph.PathElement;
import com.liferay.portal.workflow.kaleo.runtime.node.NodeExecutor;
import com.liferay.portal.workflow.kaleo.runtime.notification.NotificationHelper;
import com.liferay.portal.workflow.kaleo.runtime.util.ExecutionContextHelper;
import com.liferay.portal.workflow.kaleo.service.KaleoTimerInstanceTokenLocalService;
import com.liferay.portal.workflow.kaleo.service.KaleoTimerLocalService;
import java.util.List;
import org.osgi.service.component.annotations.Reference;

public abstract class BaseNodeExecutor
implements NodeExecutor {
    @Reference
    protected ExecutionContextHelper executionContextHelper;
    @Reference
    protected KaleoActionExecutor kaleoActionExecutor;
    @Reference
    protected KaleoTimerInstanceTokenLocalService kaleoTimerInstanceTokenLocalService;
    @Reference
    protected KaleoTimerLocalService kaleoTimerLocalService;
    @Reference
    protected NotificationHelper notificationHelper;

    @Override
    public boolean enter(KaleoNode currentKaleoNode, ExecutionContext executionContext) throws PortalException {
        KaleoInstanceToken kaleoInstanceToken = executionContext.getKaleoInstanceToken();
        kaleoInstanceToken.setCurrentKaleoNode(currentKaleoNode);
        boolean performExecute = this.doEnter(currentKaleoNode, executionContext);
        this.kaleoActionExecutor.executeKaleoActions(KaleoNode.class.getName(), currentKaleoNode.getKaleoNodeId(), ExecutionType.ON_ENTRY, executionContext);
        this.notificationHelper.sendKaleoNotifications(KaleoNode.class.getName(), currentKaleoNode.getKaleoNodeId(), ExecutionType.ON_ENTRY, executionContext);
        return performExecute;
    }

    @Override
    public void execute(KaleoNode currentKaleoNode, ExecutionContext executionContext, List<PathElement> remainingPathElements) throws PortalException {
        if (this.executionContextHelper.isKaleoInstanceBlocked(executionContext)) {
            return;
        }
        this.doExecute(currentKaleoNode, executionContext, remainingPathElements);
    }

    @Override
    public void exit(KaleoNode currentKaleoNode, ExecutionContext executionContext, List<PathElement> remainingPathElements) throws PortalException {
        this.executionContextHelper.completeKaleoTimerInstances(executionContext);
        this.doExit(currentKaleoNode, executionContext, remainingPathElements);
        this.kaleoActionExecutor.executeKaleoActions(KaleoNode.class.getName(), currentKaleoNode.getKaleoNodeId(), ExecutionType.ON_EXIT, executionContext);
        this.notificationHelper.sendKaleoNotifications(KaleoNode.class.getName(), currentKaleoNode.getKaleoNodeId(), ExecutionType.ON_EXIT, executionContext);
    }

    protected abstract boolean doEnter(KaleoNode var1, ExecutionContext var2) throws PortalException;

    protected abstract void doExecute(KaleoNode var1, ExecutionContext var2, List<PathElement> var3) throws PortalException;

    @Deprecated
    protected void doExecuteTimer(KaleoNode currentKaleoNode, KaleoTimer kaleoTimer, ExecutionContext executionContext) throws PortalException {
    }

    protected abstract void doExit(KaleoNode var1, ExecutionContext var2, List<PathElement> var3) throws PortalException;
}

