/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.workflow.kaleo.runtime.internal.assignment;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.ResourceAction;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.ClassUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.workflow.kaleo.definition.ScriptLanguage;
import com.liferay.portal.workflow.kaleo.definition.exception.KaleoDefinitionValidationException;
import com.liferay.portal.workflow.kaleo.model.KaleoInstanceToken;
import com.liferay.portal.workflow.kaleo.model.KaleoTaskAssignment;
import com.liferay.portal.workflow.kaleo.runtime.ExecutionContext;
import com.liferay.portal.workflow.kaleo.runtime.assignment.BaseTaskAssignmentSelector;
import com.liferay.portal.workflow.kaleo.runtime.assignment.TaskAssignmentSelector;
import com.liferay.portal.workflow.kaleo.service.KaleoInstanceLocalService;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@Component(immediate=true, property={"assignee.class.name=SCRIPT"}, service={TaskAssignmentSelector.class})
public class MultiLanguageTaskAssignmentSelector
extends BaseTaskAssignmentSelector {
    @Reference
    private KaleoInstanceLocalService _kaleoInstanceLocalService;
    private final Map<String, TaskAssignmentSelector> _taskAssignmentSelectors = new HashMap<String, TaskAssignmentSelector>();

    public Collection<KaleoTaskAssignment> calculateTaskAssignments(KaleoTaskAssignment kaleoTaskAssignment, ExecutionContext executionContext) throws PortalException {
        String assigneeClassName = kaleoTaskAssignment.getAssigneeClassName();
        TaskAssignmentSelector taskAssignmentSelector = null;
        if (assigneeClassName.equals(ResourceAction.class.getName())) {
            taskAssignmentSelector = this._taskAssignmentSelectors.get(assigneeClassName);
        } else {
            String taskAssignmentSelectorKey = this.getTaskAssignmentSelectKey(kaleoTaskAssignment.getAssigneeScriptLanguage(), StringUtil.trim((String)kaleoTaskAssignment.getAssigneeScript()));
            taskAssignmentSelector = this._taskAssignmentSelectors.get(taskAssignmentSelectorKey);
        }
        if (taskAssignmentSelector == null) {
            throw new IllegalArgumentException("No task assignment selector found for " + kaleoTaskAssignment.toXmlString());
        }
        Collection taskAssignments = taskAssignmentSelector.calculateTaskAssignments(kaleoTaskAssignment, executionContext);
        KaleoInstanceToken kaleoInstanceToken = executionContext.getKaleoInstanceToken();
        this._kaleoInstanceLocalService.updateKaleoInstance(kaleoInstanceToken.getKaleoInstanceId(), executionContext.getWorkflowContext(), executionContext.getServiceContext());
        return taskAssignments;
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY, target="(scripting.language=*)")
    protected void addTaskAssignmentSelector(TaskAssignmentSelector taskAssignmentSelector, Map<String, Object> properties) throws KaleoDefinitionValidationException {
        String[] scriptingLanguages;
        for (String scriptingLanguage : scriptingLanguages = this.getScriptingLanguages(taskAssignmentSelector, properties)) {
            String taskAssignmentSelectorKey = this.getTaskAssignmentSelectKey(scriptingLanguage, ClassUtil.getClassName((Object)taskAssignmentSelector));
            this._taskAssignmentSelectors.put(taskAssignmentSelectorKey, taskAssignmentSelector);
        }
    }

    protected String[] getScriptingLanguages(TaskAssignmentSelector taskAssignmentSelector, Map<String, Object> properties) {
        Object value = properties.get("scripting.language");
        Object[] scriptingLanguages = GetterUtil.getStringValues((Object)value, (String[])new String[]{String.valueOf(value)});
        if (ArrayUtil.isEmpty((Object[])scriptingLanguages)) {
            throw new IllegalArgumentException("The property \"scripting.language\" is invalid for " + ClassUtil.getClassName((Object)taskAssignmentSelector));
        }
        return scriptingLanguages;
    }

    protected String getTaskAssignmentSelectKey(String language, String taskAssignmentSelectorClassName) throws KaleoDefinitionValidationException {
        ScriptLanguage scriptLanguage = ScriptLanguage.parse((String)language);
        if (scriptLanguage.equals((Object)ScriptLanguage.JAVA)) {
            return language + ":" + taskAssignmentSelectorClassName;
        }
        return language;
    }

    protected void removeTaskAssignmentSelector(TaskAssignmentSelector taskAssignmentSelector, Map<String, Object> properties) throws KaleoDefinitionValidationException {
        String[] scriptingLanguages;
        for (String scriptingLanguage : scriptingLanguages = this.getScriptingLanguages(taskAssignmentSelector, properties)) {
            String taskAssignmentSelectorKey = this.getTaskAssignmentSelectKey(scriptingLanguage, ClassUtil.getClassName((Object)taskAssignmentSelector));
            this._taskAssignmentSelectors.remove(taskAssignmentSelectorKey);
        }
    }
}

