/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.workflow.kaleo.runtime.internal.assignment;

import com.liferay.portal.workflow.kaleo.runtime.assignment.TaskAssignmentSelector;
import com.liferay.portal.workflow.kaleo.runtime.assignment.TaskAssignmentSelectorRegistry;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@Component(immediate=true, service={TaskAssignmentSelectorRegistry.class})
public class TaskAssignmentSelectorTracker
implements TaskAssignmentSelectorRegistry {
    private final Map<String, TaskAssignmentSelector> _taskAssignmentSelectors = new ConcurrentHashMap<String, TaskAssignmentSelector>();

    public TaskAssignmentSelector getTaskAssignmentSelector(String assigneeClassName) {
        return this._taskAssignmentSelectors.get(assigneeClassName);
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY, target="(assignee.class.name=*)")
    protected void addTaskAssignmentSelector(TaskAssignmentSelector taskAssignmentSelector, Map<String, Object> properties) {
        Object assigneeClassName = properties.get("assignee.class.name");
        this._taskAssignmentSelectors.put(assigneeClassName.toString(), taskAssignmentSelector);
    }

    protected void removeTaskAssignmentSelector(TaskAssignmentSelector taskAssignmentSelector, Map<String, Object> properties) {
        String assigneeClassName = (String)properties.get("assignee.class.name");
        this._taskAssignmentSelectors.remove(assigneeClassName);
    }
}

