/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.workflow.kaleo.runtime.internal.notification;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.template.StringTemplateResource;
import com.liferay.portal.kernel.template.Template;
import com.liferay.portal.kernel.template.TemplateManagerUtil;
import com.liferay.portal.kernel.template.TemplateResource;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.workflow.kaleo.KaleoWorkflowModelConverter;
import com.liferay.portal.workflow.kaleo.model.KaleoInstance;
import com.liferay.portal.workflow.kaleo.model.KaleoInstanceToken;
import com.liferay.portal.workflow.kaleo.model.KaleoTask;
import com.liferay.portal.workflow.kaleo.model.KaleoTaskInstanceToken;
import com.liferay.portal.workflow.kaleo.model.KaleoTimerInstanceToken;
import com.liferay.portal.workflow.kaleo.runtime.ExecutionContext;
import com.liferay.portal.workflow.kaleo.runtime.notification.NotificationMessageGenerationException;
import com.liferay.portal.workflow.kaleo.runtime.notification.NotificationMessageGenerator;
import com.liferay.portal.workflow.kaleo.runtime.util.WorkflowContextUtil;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"template.language=freemarker", "template.language=soy", "template.language=velocity"}, service={NotificationMessageGenerator.class})
public class TemplateNotificationMessageGenerator
implements NotificationMessageGenerator {
    private static final Log _log = LogFactoryUtil.getLog(TemplateNotificationMessageGenerator.class);
    @Reference
    private KaleoWorkflowModelConverter _kaleoWorkflowModelConverter;
    private final Map<String, String> _templateManagerNames = new HashMap<String, String>();
    @Reference
    private UserLocalService _userLocalService;

    public String generateMessage(String kaleoClassName, long kaleoClassPK, String notificationName, String notificationTemplateLanguage, String notificationTemplate, ExecutionContext executionContext) throws NotificationMessageGenerationException {
        String templateManagerName = this._templateManagerNames.get(notificationTemplateLanguage);
        if (Validator.isNull((String)templateManagerName)) {
            throw new NotificationMessageGenerationException("Unsupported notification template language " + notificationTemplateLanguage);
        }
        try {
            String templateId = notificationName + kaleoClassName + kaleoClassPK;
            Template template = TemplateManagerUtil.getTemplate((String)templateManagerName, (TemplateResource)new StringTemplateResource(templateId, notificationTemplate), (boolean)false);
            this.populateContextVariables(template, executionContext);
            if (_log.isDebugEnabled()) {
                template.forEach((key, value) -> _log.debug((Object)StringBundler.concat((Object[])new Object[]{key, Character.valueOf(' '), Character.valueOf('('), value.getClass(), Character.valueOf(')')})));
            }
            StringWriter stringWriter = new StringWriter();
            template.processTemplate((Writer)stringWriter);
            return stringWriter.toString();
        }
        catch (Exception exception) {
            throw new NotificationMessageGenerationException("Unable to generate notification message", (Throwable)exception);
        }
    }

    @Activate
    protected void activate() {
        this._templateManagerNames.put("freemarker", "ftl");
        this._templateManagerNames.put("soy", "soy");
        this._templateManagerNames.put("velocity", "vm");
    }

    protected void populateContextVariables(Template template, ExecutionContext executionContext) throws Exception {
        Map workflowContext = executionContext.getWorkflowContext();
        if (workflowContext == null) {
            KaleoInstanceToken kaleoInstanceToken = executionContext.getKaleoInstanceToken();
            KaleoInstance kaleoInstance = kaleoInstanceToken.getKaleoInstance();
            workflowContext = WorkflowContextUtil.convert((String)kaleoInstance.getWorkflowContext());
        }
        for (Map.Entry entry : workflowContext.entrySet()) {
            template.put(entry.getKey(), entry.getValue());
        }
        template.put((Object)"kaleoInstanceToken", (Object)executionContext.getKaleoInstanceToken());
        KaleoTaskInstanceToken kaleoTaskInstanceToken = executionContext.getKaleoTaskInstanceToken();
        if (kaleoTaskInstanceToken != null) {
            KaleoTask kaleoTask = kaleoTaskInstanceToken.getKaleoTask();
            template.put((Object)"kaleoTaskInstanceToken", (Object)kaleoTaskInstanceToken);
            template.put((Object)"taskName", (Object)kaleoTask.getName());
            ServiceContext serviceContext = executionContext.getServiceContext();
            User user = this._userLocalService.getUser(serviceContext.getGuestOrUserId());
            template.put((Object)"userId", (Object)user.getUserId());
            template.put((Object)"userName", (Object)user.getFullName());
            template.put((Object)"workflowTaskAssignees", (Object)this._kaleoWorkflowModelConverter.getWorkflowTaskAssignees(kaleoTaskInstanceToken));
        } else {
            KaleoInstanceToken kaleoInstanceToken = executionContext.getKaleoInstanceToken();
            template.put((Object)"userId", (Object)kaleoInstanceToken.getUserId());
            template.put((Object)"userName", (Object)kaleoInstanceToken.getUserName());
        }
        KaleoTimerInstanceToken kaleoTimerInstanceToken = executionContext.getKaleoTimerInstanceToken();
        if (kaleoTimerInstanceToken != null) {
            template.put((Object)"kaleoTimerInstanceToken", (Object)kaleoTimerInstanceToken);
        }
    }
}

