/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.workflow.kaleo.runtime.internal.util;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.rules.engine.Fact;
import com.liferay.portal.workflow.kaleo.KaleoWorkflowModelConverter;
import com.liferay.portal.workflow.kaleo.model.KaleoInstance;
import com.liferay.portal.workflow.kaleo.model.KaleoInstanceToken;
import com.liferay.portal.workflow.kaleo.model.KaleoTask;
import com.liferay.portal.workflow.kaleo.model.KaleoTaskInstanceToken;
import com.liferay.portal.workflow.kaleo.runtime.ExecutionContext;
import com.liferay.portal.workflow.kaleo.runtime.util.RulesContextBuilder;
import com.liferay.portal.workflow.kaleo.runtime.util.WorkflowContextUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={RulesContextBuilder.class})
public class RulesContextBuilderImpl
implements RulesContextBuilder {
    @Reference
    private KaleoWorkflowModelConverter _kaleoWorkflowModelConverter;

    public List<Fact<?>> buildRulesContext(ExecutionContext executionContext) throws PortalException {
        Map workflowContext = executionContext.getWorkflowContext();
        if (workflowContext == null) {
            KaleoInstanceToken kaleoInstanceToken = executionContext.getKaleoInstanceToken();
            KaleoInstance kaleoInstance = kaleoInstanceToken.getKaleoInstance();
            workflowContext = WorkflowContextUtil.convert((String)kaleoInstance.getWorkflowContext());
        }
        ArrayList facts = new ArrayList(workflowContext.size() + 4);
        facts.add(new Fact("kaleoInstanceToken", (Object)executionContext.getKaleoInstanceToken()));
        facts.add(new Fact("workflowContext", (Object)workflowContext));
        KaleoTaskInstanceToken kaleoTaskInstanceToken = executionContext.getKaleoTaskInstanceToken();
        if (kaleoTaskInstanceToken != null) {
            facts.add(new Fact("kaleoTaskInstanceToken", (Object)kaleoTaskInstanceToken));
            KaleoTask kaleoTask = kaleoTaskInstanceToken.getKaleoTask();
            facts.add(new Fact("taskName", (Object)kaleoTask.getName()));
            if (kaleoTaskInstanceToken.getCompletionUserId() != 0L) {
                facts.add(new Fact("userId", (Object)kaleoTaskInstanceToken.getCompletionUserId()));
            } else {
                facts.add(new Fact("userId", (Object)kaleoTaskInstanceToken.getUserId()));
            }
            facts.add(new Fact("workflowTaskAssignees", (Object)this._kaleoWorkflowModelConverter.getWorkflowTaskAssignees(kaleoTaskInstanceToken)));
        } else {
            KaleoInstanceToken kaleoInstanceToken = executionContext.getKaleoInstanceToken();
            facts.add(new Fact("userId", (Object)kaleoInstanceToken.getUserId()));
        }
        if (executionContext.getKaleoTimerInstanceToken() != null) {
            facts.add(new Fact("kaleoTimerInstanceToken", (Object)executionContext.getKaleoTimerInstanceToken()));
        }
        return facts;
    }
}

