/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.workflow.kaleo.runtime.internal;

import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.transaction.Isolation;
import com.liferay.portal.kernel.transaction.Propagation;
import com.liferay.portal.kernel.transaction.Transactional;
import com.liferay.portal.workflow.kaleo.model.KaleoInstanceToken;
import com.liferay.portal.workflow.kaleo.model.KaleoNode;
import com.liferay.portal.workflow.kaleo.runtime.ExecutionContext;
import com.liferay.portal.workflow.kaleo.runtime.KaleoSignaler;
import com.liferay.portal.workflow.kaleo.runtime.graph.PathElement;
import com.liferay.portal.workflow.kaleo.runtime.internal.BaseKaleoBean;
import com.liferay.portal.workflow.kaleo.runtime.internal.node.NodeExecutorFactory;
import com.liferay.portal.workflow.kaleo.runtime.internal.petra.executor.GraphWalkerPortalExecutor;
import com.liferay.portal.workflow.kaleo.runtime.node.NodeExecutor;
import com.liferay.portal.workflow.kaleo.runtime.util.ExecutionContextHelper;
import java.util.ArrayList;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Transactional(isolation=Isolation.PORTAL, propagation=Propagation.SUPPORTS, rollbackFor={Exception.class})
@Component(immediate=true, service={AopService.class})
public class DefaultKaleoSignaler
extends BaseKaleoBean
implements AopService,
KaleoSignaler {
    @Reference
    private ExecutionContextHelper _executionContextHelper;
    @Reference
    private GraphWalkerPortalExecutor _graphWalkerPortalExecutor;
    @Reference
    private NodeExecutorFactory _nodeExecutorFactory;

    public void signalEntry(String transitionName, ExecutionContext executionContext) throws PortalException {
        this.signalEntry(transitionName, executionContext, false);
    }

    public void signalEntry(String transitionName, ExecutionContext executionContext, boolean waitForCompletion) throws PortalException {
        KaleoInstanceToken kaleoInstanceToken = executionContext.getKaleoInstanceToken();
        executionContext.setTransitionName(transitionName);
        this._graphWalkerPortalExecutor.execute(new PathElement(null, kaleoInstanceToken.getCurrentKaleoNode(), executionContext), waitForCompletion);
    }

    public void signalExecute(KaleoNode currentKaleoNode, ExecutionContext executionContext) throws PortalException {
        this.signalExecute(currentKaleoNode, executionContext, false);
    }

    @Transactional(isolation=Isolation.PORTAL, propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public void signalExecute(KaleoNode currentKaleoNode, ExecutionContext executionContext, boolean waitForCompletion) throws PortalException {
        NodeExecutor nodeExecutor = this._nodeExecutorFactory.getNodeExecutor(currentKaleoNode.getType());
        ArrayList remainingPathElements = new ArrayList();
        nodeExecutor.execute(currentKaleoNode, executionContext, remainingPathElements);
        this._executionContextHelper.checkKaleoInstanceComplete(executionContext);
        for (PathElement remainingPathElement : remainingPathElements) {
            this._graphWalkerPortalExecutor.execute(remainingPathElement, waitForCompletion);
        }
    }

    public void signalExit(String transitionName, ExecutionContext executionContext) throws PortalException {
        this.signalExit(transitionName, executionContext, false);
    }

    public void signalExit(String transitionName, ExecutionContext executionContext, boolean waitForCompletion) throws PortalException {
        KaleoInstanceToken kaleoInstanceToken = executionContext.getKaleoInstanceToken();
        executionContext.setTransitionName(transitionName);
        this._graphWalkerPortalExecutor.execute(new PathElement(kaleoInstanceToken.getCurrentKaleoNode(), null, executionContext), waitForCompletion);
    }
}

