/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.workflow.kaleo.runtime.internal.action.executor;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.util.ClassUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.workflow.kaleo.definition.ScriptLanguage;
import com.liferay.portal.workflow.kaleo.definition.exception.KaleoDefinitionValidationException;
import com.liferay.portal.workflow.kaleo.model.KaleoAction;
import com.liferay.portal.workflow.kaleo.runtime.ExecutionContext;
import com.liferay.portal.workflow.kaleo.runtime.action.ActionExecutorManager;
import com.liferay.portal.workflow.kaleo.runtime.action.executor.ActionExecutor;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@Component(immediate=true, service={ActionExecutorManager.class})
public class ActionExecutorManagerImpl
implements ActionExecutorManager {
    private final Map<String, ActionExecutor> _actionExecutors = new ConcurrentHashMap<String, ActionExecutor>();

    public void executeKaleoAction(KaleoAction kaleoAction, ExecutionContext executionContext) throws PortalException {
        String actionExecutorKey = this._getActionExecutorKey(kaleoAction.getScriptLanguage(), StringUtil.trim((String)kaleoAction.getScript()));
        ActionExecutor actionExecutor = this._actionExecutors.get(actionExecutorKey);
        if (actionExecutor == null) {
            throw new PortalException("No action executor for " + actionExecutorKey);
        }
        actionExecutor.execute(kaleoAction, executionContext);
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    protected synchronized void registerActionExecutor(ActionExecutor actionExecutor, Map<String, Object> properties) throws KaleoDefinitionValidationException {
        String[] languages;
        Object value = properties.get("com.liferay.portal.workflow.kaleo.runtime.action.executor.language");
        for (String language : languages = GetterUtil.getStringValues((Object)value, (String[])new String[]{String.valueOf(value)})) {
            this._actionExecutors.put(this._getActionExecutorKey(language, ClassUtil.getClassName((Object)actionExecutor)), actionExecutor);
        }
    }

    protected synchronized void unregisterActionExecutor(ActionExecutor actionExecutor, Map<String, Object> properties) throws KaleoDefinitionValidationException {
        String[] languages;
        Object value = properties.get("com.liferay.portal.workflow.kaleo.runtime.action.executor.language");
        for (String language : languages = GetterUtil.getStringValues((Object)value, (String[])new String[]{String.valueOf(value)})) {
            this._actionExecutors.remove(this._getActionExecutorKey(language, ClassUtil.getClassName((Object)actionExecutor)));
        }
    }

    private String _getActionExecutorKey(String language, String actionExecutorClassName) throws KaleoDefinitionValidationException {
        ScriptLanguage scriptLanguage = ScriptLanguage.parse((String)language);
        if (scriptLanguage.equals((Object)ScriptLanguage.JAVA)) {
            return language + ":" + actionExecutorClassName;
        }
        return language;
    }
}

