/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.workflow.kaleo.runtime.internal.assignment;

import com.liferay.portal.workflow.kaleo.runtime.assignment.KaleoTaskAssignmentSelector;
import com.liferay.portal.workflow.kaleo.runtime.assignment.KaleoTaskAssignmentSelectorRegistry;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@Component(immediate=true, service={KaleoTaskAssignmentSelectorRegistry.class})
public class KaleoTaskAssignmentSelectorTracker
implements KaleoTaskAssignmentSelectorRegistry {
    private final Map<String, KaleoTaskAssignmentSelector> _kaleoTaskAssignmentSelectors = new ConcurrentHashMap<String, KaleoTaskAssignmentSelector>();

    public KaleoTaskAssignmentSelector getKaleoTaskAssignmentSelector(String assigneeClassName) {
        return this._kaleoTaskAssignmentSelectors.get(assigneeClassName);
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY, target="(assignee.class.name=*)")
    protected void addKaleoTaskAssignmentSelector(KaleoTaskAssignmentSelector kaleoTaskAssignmentSelector, Map<String, Object> properties) {
        Object assigneeClassName = properties.get("assignee.class.name");
        this._kaleoTaskAssignmentSelectors.put(assigneeClassName.toString(), kaleoTaskAssignmentSelector);
    }

    protected void removeKaleoTaskAssignmentSelector(KaleoTaskAssignmentSelector kaleoTaskAssignmentSelector, Map<String, Object> properties) {
        String assigneeClassName = (String)properties.get("assignee.class.name");
        this._kaleoTaskAssignmentSelectors.remove(assigneeClassName);
    }
}

