/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.workflow.kaleo.runtime.internal.assignment;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.ResourceAction;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.ClassUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.workflow.kaleo.definition.ScriptLanguage;
import com.liferay.portal.workflow.kaleo.definition.exception.KaleoDefinitionValidationException;
import com.liferay.portal.workflow.kaleo.model.KaleoInstanceToken;
import com.liferay.portal.workflow.kaleo.model.KaleoTaskAssignment;
import com.liferay.portal.workflow.kaleo.runtime.ExecutionContext;
import com.liferay.portal.workflow.kaleo.runtime.assignment.BaseKaleoTaskAssignmentSelector;
import com.liferay.portal.workflow.kaleo.runtime.assignment.KaleoTaskAssignmentSelector;
import com.liferay.portal.workflow.kaleo.service.KaleoInstanceLocalService;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@Component(immediate=true, property={"assignee.class.name=SCRIPT"}, service={KaleoTaskAssignmentSelector.class})
public class MultiLanguageKaleoTaskAssignmentSelector
extends BaseKaleoTaskAssignmentSelector {
    @Reference
    private KaleoInstanceLocalService _kaleoInstanceLocalService;
    private final Map<String, KaleoTaskAssignmentSelector> _kaleoTaskAssignmentSelectors = new HashMap<String, KaleoTaskAssignmentSelector>();

    public Collection<KaleoTaskAssignment> getKaleoTaskAssignments(KaleoTaskAssignment kaleoTaskAssignment, ExecutionContext executionContext) throws PortalException {
        String assigneeClassName = kaleoTaskAssignment.getAssigneeClassName();
        KaleoTaskAssignmentSelector kaleoTaskAssignmentSelector = null;
        if (assigneeClassName.equals(ResourceAction.class.getName())) {
            kaleoTaskAssignmentSelector = this._kaleoTaskAssignmentSelectors.get(assigneeClassName);
        } else {
            String kaleoTaskAssignmentSelectorKey = this._getKaleoTaskAssignmentSelectKey(kaleoTaskAssignment.getAssigneeScriptLanguage(), StringUtil.trim((String)kaleoTaskAssignment.getAssigneeScript()));
            kaleoTaskAssignmentSelector = this._kaleoTaskAssignmentSelectors.get(kaleoTaskAssignmentSelectorKey);
        }
        if (kaleoTaskAssignmentSelector == null) {
            throw new IllegalArgumentException("No task assignment selector found for " + kaleoTaskAssignment.toXmlString());
        }
        Collection kaleoTaskAssignments = kaleoTaskAssignmentSelector.getKaleoTaskAssignments(kaleoTaskAssignment, executionContext);
        KaleoInstanceToken kaleoInstanceToken = executionContext.getKaleoInstanceToken();
        this._kaleoInstanceLocalService.updateKaleoInstance(kaleoInstanceToken.getKaleoInstanceId(), executionContext.getWorkflowContext(), executionContext.getServiceContext());
        return kaleoTaskAssignments;
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY, target="(scripting.language=*)")
    protected void addKaleoTaskAssignmentSelector(KaleoTaskAssignmentSelector kaleoTaskAssignmentSelector, Map<String, Object> properties) throws KaleoDefinitionValidationException {
        String[] scriptingLanguages;
        for (String scriptingLanguage : scriptingLanguages = this._getScriptingLanguages(kaleoTaskAssignmentSelector, properties)) {
            this._kaleoTaskAssignmentSelectors.put(this._getKaleoTaskAssignmentSelectKey(scriptingLanguage, ClassUtil.getClassName((Object)kaleoTaskAssignmentSelector)), kaleoTaskAssignmentSelector);
        }
    }

    protected void removeKaleoTaskAssignmentSelector(KaleoTaskAssignmentSelector kaleoTaskAssignmentSelector, Map<String, Object> properties) throws KaleoDefinitionValidationException {
        String[] scriptingLanguages;
        for (String scriptingLanguage : scriptingLanguages = this._getScriptingLanguages(kaleoTaskAssignmentSelector, properties)) {
            this._kaleoTaskAssignmentSelectors.remove(this._getKaleoTaskAssignmentSelectKey(scriptingLanguage, ClassUtil.getClassName((Object)kaleoTaskAssignmentSelector)));
        }
    }

    private String _getKaleoTaskAssignmentSelectKey(String language, String kaleoTaskAssignmentSelectorClassName) throws KaleoDefinitionValidationException {
        ScriptLanguage scriptLanguage = ScriptLanguage.parse((String)language);
        if (scriptLanguage.equals((Object)ScriptLanguage.JAVA)) {
            return language + ":" + kaleoTaskAssignmentSelectorClassName;
        }
        return language;
    }

    private String[] _getScriptingLanguages(KaleoTaskAssignmentSelector kaleoTaskAssignmentSelector, Map<String, Object> properties) {
        Object value = properties.get("scripting.language");
        Object[] scriptingLanguages = GetterUtil.getStringValues((Object)value, (String[])new String[]{String.valueOf(value)});
        if (ArrayUtil.isEmpty((Object[])scriptingLanguages)) {
            throw new IllegalArgumentException("The property \"scripting.language\" is invalid for " + ClassUtil.getClassName((Object)kaleoTaskAssignmentSelector));
        }
        return scriptingLanguages;
    }
}

