/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.workflow.kaleo.runtime.internal.node;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.workflow.kaleo.model.KaleoCondition;
import com.liferay.portal.workflow.kaleo.model.KaleoInstanceToken;
import com.liferay.portal.workflow.kaleo.model.KaleoNode;
import com.liferay.portal.workflow.kaleo.model.KaleoTransition;
import com.liferay.portal.workflow.kaleo.runtime.ExecutionContext;
import com.liferay.portal.workflow.kaleo.runtime.condition.ConditionEvaluator;
import com.liferay.portal.workflow.kaleo.runtime.graph.PathElement;
import com.liferay.portal.workflow.kaleo.runtime.node.BaseNodeExecutor;
import com.liferay.portal.workflow.kaleo.runtime.node.NodeExecutor;
import com.liferay.portal.workflow.kaleo.service.KaleoConditionLocalService;
import com.liferay.portal.workflow.kaleo.service.KaleoInstanceLocalService;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"node.type=CONDITION"}, service={NodeExecutor.class})
public class ConditionNodeExecutor
extends BaseNodeExecutor {
    @Reference(target="(!(scripting.language=*))")
    private ConditionEvaluator _conditionEvaluator;
    @Reference
    private KaleoConditionLocalService _kaleoConditionLocalService;
    @Reference
    private KaleoInstanceLocalService _kaleoInstanceLocalService;

    protected boolean doEnter(KaleoNode currentKaleoNode, ExecutionContext executionContext) {
        return true;
    }

    protected void doExecute(KaleoNode currentKaleoNode, ExecutionContext executionContext, List<PathElement> remainingPathElements) throws PortalException {
        KaleoInstanceToken kaleoInstanceToken = executionContext.getKaleoInstanceToken();
        KaleoCondition kaleoCondition = this._kaleoConditionLocalService.getKaleoNodeKaleoCondition(currentKaleoNode.getKaleoNodeId());
        String transitionName = this._conditionEvaluator.evaluate(kaleoCondition, executionContext);
        this._kaleoInstanceLocalService.updateKaleoInstance(kaleoInstanceToken.getKaleoInstanceId(), executionContext.getWorkflowContext(), executionContext.getServiceContext());
        KaleoTransition kaleoTransition = currentKaleoNode.getKaleoTransition(transitionName);
        ExecutionContext newExecutionContext = new ExecutionContext(kaleoInstanceToken, executionContext.getWorkflowContext(), executionContext.getServiceContext());
        PathElement pathElement = new PathElement(currentKaleoNode, kaleoTransition.getTargetKaleoNode(), newExecutionContext);
        remainingPathElements.add(pathElement);
    }

    protected void doExit(KaleoNode currentKaleoNode, ExecutionContext executionContext, List<PathElement> remainingPathElements) {
    }
}

