/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.workflow.kaleo.runtime.internal.notification.recipient;

import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.workflow.kaleo.definition.NotificationReceptionType;
import com.liferay.portal.workflow.kaleo.model.KaleoNotificationRecipient;
import com.liferay.portal.workflow.kaleo.model.KaleoTaskAssignmentInstance;
import com.liferay.portal.workflow.kaleo.model.KaleoTaskInstanceToken;
import com.liferay.portal.workflow.kaleo.runtime.ExecutionContext;
import com.liferay.portal.workflow.kaleo.runtime.notification.NotificationRecipient;
import com.liferay.portal.workflow.kaleo.runtime.notification.recipient.NotificationRecipientBuilder;
import java.util.List;
import java.util.Set;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"recipient.type=ASSIGNEES"}, service={NotificationRecipientBuilder.class})
public class AssigneeNotificationRecipientBuilder
implements NotificationRecipientBuilder {
    @Reference(target="(recipient.type=ROLE)")
    private NotificationRecipientBuilder _roleNotificationRecipientBuilder;
    @Reference(target="(recipient.type=USER)")
    private NotificationRecipientBuilder _userNotificationRecipientBuilder;

    public void processKaleoNotificationRecipient(Set<NotificationRecipient> notificationRecipients, KaleoNotificationRecipient kaleoNotificationRecipient, NotificationReceptionType notificationReceptionType, ExecutionContext executionContext) throws Exception {
        this._addAssignedRecipients(notificationRecipients, notificationReceptionType, executionContext);
    }

    public void processKaleoTaskAssignmentInstance(Set<NotificationRecipient> notificationRecipients, KaleoTaskAssignmentInstance kaleoTaskAssignmentInstance, NotificationReceptionType notificationReceptionType, ExecutionContext executionContext) throws Exception {
        this._addAssignedRecipients(notificationRecipients, notificationReceptionType, executionContext);
    }

    private void _addAssignedRecipients(Set<NotificationRecipient> notificationRecipients, NotificationReceptionType notificationReceptionType, ExecutionContext executionContext) throws Exception {
        KaleoTaskInstanceToken kaleoTaskInstanceToken = executionContext.getKaleoTaskInstanceToken();
        if (kaleoTaskInstanceToken == null) {
            return;
        }
        List kaleoTaskAssignmentInstances = kaleoTaskInstanceToken.getKaleoTaskAssignmentInstances();
        for (KaleoTaskAssignmentInstance kaleoTaskAssignmentInstance : kaleoTaskAssignmentInstances) {
            NotificationRecipientBuilder notificationRecipientBuilder = this._roleNotificationRecipientBuilder;
            String assigneeClassName = kaleoTaskAssignmentInstance.getAssigneeClassName();
            if (assigneeClassName.equals(User.class.getName())) {
                notificationRecipientBuilder = this._userNotificationRecipientBuilder;
                ServiceContext serviceContext = executionContext.getServiceContext();
                if (serviceContext.getUserId() == kaleoTaskAssignmentInstance.getAssigneeClassPK()) continue;
            }
            notificationRecipientBuilder.processKaleoTaskAssignmentInstance(notificationRecipients, kaleoTaskAssignmentInstance, notificationReceptionType, executionContext);
        }
    }
}

