/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.workflow.kaleo.runtime.internal.notification.recipient;

import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Organization;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.UserGroupGroupRole;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.OrganizationLocalService;
import com.liferay.portal.kernel.service.RoleLocalService;
import com.liferay.portal.kernel.service.UserGroupGroupRoleLocalService;
import com.liferay.portal.kernel.service.UserGroupRoleLocalService;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.workflow.kaleo.definition.NotificationReceptionType;
import com.liferay.portal.workflow.kaleo.model.KaleoInstanceToken;
import com.liferay.portal.workflow.kaleo.model.KaleoNotificationRecipient;
import com.liferay.portal.workflow.kaleo.model.KaleoTaskAssignmentInstance;
import com.liferay.portal.workflow.kaleo.runtime.ExecutionContext;
import com.liferay.portal.workflow.kaleo.runtime.notification.NotificationRecipient;
import com.liferay.portal.workflow.kaleo.runtime.notification.recipient.NotificationRecipientBuilder;
import com.liferay.portal.workflow.kaleo.runtime.util.validator.GroupAwareRoleValidator;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@Component(immediate=true, property={"recipient.type=ROLE"}, service={NotificationRecipientBuilder.class, RoleNotificationRecipientBuilder.class})
public class RoleNotificationRecipientBuilder
implements NotificationRecipientBuilder {
    private final List<GroupAwareRoleValidator> _groupAwareRoleValidators = new ArrayList<GroupAwareRoleValidator>();
    @Reference
    private GroupLocalService _groupLocalService;
    @Reference
    private OrganizationLocalService _organizationLocalService;
    @Reference
    private RoleLocalService _roleLocalService;
    @Reference
    private UserGroupGroupRoleLocalService _userGroupGroupRoleLocalService;
    @Reference
    private UserGroupRoleLocalService _userGroupRoleLocalService;
    @Reference
    private UserLocalService _userLocalService;

    public void processKaleoNotificationRecipient(Set<NotificationRecipient> notificationRecipients, KaleoNotificationRecipient kaleoNotificationRecipient, NotificationReceptionType notificationReceptionType, ExecutionContext executionContext) throws Exception {
        long roleId = kaleoNotificationRecipient.getRecipientClassPK();
        this.addRoleRecipientAddresses(notificationRecipients, this._roleLocalService.getRole(roleId), notificationReceptionType, executionContext);
    }

    public void processKaleoTaskAssignmentInstance(Set<NotificationRecipient> notificationRecipients, KaleoTaskAssignmentInstance kaleoTaskAssignmentInstance, NotificationReceptionType notificationReceptionType, ExecutionContext executionContext) throws Exception {
        long roleId = kaleoTaskAssignmentInstance.getAssigneeClassPK();
        this.addRoleRecipientAddresses(notificationRecipients, this._roleLocalService.getRole(roleId), notificationReceptionType, executionContext);
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    protected void addGroupAwareRoleValidator(GroupAwareRoleValidator groupAwareRoleValidator) {
        this._groupAwareRoleValidators.add(groupAwareRoleValidator);
    }

    protected void addRoleRecipientAddresses(Set<NotificationRecipient> notificationRecipients, Role role, NotificationReceptionType notificationReceptionType, ExecutionContext executionContext) throws Exception {
        List<User> users = this._getRoleUsers(role, executionContext);
        for (User user : users) {
            if (!user.isActive()) continue;
            NotificationRecipient notificationRecipient = new NotificationRecipient(user, notificationReceptionType);
            notificationRecipients.add(notificationRecipient);
        }
    }

    protected void removeGroupAwareRoleValidator(GroupAwareRoleValidator groupAwareRoleValidator) {
        this._groupAwareRoleValidators.remove(groupAwareRoleValidator);
    }

    private List<Long> _getAncestorGroupIds(Group group, Role role) throws Exception {
        ArrayList<Long> groupIds = new ArrayList<Long>();
        for (Group ancestorGroup : group.getAncestors()) {
            if (!this._isValidGroup(group, role)) continue;
            groupIds.add(ancestorGroup.getGroupId());
        }
        return groupIds;
    }

    private List<Long> _getAncestorOrganizationGroupIds(Group group, Role role) throws Exception {
        ArrayList<Long> groupIds = new ArrayList<Long>();
        Organization organization = this._organizationLocalService.getOrganization(group.getOrganizationId());
        for (Organization ancestorOrganization : organization.getAncestors()) {
            if (!this._isValidGroup(group, role)) continue;
            groupIds.add(ancestorOrganization.getGroupId());
        }
        return groupIds;
    }

    private List<Long> _getGroupIds(long groupId, Role role) throws Exception {
        ArrayList<Long> groupIds = new ArrayList<Long>();
        if (groupId != 0L) {
            Group group = this._groupLocalService.getGroup(groupId);
            if (group.isOrganization()) {
                groupIds.addAll(this._getAncestorOrganizationGroupIds(group, role));
            }
            if (group.isSite()) {
                groupIds.addAll(this._getAncestorGroupIds(group, role));
            }
            if (this._isValidGroup(group, role)) {
                groupIds.add(groupId);
            }
        }
        return groupIds;
    }

    private List<User> _getRoleUsers(Role role, ExecutionContext executionContext) throws Exception {
        long roleId = role.getRoleId();
        if (role.getType() == 1) {
            return this._userLocalService.getInheritedRoleUsers(roleId, -1, -1, null);
        }
        KaleoInstanceToken kaleoInstanceToken = executionContext.getKaleoInstanceToken();
        List<Long> groupIds = this._getGroupIds(kaleoInstanceToken.getGroupId(), role);
        ArrayList<User> users = new ArrayList<User>();
        for (Long groupId : groupIds) {
            Group group;
            Object userGroupRole2;
            List userGroupRoles = this._userGroupRoleLocalService.getUserGroupRolesByGroupAndRole(groupId.longValue(), roleId);
            for (Object userGroupRole2 : userGroupRoles) {
                users.add(userGroupRole2.getUser());
            }
            List userGroupGroupRoles = this._userGroupGroupRoleLocalService.getUserGroupGroupRolesByGroupAndRole(groupId.longValue(), roleId);
            userGroupRole2 = userGroupGroupRoles.iterator();
            while (userGroupRole2.hasNext()) {
                UserGroupGroupRole userGroupGroupRole = (UserGroupGroupRole)userGroupRole2.next();
                users.addAll(this._userLocalService.getUserGroupUsers(userGroupGroupRole.getUserGroupId()));
            }
            if (Objects.equals(role.getName(), "Asset Library Member") || Objects.equals(role.getName(), "Site Member")) {
                users.addAll(this._userLocalService.getGroupUsers(groupId.longValue(), 0, null));
            }
            if (!Objects.equals(role.getName(), "Organization User") || !(group = this._groupLocalService.getGroup(groupId.longValue())).isOrganization()) continue;
            long organizationId = group.getClassPK();
            users.addAll(this._userLocalService.getOrganizationUsers(organizationId));
        }
        return users;
    }

    private boolean _isValidGroup(Group group, Role role) throws Exception {
        if (group != null && group.isDepot() && role.getType() == 5) {
            return true;
        }
        if (group != null && group.isOrganization() && role.getType() == 3) {
            return true;
        }
        if (group != null && group.isSite() && role.getType() == 2) {
            return true;
        }
        for (GroupAwareRoleValidator groupAwareRoleValidator : this._groupAwareRoleValidators) {
            if (!groupAwareRoleValidator.isValidGroup(group, role)) continue;
            return true;
        }
        return false;
    }
}

