/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.workflow.kaleo.runtime.internal.assignment;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.ClassUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.workflow.kaleo.model.KaleoTaskAssignment;
import com.liferay.portal.workflow.kaleo.runtime.ExecutionContext;
import com.liferay.portal.workflow.kaleo.runtime.assignment.KaleoTaskAssignmentSelector;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@Component(immediate=true, service={CompositeKaleoTaskAssignmentSelector.class})
public class CompositeKaleoTaskAssignmentSelector
implements KaleoTaskAssignmentSelector {
    private final Map<String, KaleoTaskAssignmentSelector> _kaleoTaskAssignmentSelectors = new HashMap<String, KaleoTaskAssignmentSelector>();

    public Collection<KaleoTaskAssignment> getKaleoTaskAssignments(KaleoTaskAssignment kaleoTaskAssignment, ExecutionContext executionContext) throws PortalException {
        String assigneeClassName = kaleoTaskAssignment.getAssigneeClassName();
        KaleoTaskAssignmentSelector kaleoTaskAssignmentSelector = this._kaleoTaskAssignmentSelectors.get(assigneeClassName);
        if (kaleoTaskAssignmentSelector == null) {
            throw new IllegalArgumentException("No task assignment selector found for class name " + assigneeClassName);
        }
        return kaleoTaskAssignmentSelector.getKaleoTaskAssignments(kaleoTaskAssignment, executionContext);
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY, target="(assignee.class.name=*)")
    protected void addKaleoTaskAssignmentSelector(KaleoTaskAssignmentSelector kaleoTaskAssignmentSelector, Map<String, Object> properties) {
        String[] assigneeClassNames;
        for (String assigneeClassName : assigneeClassNames = this._getAssigneeClassNames(kaleoTaskAssignmentSelector, properties)) {
            this._kaleoTaskAssignmentSelectors.put(assigneeClassName, kaleoTaskAssignmentSelector);
        }
    }

    protected void removeKaleoTaskAssignmentSelector(KaleoTaskAssignmentSelector kaleoTaskAssignmentSelector, Map<String, Object> properties) {
        String[] assigneeClassNames;
        for (String assigneeClassName : assigneeClassNames = this._getAssigneeClassNames(kaleoTaskAssignmentSelector, properties)) {
            this._kaleoTaskAssignmentSelectors.remove(assigneeClassName);
        }
    }

    private String[] _getAssigneeClassNames(KaleoTaskAssignmentSelector kaleoTaskAssignmentSelector, Map<String, Object> properties) {
        Object value = properties.get("assignee.class.name");
        Object[] assigneeClassNames = GetterUtil.getStringValues((Object)value, (String[])new String[]{String.valueOf(value)});
        if (ArrayUtil.isEmpty((Object[])assigneeClassNames)) {
            throw new IllegalArgumentException("The property \"assignee.class.name\" is invalid for " + ClassUtil.getClassName((Object)kaleoTaskAssignmentSelector));
        }
        return assigneeClassNames;
    }
}

