/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.workflow.kaleo.runtime.internal.assignment;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Organization;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.OrganizationLocalService;
import com.liferay.portal.kernel.service.RoleLocalService;
import com.liferay.portal.workflow.kaleo.KaleoTaskAssignmentFactory;
import com.liferay.portal.workflow.kaleo.model.KaleoInstanceToken;
import com.liferay.portal.workflow.kaleo.model.KaleoTaskAssignment;
import com.liferay.portal.workflow.kaleo.runtime.ExecutionContext;
import com.liferay.portal.workflow.kaleo.runtime.assignment.KaleoTaskAssignmentSelector;
import com.liferay.portal.workflow.kaleo.runtime.util.validator.GroupAwareRoleValidator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@Component(immediate=true, property={"assignee.class.name=com.liferay.portal.kernel.model.Role"}, service={KaleoTaskAssignmentSelector.class})
public class GroupAwareRoleKaleoTaskAssignmentSelector
implements KaleoTaskAssignmentSelector {
    private final List<GroupAwareRoleValidator> _groupAwareRoleValidators = new ArrayList<GroupAwareRoleValidator>();
    @Reference
    private GroupLocalService _groupLocalService;
    @Reference
    private KaleoTaskAssignmentFactory _kaleoTaskAssignmentFactory;
    @Reference
    private OrganizationLocalService _organizationLocalService;
    @Reference
    private RoleLocalService _roleLocalService;

    public Collection<KaleoTaskAssignment> getKaleoTaskAssignments(KaleoTaskAssignment kaleoTaskAssignment, ExecutionContext executionContext) throws PortalException {
        KaleoInstanceToken kaleoInstanceToken = executionContext.getKaleoInstanceToken();
        return this._createKaleoTaskAssigments(kaleoInstanceToken.getGroupId(), this._roleLocalService.getRole(kaleoTaskAssignment.getAssigneeClassPK()));
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    protected void addGroupAwareRoleValidator(GroupAwareRoleValidator groupAwareRoleValidator) {
        this._groupAwareRoleValidators.add(groupAwareRoleValidator);
    }

    protected void removeGroupAwareRoleValidator(GroupAwareRoleValidator groupAwareRoleValidator) {
        this._groupAwareRoleValidators.remove(groupAwareRoleValidator);
    }

    private List<KaleoTaskAssignment> _createKaleoTaskAssigments(long groupId, Role role) throws PortalException {
        ArrayList<Long> groupIds = new ArrayList<Long>();
        Group group = null;
        if (groupId != 0L) {
            group = this._groupLocalService.getGroup(groupId);
            if (group.isOrganization()) {
                groupIds.addAll(this._getAncestorOrganizationGroupIds(group, role));
            }
            if (group.isSite()) {
                groupIds.addAll(this._getAncestorGroupIds(group, role));
            }
            if (group.isLayout()) {
                group = this._groupLocalService.getGroup(group.getParentGroupId());
            }
        }
        if (this._isValidAssignment(group, role)) {
            groupIds.add(groupId);
        }
        return this._createKaleoTaskAssigments(role, groupIds);
    }

    private List<KaleoTaskAssignment> _createKaleoTaskAssigments(Role role, List<Long> groupIds) throws PortalException {
        ArrayList<KaleoTaskAssignment> kaleoTaskAssignments = new ArrayList<KaleoTaskAssignment>();
        for (Long groupId : groupIds) {
            kaleoTaskAssignments.add(this._createKaleoTaskAssignment(role, groupId));
        }
        return kaleoTaskAssignments;
    }

    private KaleoTaskAssignment _createKaleoTaskAssignment(Role role, long groupId) {
        KaleoTaskAssignment kaleoTaskAssignment = this._kaleoTaskAssignmentFactory.createKaleoTaskAssignment();
        kaleoTaskAssignment.setGroupId(groupId);
        kaleoTaskAssignment.setAssigneeClassName(Role.class.getName());
        kaleoTaskAssignment.setAssigneeClassPK(role.getRoleId());
        return kaleoTaskAssignment;
    }

    private List<Long> _getAncestorGroupIds(Group group, Role role) throws PortalException {
        ArrayList<Long> groupIds = new ArrayList<Long>();
        for (Group ancestorGroup : group.getAncestors()) {
            if (!this._isValidAssignment(group, role)) continue;
            groupIds.add(ancestorGroup.getGroupId());
        }
        return groupIds;
    }

    private List<Long> _getAncestorOrganizationGroupIds(Group group, Role role) throws PortalException {
        ArrayList<Long> groupIds = new ArrayList<Long>();
        Organization organization = this._organizationLocalService.getOrganization(group.getOrganizationId());
        for (Organization ancestorOrganization : organization.getAncestors()) {
            if (!this._isValidAssignment(group, role)) continue;
            groupIds.add(ancestorOrganization.getGroupId());
        }
        return groupIds;
    }

    private boolean _isValidAssignment(Group group, Role role) throws PortalException {
        if (group != null && group.isDepot() && role.getType() == 5) {
            return true;
        }
        if (role.getType() == 1) {
            return true;
        }
        if (group != null && group.isOrganization() && role.getType() == 3) {
            return true;
        }
        if (group != null && group.isSite() && role.getType() == 2) {
            return true;
        }
        for (GroupAwareRoleValidator groupAwareRoleValidator : this._groupAwareRoleValidators) {
            if (!groupAwareRoleValidator.isValidGroup(group, role)) continue;
            return true;
        }
        return false;
    }
}

