/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.workflow.kaleo.runtime.internal.graph;

import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.change.tracking.CTAware;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.transaction.Isolation;
import com.liferay.portal.kernel.transaction.Propagation;
import com.liferay.portal.kernel.transaction.Transactional;
import com.liferay.portal.workflow.kaleo.model.KaleoNode;
import com.liferay.portal.workflow.kaleo.runtime.ExecutionContext;
import com.liferay.portal.workflow.kaleo.runtime.graph.GraphWalker;
import com.liferay.portal.workflow.kaleo.runtime.graph.PathElement;
import com.liferay.portal.workflow.kaleo.runtime.internal.BaseKaleoBean;
import com.liferay.portal.workflow.kaleo.runtime.internal.node.NodeExecutorFactory;
import com.liferay.portal.workflow.kaleo.runtime.node.NodeExecutor;
import com.liferay.portal.workflow.kaleo.runtime.util.ExecutionContextHelper;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@CTAware
@Transactional(isolation=Isolation.PORTAL, propagation=Propagation.REQUIRES_NEW, rollbackFor={Exception.class})
@Component(immediate=true, service={AopService.class})
public class DefaultGraphWalker
extends BaseKaleoBean
implements AopService,
GraphWalker {
    @Reference
    private ExecutionContextHelper _executionContextHelper;
    @Reference
    private NodeExecutorFactory _nodeExecutorFactory;

    public void follow(KaleoNode sourceKaleoNode, KaleoNode targetKaleoNode, List<PathElement> remainingPathElements, ExecutionContext executionContext) throws PortalException {
        NodeExecutor nodeExecutor;
        if (sourceKaleoNode != null) {
            nodeExecutor = this._nodeExecutorFactory.getNodeExecutor(sourceKaleoNode.getType());
            nodeExecutor.exit(sourceKaleoNode, executionContext, remainingPathElements);
        }
        if (targetKaleoNode != null) {
            this.kaleoLogLocalService.addNodeEntryKaleoLog(executionContext.getKaleoInstanceToken(), sourceKaleoNode, targetKaleoNode, executionContext.getServiceContext());
            nodeExecutor = this._nodeExecutorFactory.getNodeExecutor(targetKaleoNode.getType());
            boolean performExecute = nodeExecutor.enter(targetKaleoNode, executionContext);
            if (performExecute) {
                nodeExecutor.execute(targetKaleoNode, executionContext, remainingPathElements);
            }
        }
        this._executionContextHelper.checkKaleoInstanceComplete(executionContext);
    }
}

