/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.workflow.kaleo.runtime.internal.node;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.workflow.kaleo.model.KaleoInstanceToken;
import com.liferay.portal.workflow.kaleo.model.KaleoNode;
import com.liferay.portal.workflow.kaleo.model.KaleoTransition;
import com.liferay.portal.workflow.kaleo.runtime.ExecutionContext;
import com.liferay.portal.workflow.kaleo.runtime.graph.PathElement;
import com.liferay.portal.workflow.kaleo.runtime.node.BaseNodeExecutor;
import com.liferay.portal.workflow.kaleo.runtime.node.NodeExecutor;
import com.liferay.portal.workflow.kaleo.service.KaleoInstanceTokenLocalService;
import java.util.HashMap;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"node.type=FORK"}, service={NodeExecutor.class})
public class ForkNodeExecutor
extends BaseNodeExecutor {
    @Reference
    private KaleoInstanceTokenLocalService _kaleoInstanceTokenLocalService;

    protected boolean doEnter(KaleoNode currentKaleoNode, ExecutionContext executionContext) {
        return true;
    }

    protected void doExecute(KaleoNode currentKaleoNode, ExecutionContext executionContext, List<PathElement> remainingPathElements) throws PortalException {
        List kaleoTransitions = currentKaleoNode.getKaleoTransitions();
        HashMap<String, KaleoInstanceToken> childKaleoInstanceTokens = new HashMap<String, KaleoInstanceToken>();
        for (KaleoTransition kaleoTransition : kaleoTransitions) {
            KaleoInstanceToken parentKaleoInstanceToken = executionContext.getKaleoInstanceToken();
            KaleoInstanceToken childKaleoInstanceToken = this._kaleoInstanceTokenLocalService.addKaleoInstanceToken(parentKaleoInstanceToken.getKaleoInstanceTokenId(), executionContext.getWorkflowContext(), executionContext.getServiceContext());
            childKaleoInstanceTokens.put(kaleoTransition.getName(), childKaleoInstanceToken);
        }
        for (KaleoTransition kaleoTransition : kaleoTransitions) {
            KaleoInstanceToken childKaleoInstanceToken = (KaleoInstanceToken)childKaleoInstanceTokens.get(kaleoTransition.getName());
            ExecutionContext forkedExecutionContext = new ExecutionContext(childKaleoInstanceToken, executionContext.getWorkflowContext(), executionContext.getServiceContext());
            PathElement pathElement = new PathElement(currentKaleoNode, kaleoTransition.getTargetKaleoNode(), forkedExecutionContext);
            remainingPathElements.add(pathElement);
        }
    }

    protected void doExit(KaleoNode currentKaleoNode, ExecutionContext executionContext, List<PathElement> remainingPathElements) {
    }
}

