/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.workflow.kaleo.runtime.internal.node;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.workflow.kaleo.model.KaleoInstanceToken;
import com.liferay.portal.workflow.kaleo.model.KaleoNode;
import com.liferay.portal.workflow.kaleo.model.KaleoTask;
import com.liferay.portal.workflow.kaleo.model.KaleoTaskInstanceToken;
import com.liferay.portal.workflow.kaleo.model.KaleoTransition;
import com.liferay.portal.workflow.kaleo.runtime.ExecutionContext;
import com.liferay.portal.workflow.kaleo.runtime.graph.PathElement;
import com.liferay.portal.workflow.kaleo.runtime.node.BaseNodeExecutor;
import com.liferay.portal.workflow.kaleo.runtime.node.NodeExecutor;
import com.liferay.portal.workflow.kaleo.service.KaleoInstanceTokenLocalService;
import com.liferay.portal.workflow.kaleo.service.KaleoTaskAssignmentInstanceLocalService;
import com.liferay.portal.workflow.kaleo.service.KaleoTaskInstanceTokenLocalService;
import com.liferay.portal.workflow.kaleo.service.KaleoTaskLocalService;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"node.type=JOIN_XOR"}, service={NodeExecutor.class})
public class JoinXorNodeExecutor
extends BaseNodeExecutor {
    @Reference
    private KaleoInstanceTokenLocalService _kaleoInstanceTokenLocalService;
    @Reference
    private KaleoTaskAssignmentInstanceLocalService _kaleoTaskAssignmentInstanceLocalService;
    @Reference
    private KaleoTaskInstanceTokenLocalService _kaleoTaskInstanceTokenLocalService;
    @Reference
    private KaleoTaskLocalService _kaleoTaskLocalService;

    protected boolean doEnter(KaleoNode currentKaleoNode, ExecutionContext executionContext) throws PortalException {
        KaleoInstanceToken kaleoInstanceToken = executionContext.getKaleoInstanceToken();
        if ((kaleoInstanceToken = this._kaleoInstanceTokenLocalService.getKaleoInstanceToken(kaleoInstanceToken.getKaleoInstanceTokenId())).isCompleted()) {
            return false;
        }
        KaleoInstanceToken parentKaleoInstanceToken = (kaleoInstanceToken = this._kaleoInstanceTokenLocalService.completeKaleoInstanceToken(kaleoInstanceToken.getKaleoInstanceTokenId())).getParentKaleoInstanceToken();
        if (!parentKaleoInstanceToken.hasIncompleteChildrenKaleoInstanceToken()) {
            return false;
        }
        List childrenKaleoInstanceTokens = parentKaleoInstanceToken.getChildrenKaleoInstanceTokens();
        for (KaleoInstanceToken childrenKaleoInstanceToken : childrenKaleoInstanceTokens) {
            this._kaleoInstanceTokenLocalService.completeKaleoInstanceToken(childrenKaleoInstanceToken.getKaleoInstanceTokenId());
        }
        this._completeChildrenKaleoTaskInstanceTokens(parentKaleoInstanceToken, currentKaleoNode, executionContext.getServiceContext());
        return true;
    }

    protected void doExecute(KaleoNode currentKaleoNode, ExecutionContext executionContext, List<PathElement> remainingPathElements) throws PortalException {
        KaleoInstanceToken kaleoInstanceToken = executionContext.getKaleoInstanceToken();
        KaleoInstanceToken parentKaleoInstanceToken = kaleoInstanceToken.getParentKaleoInstanceToken();
        if (parentKaleoInstanceToken.getCurrentKaleoNodeId() == currentKaleoNode.getKaleoNodeId()) {
            return;
        }
        parentKaleoInstanceToken = this._kaleoInstanceTokenLocalService.updateKaleoInstanceToken(parentKaleoInstanceToken.getKaleoInstanceTokenId(), currentKaleoNode.getKaleoNodeId());
        KaleoTransition kaleoTransition = currentKaleoNode.getDefaultKaleoTransition();
        ExecutionContext newExecutionContext = new ExecutionContext(parentKaleoInstanceToken, executionContext.getWorkflowContext(), executionContext.getServiceContext());
        PathElement pathElement = new PathElement(currentKaleoNode, kaleoTransition.getTargetKaleoNode(), newExecutionContext);
        remainingPathElements.add(pathElement);
    }

    protected void doExit(KaleoNode currentKaleoNode, ExecutionContext executionContext, List<PathElement> remainingPathElements) {
    }

    private void _completeChildrenKaleoTaskInstanceTokens(KaleoInstanceToken kaleoInstanceToken, KaleoNode stopKaleoNode, ServiceContext serviceContext) throws PortalException {
        List<KaleoTaskInstanceToken> kaleoTaskInstanceTokens = this._getChildrentKaleoTaskInstanceTokens(kaleoInstanceToken, stopKaleoNode, serviceContext);
        for (KaleoTaskInstanceToken kaleoTaskInstanceToken : kaleoTaskInstanceTokens) {
            this._completeKaleoTaskInstanceToken(kaleoTaskInstanceToken, serviceContext);
        }
    }

    private void _completeKaleoTaskInstanceToken(KaleoTaskInstanceToken kaleoTaskInstanceToken, ServiceContext serviceContext) throws PortalException {
        this._kaleoTaskAssignmentInstanceLocalService.assignKaleoTaskAssignmentInstance(kaleoTaskInstanceToken, User.class.getName(), serviceContext.getUserId(), serviceContext);
        long kaleoTaskInstanceTokenId = kaleoTaskInstanceToken.getKaleoTaskInstanceTokenId();
        this._kaleoTaskAssignmentInstanceLocalService.completeKaleoTaskInstanceToken(kaleoTaskInstanceTokenId, serviceContext);
        this._kaleoTaskInstanceTokenLocalService.completeKaleoTaskInstanceToken(kaleoTaskInstanceTokenId, serviceContext);
    }

    private List<KaleoTaskInstanceToken> _getChildrentKaleoTaskInstanceTokens(KaleoInstanceToken currentKaleoInstanceToken, KaleoNode stopKaleoNode, ServiceContext serviceContext) throws PortalException {
        if (this._isFinalKaleoInstanceToken(currentKaleoInstanceToken, stopKaleoNode)) {
            return Collections.emptyList();
        }
        KaleoNode currentKaleoNode = currentKaleoInstanceToken.getCurrentKaleoNode();
        ArrayList<KaleoTaskInstanceToken> kaleoTaskInstanceTokens = new ArrayList<KaleoTaskInstanceToken>();
        String type = currentKaleoNode.getType();
        if (type.equals("TASK")) {
            KaleoTaskInstanceToken kaleoTaskInstanceToken = this._getKaleoTaksInstanceToken(currentKaleoNode, currentKaleoInstanceToken);
            kaleoTaskInstanceTokens.add(kaleoTaskInstanceToken);
        }
        for (KaleoInstanceToken childKaleoInstanceToken : currentKaleoInstanceToken.getChildrenKaleoInstanceTokens()) {
            kaleoTaskInstanceTokens.addAll(this._getChildrentKaleoTaskInstanceTokens(childKaleoInstanceToken, stopKaleoNode, serviceContext));
        }
        return kaleoTaskInstanceTokens;
    }

    private KaleoTaskInstanceToken _getKaleoTaksInstanceToken(KaleoNode kaleoNode, KaleoInstanceToken kaleoInstanceToken) throws PortalException {
        KaleoTask kaleoTask = this._kaleoTaskLocalService.getKaleoNodeKaleoTask(kaleoNode.getKaleoNodeId());
        return this._kaleoTaskInstanceTokenLocalService.getKaleoTaskInstanceTokens(kaleoInstanceToken.getKaleoInstanceId(), kaleoTask.getKaleoTaskId());
    }

    private boolean _isFinalKaleoInstanceToken(KaleoInstanceToken kaleoInstanceToken, KaleoNode stopKaleoNode) throws PortalException {
        if (kaleoInstanceToken.getCurrentKaleoNodeId() == stopKaleoNode.getKaleoNodeId()) {
            return true;
        }
        KaleoNode kaleoNode = kaleoInstanceToken.getCurrentKaleoNode();
        return kaleoNode.isTerminal();
    }
}

