/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.workflow.kaleo.runtime.internal.node;

import com.liferay.portal.workflow.kaleo.definition.NodeTypeDependentObjectRegistry;
import com.liferay.portal.workflow.kaleo.definition.exception.KaleoDefinitionValidationException;
import com.liferay.portal.workflow.kaleo.runtime.node.NodeExecutor;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@Component(immediate=true, service={NodeExecutorFactory.class})
public class NodeExecutorFactory {
    private final NodeTypeDependentObjectRegistry<NodeExecutor> _nodeExecutors = new NodeTypeDependentObjectRegistry();

    public NodeExecutor getNodeExecutor(String nodeTypeString) throws KaleoDefinitionValidationException {
        return (NodeExecutor)this._nodeExecutors.getNodeTypeDependentObjects(nodeTypeString);
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    protected void addNodeExporter(NodeExecutor nodeExecutor, Map<String, Object> properties) {
        String nodeType = (String)properties.get("node.type");
        if (nodeType == null) {
            throw new IllegalArgumentException("The property \"node.type\" is null");
        }
        this._nodeExecutors.addNodeTypeDependentObject(nodeType, (Object)nodeExecutor);
    }

    protected void removeNodeExporter(NodeExecutor nodeExecutor, Map<String, Object> properties) {
        String nodeType = (String)properties.get("node.type");
        if (nodeType == null) {
            throw new IllegalArgumentException("The property \"node.type\" is null");
        }
        this._nodeExecutors.removeNodeTypeDependentObjects(nodeType);
    }
}

