/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.workflow.kaleo.runtime.internal.notification;

import com.liferay.mail.kernel.model.MailMessage;
import com.liferay.mail.kernel.service.MailService;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.workflow.kaleo.definition.NotificationReceptionType;
import com.liferay.portal.workflow.kaleo.runtime.ExecutionContext;
import com.liferay.portal.workflow.kaleo.runtime.internal.settings.WorkflowGroupServiceSettings;
import com.liferay.portal.workflow.kaleo.runtime.notification.BaseNotificationSender;
import com.liferay.portal.workflow.kaleo.runtime.notification.NotificationRecipient;
import com.liferay.portal.workflow.kaleo.runtime.notification.NotificationSender;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import javax.mail.internet.InternetAddress;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"fromAddress=no-reply@liferay.com", "fromName=Liferay Portal Workflow Notifications", "notification.type=email"}, service={NotificationSender.class})
public class EmailNotificationSender
extends BaseNotificationSender
implements NotificationSender {
    private String _fromAddress;
    private String _fromName;
    @Reference
    private MailService _mailService;

    protected void activate(Map<String, Object> properties) {
        this._fromAddress = (String)properties.get("fromAddress");
        this._fromName = (String)properties.get("fromName");
    }

    protected void doSendNotification(Map<NotificationReceptionType, Set<NotificationRecipient>> notificationRecipients, String defaultSubject, String notificationMessage, ExecutionContext executionContext) throws Exception {
        String fromName;
        Map workflowContext = executionContext.getWorkflowContext();
        long companyId = GetterUtil.getLong(workflowContext.get("companyId"));
        WorkflowGroupServiceSettings workflowGroupServiceSettings = WorkflowGroupServiceSettings.getInstance(companyId);
        String fromAddress = (String)workflowContext.get("notificationSenderAddress");
        if (Validator.isNull((String)fromAddress)) {
            fromAddress = workflowGroupServiceSettings.getEmailFromAddress();
        }
        if (Validator.isNull((String)fromAddress)) {
            fromAddress = this._fromAddress;
        }
        if (Validator.isNull((String)(fromName = (String)workflowContext.get("notificationSenderName")))) {
            fromName = workflowGroupServiceSettings.getEmailFromName();
        }
        if (Validator.isNull((String)fromName)) {
            fromName = this._fromName;
        }
        InternetAddress from = new InternetAddress(fromAddress, fromName);
        String subject = (String)workflowContext.get("notificationSubject");
        if (Validator.isNull((String)subject)) {
            subject = defaultSubject;
        }
        MailMessage mailMessage = new MailMessage(from, subject, notificationMessage, true);
        mailMessage.setTo(this._getInternetAddresses(this.getDeliverableNotificationRecipients(notificationRecipients.get(NotificationReceptionType.TO), 10000)));
        mailMessage.setCC(this._getInternetAddresses(this.getDeliverableNotificationRecipients(notificationRecipients.get(NotificationReceptionType.CC), 10000)));
        mailMessage.setBCC(this._getInternetAddresses(this.getDeliverableNotificationRecipients(notificationRecipients.get(NotificationReceptionType.BCC), 10000)));
        this._mailService.sendEmail(mailMessage);
    }

    private InternetAddress[] _getInternetAddresses(Set<NotificationRecipient> notificationRecipients) throws Exception {
        if (notificationRecipients == null) {
            return new InternetAddress[0];
        }
        ArrayList<InternetAddress> internetAddresses = new ArrayList<InternetAddress>(notificationRecipients.size());
        for (NotificationRecipient notificationRecipient : notificationRecipients) {
            internetAddresses.add(notificationRecipient.getInternetAddress());
        }
        return internetAddresses.toArray(new InternetAddress[0]);
    }
}

