/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.workflow.kaleo.runtime.internal.notification;

import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.ClassUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.workflow.WorkflowException;
import com.liferay.portal.workflow.kaleo.runtime.notification.NotificationMessageGenerator;
import java.util.HashMap;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@Component(immediate=true, service={NotificationMessageGeneratorFactory.class})
public class NotificationMessageGeneratorFactory {
    private final Map<String, NotificationMessageGenerator> _notificationMessageGenerators = new HashMap<String, NotificationMessageGenerator>();

    public NotificationMessageGenerator getNotificationMessageGenerator(String templateLanguage) throws WorkflowException {
        NotificationMessageGenerator notificationMessageGenerator = this._notificationMessageGenerators.get(templateLanguage);
        if (notificationMessageGenerator == null) {
            throw new WorkflowException("Invalid template language " + templateLanguage);
        }
        return notificationMessageGenerator;
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY, target="(template.language=*)")
    protected void addNotificationMessageGenerator(NotificationMessageGenerator notificationMessageGenerator, Map<String, Object> properties) {
        String[] templateLanguages;
        for (String templateLanguage : templateLanguages = this._getTemplateLanguages(notificationMessageGenerator, properties)) {
            this._notificationMessageGenerators.put(templateLanguage, notificationMessageGenerator);
        }
    }

    protected void removeNotificationMessageGenerator(NotificationMessageGenerator notificationMessageGenerator, Map<String, Object> properties) {
        String[] templateLanguages;
        for (String templateLanguage : templateLanguages = this._getTemplateLanguages(notificationMessageGenerator, properties)) {
            this._notificationMessageGenerators.remove(templateLanguage);
        }
    }

    private String[] _getTemplateLanguages(NotificationMessageGenerator notificationMessageGenerator, Map<String, Object> properties) {
        Object value = properties.get("template.language");
        Object[] templateLanguages = GetterUtil.getStringValues((Object)value, (String[])new String[]{String.valueOf(value)});
        if (ArrayUtil.isEmpty((Object[])templateLanguages)) {
            throw new IllegalArgumentException("The property \"template.language\" is invalid for " + ClassUtil.getClassName((Object)notificationMessageGenerator));
        }
        return templateLanguages;
    }
}

