/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.workflow.kaleo.runtime.internal.assignment;

import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMap;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMapFactory;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.module.configuration.ConfigurationProviderUtil;
import com.liferay.portal.kernel.settings.SettingsLocator;
import com.liferay.portal.kernel.settings.SystemSettingsLocator;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.workflow.kaleo.model.KaleoInstanceToken;
import com.liferay.portal.workflow.kaleo.model.KaleoTaskAssignment;
import com.liferay.portal.workflow.kaleo.runtime.ExecutionContext;
import com.liferay.portal.workflow.kaleo.runtime.assignment.BaseKaleoTaskAssignmentSelector;
import com.liferay.portal.workflow.kaleo.runtime.assignment.KaleoTaskAssignmentSelector;
import com.liferay.portal.workflow.kaleo.runtime.assignment.ScriptingAssigneeSelector;
import com.liferay.portal.workflow.kaleo.runtime.internal.cache.KaleoTaskScriptedAssignmentCache;
import com.liferay.portal.workflow.kaleo.runtime.internal.configuration.WorkflowTaskScriptConfiguration;
import com.liferay.portal.workflow.kaleo.runtime.internal.util.ServiceSelectorUtil;
import com.liferay.portal.workflow.kaleo.service.KaleoInstanceLocalService;
import java.util.Collection;
import java.util.List;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(property={"assignee.class.name=SCRIPT"}, service={KaleoTaskAssignmentSelector.class})
public class MultiLanguageKaleoTaskAssignmentSelector
extends BaseKaleoTaskAssignmentSelector {
    @Reference
    private KaleoInstanceLocalService _kaleoInstanceLocalService;
    @Reference
    private KaleoTaskScriptedAssignmentCache _kaleoTaskScriptedAssignmentCache;
    private ServiceTrackerMap<String, List<ScriptingAssigneeSelector>> _serviceTrackerMap;

    public Collection<KaleoTaskAssignment> getKaleoTaskAssignments(KaleoTaskAssignment kaleoTaskAssignment, ExecutionContext executionContext) throws PortalException {
        ScriptingAssigneeSelector scriptingAssigneeSelector = ServiceSelectorUtil.getServiceByScriptLanguage(StringUtil.trim((String)kaleoTaskAssignment.getAssigneeScript()), kaleoTaskAssignment.getAssigneeScriptLanguage(), this._serviceTrackerMap);
        if (scriptingAssigneeSelector == null) {
            throw new IllegalArgumentException("No task assignment selector found for " + kaleoTaskAssignment.toString());
        }
        Collection kaleoTaskAssignments = null;
        WorkflowTaskScriptConfiguration workflowTaskScriptConfiguration = (WorkflowTaskScriptConfiguration)ConfigurationProviderUtil.getConfiguration(WorkflowTaskScriptConfiguration.class, (SettingsLocator)new SystemSettingsLocator(WorkflowTaskScriptConfiguration.class.getName()));
        int scriptedAssignmentCacheExpirationTime = workflowTaskScriptConfiguration.scriptedAssignmentCacheExpirationTime();
        if (scriptedAssignmentCacheExpirationTime > 0) {
            kaleoTaskAssignments = this._kaleoTaskScriptedAssignmentCache.getKaleoTaskAssignments(kaleoTaskAssignment.getKaleoTaskAssignmentId());
        }
        if (kaleoTaskAssignments == null) {
            kaleoTaskAssignments = this.getKaleoTaskAssignments(scriptingAssigneeSelector.getAssignees(executionContext, kaleoTaskAssignment));
            if (scriptedAssignmentCacheExpirationTime > 0) {
                this._kaleoTaskScriptedAssignmentCache.putKaleoTaskAssignments(kaleoTaskAssignment.getKaleoTaskAssignmentId(), kaleoTaskAssignments, scriptedAssignmentCacheExpirationTime * 60);
            }
        }
        KaleoInstanceToken kaleoInstanceToken = executionContext.getKaleoInstanceToken();
        this._kaleoInstanceLocalService.updateKaleoInstance(kaleoInstanceToken.getKaleoInstanceId(), executionContext.getWorkflowContext());
        return kaleoTaskAssignments;
    }

    @Activate
    protected void activate(BundleContext bundleContext) {
        this._serviceTrackerMap = ServiceTrackerMapFactory.openMultiValueMap((BundleContext)bundleContext, ScriptingAssigneeSelector.class, (String)"scripting.language");
    }

    @Deactivate
    protected void deactivate() {
        this._serviceTrackerMap.close();
    }
}

