/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.workflow.kaleo.runtime.internal.manager;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.language.Language;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.WorkflowDefinitionLink;
import com.liferay.portal.kernel.service.CompanyLocalService;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.RoleLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.settings.LocalizedValuesMap;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.Localization;
import com.liferay.portal.kernel.util.ResourceBundleUtil;
import com.liferay.portal.kernel.workflow.WorkflowDefinition;
import com.liferay.portal.kernel.workflow.WorkflowDefinitionManager;
import com.liferay.portal.workflow.comparator.WorkflowComparatorFactory;
import com.liferay.portal.workflow.kaleo.runtime.internal.BaseKaleoBean;
import com.liferay.portal.workflow.kaleo.runtime.manager.PortalKaleoManager;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={PortalKaleoManager.class})
public class DefaultPortalKaleoManager
extends BaseKaleoBean
implements PortalKaleoManager {
    @Reference
    protected CompanyLocalService companyLocalService;
    @Reference
    protected GroupLocalService groupLocalService;
    @Reference
    protected RoleLocalService roleLocalService;
    @Reference
    protected UserLocalService userLocalService;
    @Reference
    protected WorkflowComparatorFactory workflowComparatorFactory;
    private static final String _DEFINITION_NAME = "Single Approver";
    private static final Log _log = LogFactoryUtil.getLog(DefaultPortalKaleoManager.class);
    private final Map<String, String> _defaultRoles = new HashMap<String, String>();
    private final Map<String, String> _definitionAssets = new HashMap<String, String>();
    private final Map<String, String> _definitionFiles = HashMapBuilder.put((Object)"Single Approver", (Object)"META-INF/definitions/single-approver-workflow-definition.xml").build();
    @Reference
    private Language _language;
    @Reference
    private Localization _localization;
    @Reference
    private WorkflowDefinitionManager _workflowDefinitionManager;

    public void deleteKaleoData(long companyId) throws Exception {
        this.kaleoDefinitionLocalService.deleteCompanyKaleoDefinitions(companyId);
        this.kaleoLogLocalService.deleteCompanyKaleoLogs(companyId);
    }

    public void deployDefaultDefinitionLink(String assetClassName) throws Exception {
        this.companyLocalService.forEachCompanyId(companyId -> {
            try {
                User guestUser = this.userLocalService.getGuestUser(companyId.longValue());
                Group companyGroup = this.groupLocalService.getCompanyGroup(companyId.longValue());
                String definitionName = _DEFINITION_NAME;
                if (this._definitionAssets.containsKey(assetClassName)) {
                    definitionName = this._definitionAssets.get(assetClassName);
                }
                ServiceContext serviceContext = new ServiceContext();
                serviceContext.setCompanyId(companyId.longValue());
                this.deployDefaultDefinitionLink(guestUser, (long)companyId, companyGroup, assetClassName, definitionName);
            }
            catch (PortalException portalException) {
                throw new SystemException((Throwable)portalException);
            }
        });
    }

    public void deployDefaultDefinitionLinks() throws Exception {
        this.companyLocalService.forEachCompanyId(companyId -> {
            try {
                this.deployDefaultDefinitionLinks((long)companyId);
            }
            catch (Exception exception) {
                throw new SystemException((Throwable)exception);
            }
        });
    }

    public void deployDefaultDefinitionLinks(long companyId) throws Exception {
        User guestUser = this.userLocalService.getGuestUser(companyId);
        Group companyGroup = this.groupLocalService.getCompanyGroup(companyId);
        ServiceContext serviceContext = new ServiceContext();
        serviceContext.setCompanyId(companyId);
        for (Map.Entry<String, String> entry : this._definitionAssets.entrySet()) {
            String assetClassName = entry.getKey();
            String definitionName = entry.getValue();
            this.deployDefaultDefinitionLink(guestUser, companyId, companyGroup, assetClassName, definitionName);
        }
    }

    public void deployDefaultDefinitions() throws Exception {
        this.companyLocalService.forEachCompanyId(companyId -> {
            try {
                this.deployDefaultDefinitions((long)companyId);
            }
            catch (Exception exception) {
                throw new SystemException((Throwable)exception);
            }
        });
    }

    public void deployDefaultDefinitions(long companyId) throws Exception {
        for (Map.Entry<String, String> entry : this._definitionFiles.entrySet()) {
            String fileName;
            String definitionName = entry.getKey();
            ServiceContext serviceContext = new ServiceContext();
            serviceContext.setCompanyId(companyId);
            int kaleoDefinitionsCount = this.kaleoDefinitionLocalService.getKaleoDefinitionsCount(definitionName, serviceContext);
            if (kaleoDefinitionsCount > 0) {
                return;
            }
            Class<?> clazz = this.getClass();
            ClassLoader classLoader = clazz.getClassLoader();
            InputStream inputStream = classLoader.getResourceAsStream(fileName = entry.getValue());
            if (inputStream == null) {
                if (_log.isWarnEnabled()) {
                    _log.warn((Object)StringBundler.concat((String[])new String[]{"Unable to find definition file for ", definitionName, " with file name ", fileName}));
                }
                return;
            }
            User guestUser = this.userLocalService.getGuestUser(companyId);
            this._workflowDefinitionManager.deployWorkflowDefinition(serviceContext.getCompanyId(), guestUser.getUserId(), this._getLocalizedTitle(companyId, definitionName), definitionName, FileUtil.getBytes((InputStream)inputStream));
        }
    }

    public void deployDefaultRoles() throws Exception {
        this.companyLocalService.forEachCompanyId(companyId -> {
            try {
                this.deployDefaultRoles((long)companyId);
            }
            catch (Exception exception) {
                throw new SystemException((Throwable)exception);
            }
        });
    }

    public void deployDefaultRoles(long companyId) throws Exception {
        User guestUser = this.userLocalService.getGuestUser(companyId);
        for (Map.Entry<String, String> entry : this._defaultRoles.entrySet()) {
            String name = entry.getKey();
            Role role = this.roleLocalService.fetchRole(companyId, name);
            if (role != null) continue;
            this.roleLocalService.addRole(guestUser.getUserId(), null, 0L, name, null, (Map)HashMapBuilder.put((Object)LocaleUtil.getDefault(), (Object)entry.getValue()).build(), 1, null, null);
        }
    }

    public void deployKaleoDefaults() throws Exception {
        this.deployDefaultRoles();
        this.deployDefaultDefinitions();
        this.deployDefaultDefinitionLinks();
    }

    public void deployKaleoDefaults(long companyId) throws Exception {
        this.deployDefaultRoles(companyId);
        this.deployDefaultDefinitions(companyId);
        this.deployDefaultDefinitionLinks(companyId);
    }

    public void setDefaultRoles(Map<String, String> defaultRoles) {
        this._defaultRoles.putAll(defaultRoles);
    }

    public void setDefinitionAssets(Map<String, String> definitionAssets) {
        this._definitionAssets.putAll(definitionAssets);
    }

    public void setDefinitionFiles(Map<String, String> definitionFiles) {
        this._definitionFiles.putAll(definitionFiles);
    }

    protected void deployDefaultDefinitionLink(User guestUser, long companyId, Group companyGroup, String assetClassName, String workflowDefinitionName) throws PortalException {
        WorkflowDefinitionLink workflowDefinitionLink = this.workflowDefinitionLinkLocalService.fetchDefaultWorkflowDefinitionLink(companyId, assetClassName, 0L, 0L);
        if (workflowDefinitionLink != null) {
            return;
        }
        List workflowDefinitions = this._workflowDefinitionManager.getActiveWorkflowDefinitions(companyId, workflowDefinitionName, 0, 20, this.workflowComparatorFactory.getDefinitionNameComparator(false));
        if (workflowDefinitions.isEmpty()) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)("No workflow definitions found for " + workflowDefinitionName));
            }
            return;
        }
        WorkflowDefinition workflowDefinition = (WorkflowDefinition)workflowDefinitions.get(0);
        this.workflowDefinitionLinkLocalService.addWorkflowDefinitionLink(guestUser.getUserId(), companyId, companyGroup.getGroupId(), assetClassName, 0L, 0L, workflowDefinition.getName(), workflowDefinition.getVersion());
    }

    private String _getLocalizedTitle(long companyId, String definitionName) throws Exception {
        if (!Objects.equals(_DEFINITION_NAME, definitionName)) {
            return this._localization.updateLocalization("", "title", definitionName, LocaleUtil.toLanguageId((Locale)LocaleUtil.getDefault()));
        }
        LocalizedValuesMap localizedValuesMap = new LocalizedValuesMap();
        Group companyGroup = this.groupLocalService.getCompanyGroup(companyId);
        for (Locale availableLocale : this._language.getAvailableLocales(companyGroup.getGroupId())) {
            localizedValuesMap.put(availableLocale, this._language.get(ResourceBundleUtil.getModuleAndPortalResourceBundle((Locale)availableLocale, DefaultPortalKaleoManager.class), "single-approver"));
        }
        return this._localization.getXml(localizedValuesMap, "title");
    }
}

