/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.workflow.kaleo.runtime.internal.node;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.workflow.kaleo.definition.DelayDuration;
import com.liferay.portal.workflow.kaleo.definition.DurationScale;
import com.liferay.portal.workflow.kaleo.definition.ExecutionType;
import com.liferay.portal.workflow.kaleo.definition.NodeType;
import com.liferay.portal.workflow.kaleo.definition.exception.KaleoDefinitionValidationException;
import com.liferay.portal.workflow.kaleo.model.KaleoInstanceToken;
import com.liferay.portal.workflow.kaleo.model.KaleoNode;
import com.liferay.portal.workflow.kaleo.model.KaleoTask;
import com.liferay.portal.workflow.kaleo.model.KaleoTaskInstanceToken;
import com.liferay.portal.workflow.kaleo.model.KaleoTimer;
import com.liferay.portal.workflow.kaleo.model.KaleoTimerInstanceToken;
import com.liferay.portal.workflow.kaleo.model.KaleoTransition;
import com.liferay.portal.workflow.kaleo.runtime.ExecutionContext;
import com.liferay.portal.workflow.kaleo.runtime.assignment.AggregateKaleoTaskAssignmentSelector;
import com.liferay.portal.workflow.kaleo.runtime.calendar.DueDateCalculator;
import com.liferay.portal.workflow.kaleo.runtime.graph.PathElement;
import com.liferay.portal.workflow.kaleo.runtime.internal.assignment.helper.TaskAssignerHelper;
import com.liferay.portal.workflow.kaleo.runtime.node.BaseNodeExecutor;
import com.liferay.portal.workflow.kaleo.runtime.node.NodeExecutor;
import com.liferay.portal.workflow.kaleo.service.KaleoLogLocalService;
import com.liferay.portal.workflow.kaleo.service.KaleoTaskInstanceTokenLocalService;
import com.liferay.portal.workflow.kaleo.service.KaleoTaskLocalService;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={NodeExecutor.class, TaskNodeExecutor.class})
public class TaskNodeExecutor
extends BaseNodeExecutor {
    @Reference
    private AggregateKaleoTaskAssignmentSelector _aggregateKaleoTaskAssignmentSelector;
    @Reference
    private DueDateCalculator _dueDateCalculator;
    @Reference
    private KaleoLogLocalService _kaleoLogLocalService;
    @Reference
    private KaleoTaskInstanceTokenLocalService _kaleoTaskInstanceTokenLocalService;
    @Reference
    private KaleoTaskLocalService _kaleoTaskLocalService;
    @Reference
    private TaskAssignerHelper _taskAssignerHelper;

    public void executeTimer(ExecutionContext executionContext) throws PortalException {
        KaleoTimerInstanceToken kaleoTimerInstanceToken = executionContext.getKaleoTimerInstanceToken();
        KaleoTimer kaleoTimer = kaleoTimerInstanceToken.getKaleoTimer();
        this.kaleoActionExecutor.executeKaleoActions(KaleoTimer.class.getName(), kaleoTimer.getKaleoTimerId(), ExecutionType.ON_TIMER, executionContext);
        List kaleoTaskReassignments = kaleoTimer.getKaleoTaskReassignments();
        if (ListUtil.isNotEmpty((List)kaleoTaskReassignments)) {
            this._taskAssignerHelper.reassignKaleoTask(kaleoTaskReassignments, executionContext);
        }
        this.notificationHelper.sendKaleoNotifications(KaleoTimer.class.getName(), kaleoTimer.getKaleoTimerId(), ExecutionType.ON_TIMER, executionContext);
        if (!kaleoTimer.isRecurring()) {
            this.kaleoTimerInstanceTokenLocalService.completeKaleoTimerInstanceToken(kaleoTimerInstanceToken.getKaleoTimerInstanceTokenId(), executionContext.getServiceContext());
        }
    }

    public NodeType getNodeType() {
        return NodeType.TASK;
    }

    protected boolean doEnter(KaleoNode currentKaleoNode, ExecutionContext executionContext) throws PortalException {
        Map workflowContext = executionContext.getWorkflowContext();
        ServiceContext serviceContext = executionContext.getServiceContext();
        KaleoInstanceToken kaleoInstanceToken = executionContext.getKaleoInstanceToken();
        KaleoTask kaleoTask = this._kaleoTaskLocalService.getKaleoNodeKaleoTask(currentKaleoNode.getKaleoNodeId());
        Date dueDate = this._calculateDueDate(kaleoTask);
        KaleoTaskInstanceToken kaleoTaskInstanceToken = this._createTaskInstanceToken(executionContext, workflowContext, serviceContext, kaleoInstanceToken, kaleoTask, dueDate);
        executionContext.setKaleoTaskInstanceToken(kaleoTaskInstanceToken);
        this.kaleoActionExecutor.executeKaleoActions(KaleoNode.class.getName(), currentKaleoNode.getKaleoNodeId(), ExecutionType.ON_ASSIGNMENT, executionContext);
        this.notificationHelper.sendKaleoNotifications(KaleoNode.class.getName(), currentKaleoNode.getKaleoNodeId(), ExecutionType.ON_ASSIGNMENT, executionContext);
        this.kaleoTimerInstanceTokenLocalService.addKaleoTimerInstanceTokens(executionContext.getKaleoInstanceToken(), executionContext.getKaleoTaskInstanceToken(), (Collection)this.kaleoTimerLocalService.getKaleoTimers(KaleoNode.class.getName(), currentKaleoNode.getKaleoNodeId()), executionContext.getWorkflowContext(), executionContext.getServiceContext());
        this._kaleoLogLocalService.addTaskAssignmentKaleoLogs(null, kaleoTaskInstanceToken, "assigned-initial-task", workflowContext, serviceContext);
        return true;
    }

    protected void doExecute(KaleoNode currentKaleoNode, ExecutionContext executionContext, List<PathElement> remainingPathElements) {
    }

    protected void doExit(KaleoNode currentKaleoNode, ExecutionContext executionContext, List<PathElement> remainingPathElements) throws PortalException {
        String transitionName = executionContext.getTransitionName();
        KaleoTransition kaleoTransition = null;
        kaleoTransition = Validator.isNull((String)transitionName) ? currentKaleoNode.getDefaultKaleoTransition() : currentKaleoNode.getKaleoTransition(transitionName);
        ExecutionContext newExecutionContext = new ExecutionContext(executionContext.getKaleoInstanceToken(), executionContext.getKaleoTaskInstanceToken(), executionContext.getWorkflowContext(), executionContext.getServiceContext());
        PathElement pathElement = new PathElement(null, kaleoTransition.getTargetKaleoNode(), newExecutionContext);
        remainingPathElements.add(pathElement);
    }

    private Date _calculateDueDate(KaleoTask kaleoTask) throws KaleoDefinitionValidationException {
        List kaleoTimers = this.kaleoTimerLocalService.getKaleoTimers(KaleoNode.class.getName(), kaleoTask.getKaleoNodeId());
        if (kaleoTimers.isEmpty()) {
            return null;
        }
        TreeSet<Date> sortedDueDates = new TreeSet<Date>();
        for (KaleoTimer kaleoTimer : kaleoTimers) {
            DelayDuration delayDuration = new DelayDuration(kaleoTimer.getDuration(), DurationScale.parse((String)kaleoTimer.getScale()));
            sortedDueDates.add(this._dueDateCalculator.getDueDate(new Date(), delayDuration));
        }
        return (Date)sortedDueDates.first();
    }

    private KaleoTaskInstanceToken _createTaskInstanceToken(ExecutionContext executionContext, Map<String, Serializable> workflowContext, ServiceContext serviceContext, KaleoInstanceToken kaleoInstanceToken, KaleoTask kaleoTask, Date dueDate) throws PortalException {
        return this._kaleoTaskInstanceTokenLocalService.addKaleoTaskInstanceToken(kaleoInstanceToken.getKaleoInstanceTokenId(), kaleoTask.getKaleoTaskId(), kaleoTask.getName(), this._aggregateKaleoTaskAssignmentSelector.getKaleoTaskAssignments(kaleoTask.getKaleoTaskAssignments(), executionContext), dueDate, workflowContext, serviceContext);
    }
}

