/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.workflow.kaleo.runtime.internal.action.executor;

import com.liferay.osgi.service.tracker.collections.map.ServiceReferenceMapper;
import com.liferay.osgi.service.tracker.collections.map.ServiceReferenceMapperFactory;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMap;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMapFactory;
import com.liferay.petra.function.transform.TransformUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.util.ClassUtil;
import com.liferay.portal.workflow.kaleo.definition.ActionType;
import com.liferay.portal.workflow.kaleo.definition.ScriptLanguage;
import com.liferay.portal.workflow.kaleo.model.KaleoAction;
import com.liferay.portal.workflow.kaleo.runtime.ExecutionContext;
import com.liferay.portal.workflow.kaleo.runtime.action.ActionExecutorManager;
import com.liferay.portal.workflow.kaleo.runtime.action.executor.ActionExecutor;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;

@Component(service={ActionExecutorManager.class})
public class ActionExecutorManagerImpl
implements ActionExecutorManager {
    private ServiceTrackerMap<String, List<ActionExecutor>> _serviceTrackerMap;

    public void executeKaleoAction(KaleoAction kaleoAction, ExecutionContext executionContext) throws PortalException {
        String actionExecutorKey = this._getActionExecutorKey(kaleoAction);
        ActionExecutor actionExecutor = null;
        List actionExecutors = (List)this._serviceTrackerMap.getService((Object)actionExecutorKey);
        if (actionExecutors != null) {
            if (Objects.equals(String.valueOf(ScriptLanguage.JAVA), kaleoAction.getScriptLanguage())) {
                String className = kaleoAction.getScript();
                for (ActionExecutor innerActionExecutor : actionExecutors) {
                    if (!Objects.equals(ClassUtil.getClassName((Object)innerActionExecutor), className)) continue;
                    actionExecutor = innerActionExecutor;
                    break;
                }
            } else {
                actionExecutor = (ActionExecutor)actionExecutors.get(0);
            }
        }
        if (actionExecutor == null) {
            throw new PortalException("No action executor for " + actionExecutorKey);
        }
        actionExecutor.execute(kaleoAction, executionContext);
    }

    public String[] getFunctionActionExecutorKeys() {
        return (String[])TransformUtil.transformToArray((Collection)this._serviceTrackerMap.keySet(), key -> {
            if (key.startsWith("function")) {
                return key;
            }
            return null;
        }, String.class);
    }

    @Activate
    protected void activate(BundleContext bundleContext) {
        this._serviceTrackerMap = ServiceTrackerMapFactory.openMultiValueMap((BundleContext)bundleContext, ActionExecutor.class, null, (ServiceReferenceMapper)ServiceReferenceMapperFactory.create((BundleContext)bundleContext, (actionExecutor, emitter) -> emitter.emit((Object)actionExecutor.getActionExecutorKey())));
    }

    @Deactivate
    protected void deactivate() {
        this._serviceTrackerMap.close();
    }

    private String _getActionExecutorKey(KaleoAction kaleoAction) {
        ActionType actionType = ActionType.valueOf((String)kaleoAction.getType());
        if (Objects.equals(actionType, ActionType.UPDATE_STATUS)) {
            return actionType.name();
        }
        return kaleoAction.getScriptLanguage();
    }
}

