/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.workflow.kaleo.runtime.internal.petra.executor;

import com.liferay.petra.concurrent.NoticeableExecutorService;
import com.liferay.petra.concurrent.NoticeableFuture;
import com.liferay.petra.concurrent.ThreadPoolHandler;
import com.liferay.petra.concurrent.ThreadPoolHandlerAdapter;
import com.liferay.petra.executor.PortalExecutorConfig;
import com.liferay.petra.executor.PortalExecutorManager;
import com.liferay.petra.lang.CentralizedThreadLocal;
import com.liferay.petra.lang.SafeCloseable;
import com.liferay.portal.kernel.change.tracking.CTCollectionThreadLocal;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.security.auth.PrincipalThreadLocal;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.PermissionCheckerFactory;
import com.liferay.portal.kernel.security.permission.PermissionThreadLocal;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.NamedThreadFactory;
import com.liferay.portal.kernel.util.PortalClassLoaderUtil;
import com.liferay.portal.kernel.util.PortalRunMode;
import com.liferay.portal.workflow.kaleo.runtime.ExecutionContext;
import com.liferay.portal.workflow.kaleo.runtime.graph.GraphWalker;
import com.liferay.portal.workflow.kaleo.runtime.graph.PathElement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(service={GraphWalkerPortalExecutor.class})
public class GraphWalkerPortalExecutor {
    private static final Log _log = LogFactoryUtil.getLog(GraphWalkerPortalExecutor.class);
    @Reference
    private PermissionCheckerFactory _defaultPermissionCheckerFactory;
    @Reference
    private GraphWalker _graphWalker;
    private NoticeableExecutorService _noticeableExecutorService;
    @Reference
    private PortalExecutorManager _portalExecutorManager;
    private ServiceRegistration<PortalExecutorConfig> _serviceRegistration;
    @Reference
    private UserLocalService _userLocalService;

    public void execute(PathElement pathElement, boolean waitForCompletion) {
        if (PortalRunMode.isTestMode()) {
            this._walk(pathElement);
            return;
        }
        ExecutionContext executionContext = pathElement.getExecutionContext();
        ServiceContext serviceContext = executionContext.getServiceContext();
        long companyId = serviceContext.getCompanyId();
        long ctCollectionId = CTCollectionThreadLocal.getCTCollectionId();
        if (waitForCompletion) {
            NoticeableFuture noticeableFuture = this._noticeableExecutorService.submit(() -> {
                try (SafeCloseable safeCloseable = CompanyThreadLocal.setWithSafeCloseable((Long)companyId, (Long)ctCollectionId);){
                    this._walk(pathElement);
                }
            });
            try {
                noticeableFuture.get();
            }
            catch (ExecutionException executionException) {
                _log.error((Throwable)executionException);
            }
            catch (InterruptedException interruptedException) {
                _log.error((Throwable)interruptedException);
            }
        } else {
            this._noticeableExecutorService.submit(() -> {
                try (SafeCloseable safeCloseable = CompanyThreadLocal.setWithSafeCloseable((Long)companyId, (Long)ctCollectionId);){
                    this._walk(pathElement);
                }
            });
        }
    }

    @Activate
    protected void activate(BundleContext bundleContext) {
        this._registerPortalExecutorConfig(bundleContext);
        this._noticeableExecutorService = this._portalExecutorManager.getPortalExecutor(GraphWalkerPortalExecutor.class.getName());
    }

    @Deactivate
    protected void deactivate() {
        this._noticeableExecutorService.shutdown();
        this._serviceRegistration.unregister();
    }

    private void _registerPortalExecutorConfig(BundleContext bundleContext) {
        PortalExecutorConfig portalExecutorConfig = new PortalExecutorConfig(GraphWalkerPortalExecutor.class.getName(), 1, 1, 60L, TimeUnit.SECONDS, Integer.MAX_VALUE, (ThreadFactory)new NamedThreadFactory(GraphWalkerPortalExecutor.class.getName(), 5, PortalClassLoaderUtil.getClassLoader()), (RejectedExecutionHandler)new ThreadPoolExecutor.AbortPolicy(), (ThreadPoolHandler)new ThreadPoolHandlerAdapter(){

            public void afterExecute(Runnable runnable, Throwable throwable) {
                CentralizedThreadLocal.clearShortLivedThreadLocals();
            }
        });
        this._serviceRegistration = bundleContext.registerService(PortalExecutorConfig.class, (Object)portalExecutorConfig, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _walk(PathElement pathElement) {
        String name = PrincipalThreadLocal.getName();
        PermissionChecker permissionChecker = PermissionThreadLocal.getPermissionChecker();
        try {
            ExecutionContext executionContext = pathElement.getExecutionContext();
            ServiceContext serviceContext = executionContext.getServiceContext();
            if (PrincipalThreadLocal.getUserId() == 0L) {
                PrincipalThreadLocal.setName((long)serviceContext.getUserId());
            }
            if (permissionChecker == null) {
                PermissionThreadLocal.setPermissionChecker((PermissionChecker)this._defaultPermissionCheckerFactory.create(this._userLocalService.getUser(serviceContext.getUserId())));
            }
            LinkedList<List<Object>> queue = new LinkedList<List<Object>>();
            queue.add(Collections.singletonList(pathElement));
            List pathElements = null;
            while ((pathElements = (List)queue.poll()) != null) {
                for (PathElement curPathElement : pathElements) {
                    ArrayList remainingPathElements = new ArrayList();
                    this._graphWalker.follow(curPathElement.getStartNode(), curPathElement.getTargetNode(), remainingPathElements, curPathElement.getExecutionContext());
                    if (remainingPathElements.isEmpty()) continue;
                    queue.add(remainingPathElements);
                }
            }
        }
        catch (Throwable throwable) {
            _log.error((Object)throwable, throwable);
        }
        finally {
            PrincipalThreadLocal.setName((String)name);
            PermissionThreadLocal.setPermissionChecker((PermissionChecker)permissionChecker);
        }
    }
}

