/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.workflow.kaleo.runtime.internal.timer;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.workflow.kaleo.definition.ExecutionType;
import com.liferay.portal.workflow.kaleo.model.KaleoTimer;
import com.liferay.portal.workflow.kaleo.model.KaleoTimerInstanceToken;
import com.liferay.portal.workflow.kaleo.runtime.ExecutionContext;
import com.liferay.portal.workflow.kaleo.runtime.action.KaleoActionExecutor;
import com.liferay.portal.workflow.kaleo.runtime.internal.assignment.helper.TaskAssignerHelper;
import com.liferay.portal.workflow.kaleo.runtime.notification.NotificationHelper;
import com.liferay.portal.workflow.kaleo.service.KaleoTimerInstanceTokenLocalService;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={TimerExecutor.class})
public class TimerExecutor {
    @Reference
    protected KaleoActionExecutor kaleoActionExecutor;
    @Reference
    protected KaleoTimerInstanceTokenLocalService kaleoTimerInstanceTokenLocalService;
    @Reference
    protected NotificationHelper notificationHelper;
    @Reference
    protected TaskAssignerHelper taskAssignerHelper;

    public void executeTimer(ExecutionContext executionContext) throws PortalException {
        KaleoTimerInstanceToken kaleoTimerInstanceToken = executionContext.getKaleoTimerInstanceToken();
        KaleoTimer kaleoTimer = kaleoTimerInstanceToken.getKaleoTimer();
        this.kaleoActionExecutor.executeKaleoActions(KaleoTimer.class.getName(), kaleoTimer.getKaleoTimerId(), ExecutionType.ON_TIMER, executionContext);
        List kaleoTaskReassignments = kaleoTimer.getKaleoTaskReassignments();
        if (ListUtil.isNotEmpty((List)kaleoTaskReassignments)) {
            this.taskAssignerHelper.reassignKaleoTask(kaleoTaskReassignments, executionContext);
        }
        this.notificationHelper.sendKaleoNotifications(KaleoTimer.class.getName(), kaleoTimer.getKaleoTimerId(), ExecutionType.ON_TIMER, executionContext);
        if (!kaleoTimer.isRecurring()) {
            this.kaleoTimerInstanceTokenLocalService.completeKaleoTimerInstanceToken(kaleoTimerInstanceToken.getKaleoTimerInstanceTokenId(), executionContext.getServiceContext());
        }
    }
}

