/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.workflow.kaleo.runtime.internal;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.change.tracking.CTAware;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.module.service.Snapshot;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.transaction.Isolation;
import com.liferay.portal.kernel.transaction.Propagation;
import com.liferay.portal.kernel.transaction.Transactional;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.workflow.WorkflowException;
import com.liferay.portal.kernel.workflow.WorkflowTask;
import com.liferay.portal.kernel.workflow.WorkflowTaskDueDateException;
import com.liferay.portal.workflow.kaleo.KaleoWorkflowModelConverter;
import com.liferay.portal.workflow.kaleo.definition.ExecutionType;
import com.liferay.portal.workflow.kaleo.model.KaleoInstance;
import com.liferay.portal.workflow.kaleo.model.KaleoNode;
import com.liferay.portal.workflow.kaleo.model.KaleoTask;
import com.liferay.portal.workflow.kaleo.model.KaleoTaskForm;
import com.liferay.portal.workflow.kaleo.model.KaleoTaskInstanceToken;
import com.liferay.portal.workflow.kaleo.model.KaleoTransition;
import com.liferay.portal.workflow.kaleo.runtime.ExecutionContext;
import com.liferay.portal.workflow.kaleo.runtime.TaskManager;
import com.liferay.portal.workflow.kaleo.runtime.action.KaleoActionExecutor;
import com.liferay.portal.workflow.kaleo.runtime.form.FormDefinitionRetriever;
import com.liferay.portal.workflow.kaleo.runtime.internal.BaseKaleoBean;
import com.liferay.portal.workflow.kaleo.runtime.notification.NotificationHelper;
import com.liferay.portal.workflow.kaleo.runtime.util.WorkflowContextUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@CTAware
@Transactional(isolation=Isolation.PORTAL, propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
@Component(service={AopService.class})
public class DefaultTaskManagerImpl
extends BaseKaleoBean
implements AopService,
TaskManager {
    private static final Log _log = LogFactoryUtil.getLog(DefaultTaskManagerImpl.class);
    private static final Snapshot<FormDefinitionRetriever> _formDefinitionRetrieverSnapshot = new Snapshot(DefaultTaskManagerImpl.class, FormDefinitionRetriever.class);
    @Reference
    private KaleoActionExecutor _kaleoActionExecutor;
    @Reference
    private KaleoWorkflowModelConverter _kaleoWorkflowModelConverter;
    @Reference
    private NotificationHelper _notificationHelper;

    public WorkflowTask assignWorkflowTaskToRole(long workflowTaskId, long roleId, String comment, Date dueDate, Map<String, Serializable> workflowContext, ServiceContext serviceContext) throws WorkflowException {
        try {
            return this._assignWorkflowTask(workflowTaskId, Role.class.getName(), roleId, comment, dueDate, workflowContext, serviceContext);
        }
        catch (WorkflowException workflowException) {
            throw workflowException;
        }
        catch (Exception exception) {
            throw new WorkflowException((Throwable)exception);
        }
    }

    public WorkflowTask assignWorkflowTaskToUser(long workflowTaskId, long assigneeUserId, String comment, Date dueDate, Map<String, Serializable> workflowContext, ServiceContext serviceContext) throws WorkflowException {
        try {
            return this._assignWorkflowTask(workflowTaskId, User.class.getName(), assigneeUserId, comment, dueDate, workflowContext, serviceContext);
        }
        catch (WorkflowException workflowException) {
            throw workflowException;
        }
        catch (Exception exception) {
            throw new WorkflowException((Throwable)exception);
        }
    }

    public WorkflowTask completeWorkflowTask(long workflowTaskId, long workflowTaskFormId, String formValues, Map<String, Serializable> workflowContext, ServiceContext serviceContext) throws WorkflowException {
        return this.completeWorkflowTask(workflowTaskId, workflowTaskFormId, formValues, null, workflowContext, serviceContext);
    }

    public WorkflowTask completeWorkflowTask(long workflowTaskId, long workflowTaskFormId, String formValues, String transitionName, Map<String, Serializable> workflowContext, ServiceContext serviceContext) throws WorkflowException {
        try {
            KaleoTask kaleoTask;
            KaleoNode kaleoNode;
            List kaleoTransitions;
            KaleoTaskInstanceToken kaleoTaskInstanceToken = this.kaleoTaskInstanceTokenLocalService.getKaleoTaskInstanceToken(workflowTaskId);
            this.kaleoTaskFormInstanceLocalService.addKaleoTaskFormInstance(kaleoTaskInstanceToken.getGroupId(), workflowTaskFormId, formValues, kaleoTaskInstanceToken, serviceContext);
            if (this.kaleoTaskInstanceTokenLocalService.hasPendingKaleoTaskForms(workflowTaskId)) {
                return this._kaleoWorkflowModelConverter.toWorkflowTask(kaleoTaskInstanceToken, workflowContext);
            }
            if (Validator.isNull((String)transitionName) && (kaleoTransitions = (kaleoNode = (kaleoTask = this.kaleoTaskLocalService.getKaleoTask(kaleoTaskInstanceToken.getKaleoTaskId())).getKaleoNode()).getKaleoTransitions()).size() == 1) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)("Automatically completing form task: " + kaleoTask.getName()));
                }
                KaleoTransition kaleoTransition = (KaleoTransition)kaleoTransitions.get(0);
                transitionName = kaleoTransition.getName();
            }
            return this._completeWorkflowTask(workflowTaskId, transitionName, null, workflowContext, serviceContext);
        }
        catch (WorkflowException workflowException) {
            throw workflowException;
        }
        catch (Exception exception) {
            throw new WorkflowException((Throwable)exception);
        }
    }

    public WorkflowTask completeWorkflowTask(long workflowTaskId, String transitionName, String comment, Map<String, Serializable> workflowContext, ServiceContext serviceContext) throws WorkflowException {
        try {
            return this._completeWorkflowTask(workflowTaskId, transitionName, comment, workflowContext, serviceContext);
        }
        catch (WorkflowException workflowException) {
            throw workflowException;
        }
        catch (Exception exception) {
            throw new WorkflowException((Throwable)exception);
        }
    }

    public List<String> getWorkflowTaskFormDefinitions(long workflowTaskId, ServiceContext serviceContext) throws WorkflowException {
        try {
            KaleoTaskInstanceToken kaleoTaskInstanceToken = this.kaleoTaskInstanceTokenLocalService.getKaleoTaskInstanceToken(workflowTaskId);
            List kaleoTaskForms = this.kaleoTaskFormLocalService.getKaleoTaskForms(kaleoTaskInstanceToken.getKaleoTaskId());
            ArrayList<String> kaleoTaskFormDefinitions = new ArrayList<String>(kaleoTaskForms.size());
            for (KaleoTaskForm kaleoTaskForm : kaleoTaskForms) {
                String kaleoFormDefinition = kaleoTaskForm.getFormDefinition();
                if (Validator.isNull((String)kaleoFormDefinition)) {
                    FormDefinitionRetriever formDefinitionRetriever = this._getFormDefinitionRetriever();
                    if (formDefinitionRetriever != null) {
                        kaleoFormDefinition = formDefinitionRetriever.getFormDefinition(kaleoTaskForm, kaleoTaskInstanceToken);
                    } else if (_log.isWarnEnabled()) {
                        _log.warn((Object)"No form definition retriever defined");
                    }
                }
                if (!Validator.isNotNull((String)kaleoFormDefinition)) continue;
                kaleoTaskFormDefinitions.add(kaleoFormDefinition);
            }
            return kaleoTaskFormDefinitions;
        }
        catch (WorkflowException workflowException) {
            throw workflowException;
        }
        catch (PortalException portalException) {
            throw new WorkflowException((Throwable)portalException);
        }
    }

    public WorkflowTask updateDueDate(long workflowTaskId, String comment, Date dueDate, ServiceContext serviceContext) throws WorkflowException {
        try {
            KaleoTaskInstanceToken kaleoTaskInstanceToken = this.kaleoTaskInstanceTokenLocalService.getKaleoTaskInstanceToken(workflowTaskId);
            if (kaleoTaskInstanceToken.isCompleted()) {
                throw new WorkflowException("Cannot update due date for completed task " + workflowTaskId);
            }
            if (dueDate != null) {
                Date createDate = kaleoTaskInstanceToken.getCreateDate();
                if (createDate.after(dueDate)) {
                    throw new WorkflowTaskDueDateException();
                }
                kaleoTaskInstanceToken = this.kaleoTaskInstanceTokenLocalService.updateDueDate(workflowTaskId, dueDate, serviceContext);
            }
            Map workflowContext = WorkflowContextUtil.convert((String)kaleoTaskInstanceToken.getWorkflowContext());
            this.kaleoLogLocalService.addTaskUpdateKaleoLog(kaleoTaskInstanceToken, comment, workflowContext, serviceContext);
            return this._kaleoWorkflowModelConverter.toWorkflowTask(kaleoTaskInstanceToken, workflowContext);
        }
        catch (WorkflowException workflowException) {
            throw workflowException;
        }
        catch (Exception exception) {
            throw new WorkflowException((Throwable)exception);
        }
    }

    private WorkflowTask _assignWorkflowTask(long workflowTaskId, String assigneeClassName, long assigneeClassPK, String comment, Date dueDate, Map<String, Serializable> workflowContext, ServiceContext serviceContext) throws Exception {
        KaleoTaskInstanceToken kaleoTaskInstanceToken = this.kaleoTaskInstanceTokenLocalService.getKaleoTaskInstanceToken(workflowTaskId);
        List previousTaskAssignmentInstances = kaleoTaskInstanceToken.getKaleoTaskAssignmentInstances();
        workflowContext = this._updateWorkflowContext(workflowContext, kaleoTaskInstanceToken);
        if (kaleoTaskInstanceToken.isCompleted()) {
            throw new WorkflowException("Cannot reassign a completed task " + workflowTaskId);
        }
        if (dueDate != null) {
            kaleoTaskInstanceToken = this.kaleoTaskInstanceTokenLocalService.updateDueDate(workflowTaskId, dueDate, serviceContext);
        }
        kaleoTaskInstanceToken = this.kaleoTaskInstanceTokenLocalService.assignKaleoTaskInstanceToken(kaleoTaskInstanceToken.getKaleoTaskInstanceTokenId(), assigneeClassName, assigneeClassPK, workflowContext, serviceContext);
        workflowContext.put("taskComments", (Serializable)((Object)comment));
        ExecutionContext executionContext = new ExecutionContext(kaleoTaskInstanceToken.getKaleoInstanceToken(), kaleoTaskInstanceToken, workflowContext, serviceContext);
        KaleoTask kaleoTask = kaleoTaskInstanceToken.getKaleoTask();
        this._kaleoActionExecutor.executeKaleoActions(KaleoNode.class.getName(), kaleoTask.getKaleoNodeId(), ExecutionType.ON_ASSIGNMENT, executionContext);
        this._notificationHelper.sendKaleoNotifications(KaleoNode.class.getName(), kaleoTask.getKaleoNodeId(), ExecutionType.ON_ASSIGNMENT, executionContext);
        this.kaleoLogLocalService.addTaskAssignmentKaleoLogs(previousTaskAssignmentInstances, kaleoTaskInstanceToken, comment, workflowContext, serviceContext);
        return this._kaleoWorkflowModelConverter.toWorkflowTask(kaleoTaskInstanceToken, workflowContext);
    }

    private WorkflowTask _completeWorkflowTask(long workflowTaskId, String transitionName, String comment, Map<String, Serializable> workflowContext, ServiceContext serviceContext) throws Exception {
        KaleoTaskInstanceToken kaleoTaskInstanceToken = this.kaleoTaskInstanceTokenLocalService.getKaleoTaskInstanceToken(workflowTaskId);
        if (Validator.isNotNull((String)transitionName)) {
            KaleoTask kaleoTask = kaleoTaskInstanceToken.getKaleoTask();
            KaleoNode currentKaleoNode = kaleoTask.getKaleoNode();
            currentKaleoNode.getKaleoTransition(transitionName);
        }
        workflowContext = this._updateWorkflowContext(workflowContext, kaleoTaskInstanceToken);
        if (kaleoTaskInstanceToken.isCompleted()) {
            throw new WorkflowException(StringBundler.concat((Object[])new Object[]{"Cannot complete an already completed task ", workflowTaskId, " for user ", serviceContext.getUserId()}));
        }
        serviceContext.setScopeGroupId(kaleoTaskInstanceToken.getGroupId());
        kaleoTaskInstanceToken = this.kaleoTaskInstanceTokenLocalService.completeKaleoTaskInstanceToken(kaleoTaskInstanceToken.getKaleoTaskInstanceTokenId(), serviceContext);
        this.kaleoLogLocalService.addTaskCompletionKaleoLog(kaleoTaskInstanceToken, comment, workflowContext, serviceContext);
        return this._kaleoWorkflowModelConverter.toWorkflowTask(kaleoTaskInstanceToken, workflowContext);
    }

    private FormDefinitionRetriever _getFormDefinitionRetriever() {
        return (FormDefinitionRetriever)_formDefinitionRetrieverSnapshot.get();
    }

    private Map<String, Serializable> _updateWorkflowContext(Map<String, Serializable> workflowContext, KaleoTaskInstanceToken kaleoTaskInstanceToken) throws Exception {
        KaleoInstance kaleoInstance = this.kaleoInstanceLocalService.getKaleoInstance(kaleoTaskInstanceToken.getKaleoInstanceId());
        if (workflowContext == null) {
            workflowContext = WorkflowContextUtil.convert((String)kaleoInstance.getWorkflowContext());
        } else {
            Map storedWorkflowContext = WorkflowContextUtil.convert((String)kaleoInstance.getWorkflowContext());
            for (Map.Entry entry : storedWorkflowContext.entrySet()) {
                String key = (String)entry.getKey();
                if (workflowContext.containsKey(key)) continue;
                workflowContext.put(key, (Serializable)entry.getValue());
            }
        }
        return workflowContext;
    }
}

