/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.workflow.kaleo.runtime.internal.manager.messaging;

import com.liferay.portal.kernel.messaging.BaseMessageListener;
import com.liferay.portal.kernel.messaging.Destination;
import com.liferay.portal.kernel.messaging.DestinationConfiguration;
import com.liferay.portal.kernel.messaging.DestinationFactory;
import com.liferay.portal.kernel.messaging.Message;
import com.liferay.portal.kernel.messaging.MessageListener;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.workflow.kaleo.runtime.manager.PortalKaleoManager;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(property={"destination.name=destination.workflow_definition_link"}, service={MessageListener.class})
public class KaleoAssetDeploymentMessageListener
extends BaseMessageListener {
    @Reference
    private DestinationFactory _destinationFactory;
    @Reference
    private PortalKaleoManager _portalKaleoManager;
    private ServiceRegistration<Destination> _serviceRegistration;

    public void setPortalKaleoManager(PortalKaleoManager portalKaleoManager) {
        this._portalKaleoManager = portalKaleoManager;
    }

    @Activate
    protected void activate(BundleContext bundleContext) {
        Destination destination = this._destinationFactory.createDestination(new DestinationConfiguration("synchronous", "destination.workflow_definition_link"));
        this._serviceRegistration = bundleContext.registerService(Destination.class, (Object)destination, MapUtil.singletonDictionary((Object)"destination.name", (Object)destination.getName()));
    }

    @Deactivate
    protected void deactivate() {
        this._serviceRegistration.unregister();
    }

    protected void doReceive(Message message) throws Exception {
        String assetClassName = (String)message.get("ASSET_CLASS_NAME");
        this._portalKaleoManager.deployDefaultDefinitionLink(assetClassName);
    }
}

