/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.workflow.kaleo.runtime.internal.notification.recipient;

import com.liferay.osgi.service.tracker.collections.map.ServiceReferenceMapper;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMap;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMapFactory;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.workflow.kaleo.definition.RecipientType;
import com.liferay.portal.workflow.kaleo.runtime.notification.recipient.NotificationRecipientBuilder;
import com.liferay.portal.workflow.kaleo.runtime.notification.recipient.NotificationRecipientBuilderRegistry;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;

@Component(service={NotificationRecipientBuilderRegistry.class})
public class DefaultNotificationRecipientBuilderRegistry
implements NotificationRecipientBuilderRegistry {
    private ServiceTrackerMap<RecipientType, NotificationRecipientBuilder> _serviceTrackerMap;

    public NotificationRecipientBuilder getNotificationRecipientBuilder(RecipientType recipientType) {
        NotificationRecipientBuilder notificationRecipientBuilder = (NotificationRecipientBuilder)this._serviceTrackerMap.getService((Object)recipientType);
        if (notificationRecipientBuilder == null) {
            throw new IllegalArgumentException("No notification recipient builder for " + recipientType);
        }
        return notificationRecipientBuilder;
    }

    @Activate
    protected void activate(BundleContext bundleContext) {
        this._serviceTrackerMap = ServiceTrackerMapFactory.openSingleValueMap((BundleContext)bundleContext, NotificationRecipientBuilder.class, null, (ServiceReferenceMapper)new ServiceReferenceMapper<RecipientType, NotificationRecipientBuilder>(){

            public void map(ServiceReference<NotificationRecipientBuilder> serviceReference, ServiceReferenceMapper.Emitter<RecipientType> emitter) {
                Object value = serviceReference.getProperty("recipient.type");
                if (Validator.isNull((Object)value)) {
                    throw new IllegalArgumentException("The property \"recipient.type\" is invalid for " + serviceReference);
                }
                emitter.emit((Object)RecipientType.valueOf((String)String.valueOf(value)));
            }
        });
    }

    @Deactivate
    protected void deactivate() {
        this._serviceTrackerMap.close();
    }
}

