/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.workflow.kaleo.runtime.internal.notification.recipient;

import com.liferay.osgi.service.tracker.collections.list.ServiceTrackerList;
import com.liferay.osgi.service.tracker.collections.list.ServiceTrackerListFactory;
import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Organization;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.UserGroupGroupRole;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.OrganizationLocalService;
import com.liferay.portal.kernel.service.RoleLocalService;
import com.liferay.portal.kernel.service.UserGroupGroupRoleLocalService;
import com.liferay.portal.kernel.service.UserGroupRoleLocalService;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.workflow.configuration.WorkflowDefinitionConfiguration;
import com.liferay.portal.workflow.kaleo.definition.NotificationReceptionType;
import com.liferay.portal.workflow.kaleo.model.KaleoInstanceToken;
import com.liferay.portal.workflow.kaleo.model.KaleoNotificationRecipient;
import com.liferay.portal.workflow.kaleo.model.KaleoTaskAssignmentInstance;
import com.liferay.portal.workflow.kaleo.model.KaleoTaskInstanceToken;
import com.liferay.portal.workflow.kaleo.runtime.ExecutionContext;
import com.liferay.portal.workflow.kaleo.runtime.notification.NotificationRecipient;
import com.liferay.portal.workflow.kaleo.runtime.notification.recipient.NotificationRecipientBuilder;
import com.liferay.portal.workflow.kaleo.runtime.util.validator.GroupAwareRoleValidator;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;

@Component(configurationPid={"com.liferay.portal.workflow.configuration.WorkflowDefinitionConfiguration"}, property={"recipient.type=ROLE"}, service={NotificationRecipientBuilder.class})
public class RoleNotificationRecipientBuilder
implements NotificationRecipientBuilder {
    @Reference
    protected GroupLocalService groupLocalService;
    @Reference
    protected OrganizationLocalService organizationLocalService;
    @Reference
    protected RoleLocalService roleLocalService;
    @Reference
    protected UserGroupGroupRoleLocalService userGroupGroupRoleLocalService;
    @Reference
    protected UserGroupRoleLocalService userGroupRoleLocalService;
    @Reference
    protected UserLocalService userLocalService;
    private volatile ServiceTrackerList<GroupAwareRoleValidator> _serviceTrackerList;
    private volatile WorkflowDefinitionConfiguration _workflowDefinitionConfiguration;

    public void processKaleoNotificationRecipient(Set<NotificationRecipient> notificationRecipients, KaleoNotificationRecipient kaleoNotificationRecipient, NotificationReceptionType notificationReceptionType, ExecutionContext executionContext) throws Exception {
        long roleId = kaleoNotificationRecipient.getRecipientClassPK();
        this.addRoleRecipientAddresses(notificationRecipients, this.roleLocalService.getRole(roleId), notificationReceptionType, executionContext);
    }

    public void processKaleoTaskAssignmentInstance(Set<NotificationRecipient> notificationRecipients, KaleoTaskAssignmentInstance kaleoTaskAssignmentInstance, NotificationReceptionType notificationReceptionType, ExecutionContext executionContext) throws Exception {
        long roleId = kaleoTaskAssignmentInstance.getAssigneeClassPK();
        this.addRoleRecipientAddresses(notificationRecipients, this.roleLocalService.getRole(roleId), notificationReceptionType, executionContext);
    }

    @Activate
    @Modified
    protected void activate(BundleContext bundleContext, Map<String, Object> properties) {
        this._serviceTrackerList = ServiceTrackerListFactory.open((BundleContext)bundleContext, GroupAwareRoleValidator.class);
        this._workflowDefinitionConfiguration = (WorkflowDefinitionConfiguration)ConfigurableUtil.createConfigurable(WorkflowDefinitionConfiguration.class, properties);
    }

    protected void addRoleRecipientAddresses(Set<NotificationRecipient> notificationRecipients, Role role, NotificationReceptionType notificationReceptionType, ExecutionContext executionContext) throws Exception {
        for (User user : this._getRoleUsers(role, executionContext)) {
            if (!user.isActive() || this._isSelfAssignedUser(executionContext, user)) continue;
            notificationRecipients.add(new NotificationRecipient(user, notificationReceptionType));
        }
    }

    @Deactivate
    protected void deactivate() {
        this._serviceTrackerList.close();
    }

    private List<Long> _getAncestorGroupIds(Group group, Role role) throws Exception {
        ArrayList<Long> groupIds = new ArrayList<Long>();
        for (Group ancestorGroup : group.getAncestors()) {
            if (!this._isValidGroup(group, role)) continue;
            groupIds.add(ancestorGroup.getGroupId());
        }
        return groupIds;
    }

    private List<Long> _getAncestorOrganizationGroupIds(Group group, Role role) throws Exception {
        ArrayList<Long> groupIds = new ArrayList<Long>();
        Organization organization = this.organizationLocalService.getOrganization(group.getOrganizationId());
        for (Organization ancestorOrganization : organization.getAncestors()) {
            if (!this._isValidGroup(group, role)) continue;
            groupIds.add(ancestorOrganization.getGroupId());
        }
        return groupIds;
    }

    private List<Long> _getGroupIds(long groupId, Role role) throws Exception {
        ArrayList<Long> groupIds = new ArrayList<Long>();
        if (groupId != 0L) {
            Group group = this.groupLocalService.getGroup(groupId);
            if (group.isOrganization()) {
                groupIds.addAll(this._getAncestorOrganizationGroupIds(group, role));
            }
            if (group.isSite() && !this._isPreventNotifyingAncestorSites()) {
                groupIds.addAll(this._getAncestorGroupIds(group, role));
            }
            if (this._isValidGroup(group, role)) {
                groupIds.add(groupId);
            }
        }
        return groupIds;
    }

    private List<User> _getRoleUsers(Role role, ExecutionContext executionContext) throws Exception {
        long roleId = role.getRoleId();
        if (role.getType() == 1) {
            return this.userLocalService.getInheritedRoleUsers(roleId, -1, -1, null);
        }
        KaleoInstanceToken kaleoInstanceToken = executionContext.getKaleoInstanceToken();
        List<Long> groupIds = this._getGroupIds(kaleoInstanceToken.getGroupId(), role);
        ArrayList<User> users = new ArrayList<User>();
        for (Long groupId : groupIds) {
            Group group;
            Object userGroupRole2;
            List userGroupRoles = this.userGroupRoleLocalService.getUserGroupRolesByGroupAndRole(groupId.longValue(), roleId);
            for (Object userGroupRole2 : userGroupRoles) {
                users.add(userGroupRole2.getUser());
            }
            List userGroupGroupRoles = this.userGroupGroupRoleLocalService.getUserGroupGroupRolesByGroupAndRole(groupId.longValue(), roleId);
            userGroupRole2 = userGroupGroupRoles.iterator();
            while (userGroupRole2.hasNext()) {
                UserGroupGroupRole userGroupGroupRole = (UserGroupGroupRole)userGroupRole2.next();
                users.addAll(this.userLocalService.getUserGroupUsers(userGroupGroupRole.getUserGroupId()));
            }
            if (Objects.equals(role.getName(), "Asset Library Member") || Objects.equals(role.getName(), "Site Member")) {
                users.addAll(this.userLocalService.getGroupUsers(groupId.longValue(), 0, null));
            }
            if (!Objects.equals(role.getName(), "Organization User") || !(group = this.groupLocalService.getGroup(groupId.longValue())).isOrganization()) continue;
            long organizationId = group.getClassPK();
            users.addAll(this.userLocalService.getOrganizationUsers(organizationId));
        }
        return users;
    }

    private boolean _isPreventNotifyingAncestorSites() {
        return this._workflowDefinitionConfiguration.preventNotifyingAncestorSites();
    }

    private boolean _isSelfAssignedUser(ExecutionContext executionContext, User user) {
        KaleoTaskInstanceToken kaleoTaskInstanceToken = executionContext.getKaleoTaskInstanceToken();
        if (kaleoTaskInstanceToken == null) {
            return false;
        }
        KaleoTaskAssignmentInstance kaleoTaskAssignmentInstance = kaleoTaskInstanceToken.getFirstKaleoTaskAssignmentInstance();
        return user.getUserId() == kaleoTaskAssignmentInstance.getUserId() && user.getUserId() == kaleoTaskAssignmentInstance.getAssigneeClassPK();
    }

    private boolean _isValidGroup(Group group, Role role) throws Exception {
        if (group != null && group.isDepot() && role.getType() == 5) {
            return true;
        }
        if (group != null && group.isOrganization() && role.getType() == 3) {
            return true;
        }
        if (group != null && group.isSite() && role.getType() == 2) {
            return true;
        }
        for (GroupAwareRoleValidator groupAwareRoleValidator : this._serviceTrackerList) {
            if (!groupAwareRoleValidator.isValidGroup(group, role)) continue;
            return true;
        }
        return false;
    }
}

