/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.workflow.kaleo.runtime.internal.timer.messaging;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.messaging.BaseMessageListener;
import com.liferay.portal.kernel.messaging.Destination;
import com.liferay.portal.kernel.messaging.DestinationConfiguration;
import com.liferay.portal.kernel.messaging.DestinationFactory;
import com.liferay.portal.kernel.messaging.Message;
import com.liferay.portal.kernel.messaging.MessageListener;
import com.liferay.portal.kernel.scheduler.SchedulerEngineHelperUtil;
import com.liferay.portal.kernel.scheduler.StorageType;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.workflow.kaleo.model.KaleoTimerInstanceToken;
import com.liferay.portal.workflow.kaleo.runtime.WorkflowEngine;
import com.liferay.portal.workflow.kaleo.runtime.util.SchedulerUtil;
import com.liferay.portal.workflow.kaleo.runtime.util.WorkflowContextUtil;
import com.liferay.portal.workflow.kaleo.service.KaleoTimerInstanceTokenLocalService;
import java.util.Map;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(property={"destination.name=destination.workflow_timer"}, service={MessageListener.class})
public class TimerMessageListener
extends BaseMessageListener {
    private static final int _MAXIMUM_QUEUE_SIZE = 200;
    private static final Log _log = LogFactoryUtil.getLog(TimerMessageListener.class);
    @Reference
    private DestinationFactory _destinationFactory;
    @Reference
    private KaleoTimerInstanceTokenLocalService _kaleoTimerInstanceTokenLocalService;
    private ServiceRegistration<Destination> _serviceRegistration;
    @Reference
    private WorkflowEngine _workflowEngine;

    @Activate
    protected void activate(BundleContext bundleContext) {
        DestinationConfiguration destinationConfiguration = new DestinationConfiguration("parallel", "destination.workflow_timer");
        destinationConfiguration.setMaximumQueueSize(200);
        ThreadPoolExecutor.CallerRunsPolicy rejectedExecutionHandler = new ThreadPoolExecutor.CallerRunsPolicy(){

            @Override
            public void rejectedExecution(Runnable runnable, ThreadPoolExecutor threadPoolExecutor) {
                if (_log.isWarnEnabled()) {
                    _log.warn((Object)"The current thread will handle the request because the workflow timer task queue is at its maximum capacity");
                }
                super.rejectedExecution(runnable, threadPoolExecutor);
            }
        };
        destinationConfiguration.setRejectedExecutionHandler((RejectedExecutionHandler)rejectedExecutionHandler);
        Destination destination = this._destinationFactory.createDestination(destinationConfiguration);
        this._serviceRegistration = bundleContext.registerService(Destination.class, (Object)destination, MapUtil.singletonDictionary((Object)"destination.name", (Object)destination.getName()));
    }

    @Deactivate
    protected void deactivate() {
        this._serviceRegistration.unregister();
    }

    protected void doReceive(Message message) throws Exception {
        KaleoTimerInstanceToken kaleoTimerInstanceToken = this._getKaleoTimerInstanceToken(message);
        Map workflowContext = WorkflowContextUtil.convert((String)kaleoTimerInstanceToken.getWorkflowContext());
        ServiceContext serviceContext = (ServiceContext)workflowContext.get("serviceContext");
        try {
            this._workflowEngine.executeTimerWorkflowInstance(kaleoTimerInstanceToken.getKaleoTimerInstanceTokenId(), serviceContext, workflowContext);
        }
        catch (Exception exception) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)("Unable to execute scheduled job. Unregistering job " + message), (Throwable)exception);
            }
            SchedulerEngineHelperUtil.delete((String)SchedulerUtil.getGroupName((long)kaleoTimerInstanceToken.getCompanyId(), (long)kaleoTimerInstanceToken.getKaleoTimerInstanceTokenId()), (StorageType)StorageType.PERSISTED);
        }
    }

    private KaleoTimerInstanceToken _getKaleoTimerInstanceToken(Message message) throws Exception {
        long kaleoTimerInstanceTokenId = message.getLong("kaleoTimerInstanceTokenId");
        return this._kaleoTimerInstanceTokenLocalService.getKaleoTimerInstanceToken(kaleoTimerInstanceTokenId);
    }
}

