/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.workflow.kaleo.runtime.integration.internal;

import com.liferay.petra.reflect.ReflectionUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.lock.DuplicateLockException;
import com.liferay.portal.kernel.lock.Lock;
import com.liferay.portal.kernel.lock.LockManager;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.UserGroupGroupRole;
import com.liferay.portal.kernel.model.UserModel;
import com.liferay.portal.kernel.search.BaseModelSearchResult;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.PermissionThreadLocal;
import com.liferay.portal.kernel.service.RoleLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserGroupGroupRoleLocalService;
import com.liferay.portal.kernel.service.UserGroupRoleLocalService;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.transaction.TransactionCommitCallbackUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.util.comparator.UserScreenNameComparator;
import com.liferay.portal.kernel.workflow.WorkflowException;
import com.liferay.portal.kernel.workflow.WorkflowTask;
import com.liferay.portal.kernel.workflow.WorkflowTaskManager;
import com.liferay.portal.kernel.workflow.search.WorkflowModelSearchResult;
import com.liferay.portal.workflow.kaleo.KaleoWorkflowModelConverter;
import com.liferay.portal.workflow.kaleo.model.KaleoInstance;
import com.liferay.portal.workflow.kaleo.model.KaleoInstanceToken;
import com.liferay.portal.workflow.kaleo.model.KaleoNode;
import com.liferay.portal.workflow.kaleo.model.KaleoTask;
import com.liferay.portal.workflow.kaleo.model.KaleoTaskAssignment;
import com.liferay.portal.workflow.kaleo.model.KaleoTaskAssignmentInstanceModel;
import com.liferay.portal.workflow.kaleo.model.KaleoTaskInstanceToken;
import com.liferay.portal.workflow.kaleo.model.KaleoTransitionModel;
import com.liferay.portal.workflow.kaleo.runtime.ExecutionContext;
import com.liferay.portal.workflow.kaleo.runtime.KaleoSignaler;
import com.liferay.portal.workflow.kaleo.runtime.TaskManager;
import com.liferay.portal.workflow.kaleo.runtime.assignment.TaskAssignmentSelector;
import com.liferay.portal.workflow.kaleo.runtime.assignment.TaskAssignmentSelectorRegistry;
import com.liferay.portal.workflow.kaleo.runtime.util.WorkflowContextUtil;
import com.liferay.portal.workflow.kaleo.runtime.util.comparator.KaleoTaskInstanceTokenOrderByComparator;
import com.liferay.portal.workflow.kaleo.service.KaleoTaskAssignmentInstanceLocalService;
import com.liferay.portal.workflow.kaleo.service.KaleoTaskAssignmentLocalService;
import com.liferay.portal.workflow.kaleo.service.KaleoTaskInstanceTokenLocalService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"proxy.bean=false"}, service={WorkflowTaskManager.class})
public class WorkflowTaskManagerImpl
implements WorkflowTaskManager {
    private static final Log _log = LogFactoryUtil.getLog(WorkflowTaskManagerImpl.class);
    @Reference
    private KaleoSignaler _kaleoSignaler;
    @Reference
    private KaleoTaskAssignmentInstanceLocalService _kaleoTaskAssignmentInstanceLocalService;
    @Reference
    private KaleoTaskAssignmentLocalService _kaleoTaskAssignmentLocalService;
    @Reference
    private KaleoTaskInstanceTokenLocalService _kaleoTaskInstanceTokenLocalService;
    @Reference
    private KaleoWorkflowModelConverter _kaleoWorkflowModelConverter;
    @Reference
    private LockManager _lockManager;
    @Reference
    private RoleLocalService _roleLocalService;
    @Reference
    private TaskAssignmentSelectorRegistry _taskAssignmentSelectorRegistry;
    @Reference
    private TaskManager _taskManager;
    @Reference
    private UserGroupGroupRoleLocalService _userGroupGroupRoleLocalService;
    @Reference
    private UserGroupRoleLocalService _userGroupRoleLocalService;
    @Reference
    private UserLocalService _userLocalService;

    public WorkflowTask assignWorkflowTaskToRole(long companyId, long userId, long workflowTaskId, long roleId, String comment, Date dueDate, Map<String, Serializable> workflowContext) throws WorkflowException {
        ServiceContext serviceContext = new ServiceContext();
        serviceContext.setCompanyId(companyId);
        serviceContext.setUserId(userId);
        return this._taskManager.assignWorkflowTaskToRole(workflowTaskId, roleId, comment, dueDate, workflowContext, serviceContext);
    }

    public WorkflowTask assignWorkflowTaskToUser(long companyId, long userId, long workflowTaskId, long assigneeUserId, String comment, Date dueDate, Map<String, Serializable> workflowContext) throws WorkflowException {
        PermissionChecker permissionChecker = PermissionThreadLocal.getPermissionChecker();
        if (permissionChecker.getUserId() != userId) {
            ReflectionUtil.throwException((Throwable)new PrincipalException());
        }
        ServiceContext serviceContext = new ServiceContext();
        serviceContext.setCompanyId(companyId);
        serviceContext.setUserId(userId);
        return this._taskManager.assignWorkflowTaskToUser(workflowTaskId, assigneeUserId, comment, dueDate, workflowContext, serviceContext);
    }

    public WorkflowTask completeWorkflowTask(long companyId, long userId, long workflowTaskId, final String transitionName, String comment, Map<String, Serializable> workflowContext) throws WorkflowException {
        Lock lock = null;
        try {
            lock = this._lockManager.lock(userId, WorkflowTask.class.getName(), workflowTaskId, String.valueOf(userId), false, 1000L);
        }
        catch (PortalException portalException) {
            if (portalException instanceof DuplicateLockException) {
                throw new WorkflowException(StringBundler.concat((Object[])new Object[]{"Workflow task ", workflowTaskId, " is locked by user ", userId}), (Throwable)portalException);
            }
            throw new WorkflowException("Unable to lock workflow task " + workflowTaskId, (Throwable)portalException);
        }
        try {
            ServiceContext serviceContext = new ServiceContext();
            serviceContext.setCompanyId(companyId);
            serviceContext.setUserId(userId);
            WorkflowTask workflowTask = this._taskManager.completeWorkflowTask(workflowTaskId, transitionName, comment, workflowContext, serviceContext);
            KaleoTaskInstanceToken kaleoTaskInstanceToken = this._kaleoTaskInstanceTokenLocalService.getKaleoTaskInstanceToken(workflowTask.getWorkflowTaskId());
            KaleoInstanceToken kaleoInstanceToken = kaleoTaskInstanceToken.getKaleoInstanceToken();
            if (workflowContext == null) {
                KaleoInstance kaleoInstance = kaleoInstanceToken.getKaleoInstance();
                workflowContext = WorkflowContextUtil.convert((String)kaleoInstance.getWorkflowContext());
            }
            workflowContext.put((String)"taskComments", (Serializable)((Object)comment));
            workflowContext.put("transitionName", transitionName);
            final ExecutionContext executionContext = new ExecutionContext(kaleoInstanceToken, kaleoTaskInstanceToken, workflowContext, serviceContext);
            TransactionCommitCallbackUtil.registerCallback((Callable)new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    try {
                        WorkflowTaskManagerImpl.this._kaleoSignaler.signalExit(transitionName, executionContext);
                    }
                    catch (Exception exception) {
                        throw new WorkflowException("Unable to signal next transition", (Throwable)exception);
                    }
                    return null;
                }
            });
            WorkflowTask workflowTask2 = workflowTask;
            return workflowTask2;
        }
        catch (WorkflowException workflowException) {
            throw workflowException;
        }
        catch (Exception exception) {
            throw new WorkflowException("Unable to complete task", (Throwable)exception);
        }
        finally {
            this._lockManager.unlock(lock.getClassName(), lock.getKey());
        }
    }

    public WorkflowTask fetchWorkflowTask(long companyId, long workflowTaskId) throws WorkflowException {
        KaleoTaskInstanceToken kaleoTaskInstanceToken = this._kaleoTaskInstanceTokenLocalService.fetchKaleoTaskInstanceToken(workflowTaskId);
        if (kaleoTaskInstanceToken == null) {
            return null;
        }
        try {
            return this._kaleoWorkflowModelConverter.toWorkflowTask(kaleoTaskInstanceToken, WorkflowContextUtil.convert((String)kaleoTaskInstanceToken.getWorkflowContext()));
        }
        catch (Exception exception) {
            throw new WorkflowException((Throwable)exception);
        }
    }

    public List<User> getAssignableUsers(long companyId, long workflowTaskId) throws WorkflowException {
        try {
            KaleoTaskInstanceToken kaleoTaskInstanceToken = this._kaleoTaskInstanceTokenLocalService.getKaleoTaskInstanceToken(workflowTaskId);
            if (kaleoTaskInstanceToken.isCompleted()) {
                return Collections.emptyList();
            }
            TreeSet<User> assignableUsers = new TreeSet<User>((Comparator<User>)new UserScreenNameComparator(true));
            long assignedUserId = this._getAssignedUserId(workflowTaskId);
            for (KaleoTaskAssignment calculatedKaleoTaskAssignment : this._getCalculatedKaleoTaskAssignments(kaleoTaskInstanceToken)) {
                this._populateAssignableUsers(calculatedKaleoTaskAssignment, kaleoTaskInstanceToken, assignableUsers, assignedUserId);
            }
            return ListUtil.fromCollection(assignableUsers);
        }
        catch (WorkflowException workflowException) {
            throw workflowException;
        }
        catch (Exception exception) {
            throw new WorkflowException((Throwable)exception);
        }
    }

    public List<String> getNextTransitionNames(long companyId, long userId, long workflowTaskId) throws WorkflowException {
        try {
            KaleoTaskInstanceToken kaleoTaskInstanceToken = this._kaleoTaskInstanceTokenLocalService.getKaleoTaskInstanceToken(workflowTaskId);
            if (kaleoTaskInstanceToken.isCompleted()) {
                return Collections.emptyList();
            }
            KaleoTask kaleoTask = kaleoTaskInstanceToken.getKaleoTask();
            KaleoNode kaleoNode = kaleoTask.getKaleoNode();
            return Stream.of(kaleoNode.getKaleoTransitions()).flatMap(Collection::parallelStream).map(KaleoTransitionModel::getName).collect(Collectors.toList());
        }
        catch (WorkflowException workflowException) {
            throw workflowException;
        }
        catch (Exception exception) {
            throw new WorkflowException((Throwable)exception);
        }
    }

    @Deprecated
    public List<User> getPooledActors(long companyId, long workflowTaskId) throws WorkflowException {
        return this.getAssignableUsers(companyId, workflowTaskId);
    }

    @Deprecated
    public long[] getPooledActorsIds(long companyId, long workflowTaskId) throws WorkflowException {
        List<User> users = this.getAssignableUsers(companyId, workflowTaskId);
        Stream stream = users.stream();
        return stream.mapToLong(UserModel::getUserId).toArray();
    }

    public WorkflowTask getWorkflowTask(long companyId, long workflowTaskId) throws WorkflowException {
        try {
            KaleoTaskInstanceToken kaleoTaskInstanceToken = this._kaleoTaskInstanceTokenLocalService.getKaleoTaskInstanceToken(workflowTaskId);
            return this._kaleoWorkflowModelConverter.toWorkflowTask(kaleoTaskInstanceToken, WorkflowContextUtil.convert((String)kaleoTaskInstanceToken.getWorkflowContext()));
        }
        catch (Exception exception) {
            throw new WorkflowException((Throwable)exception);
        }
    }

    public int getWorkflowTaskCount(long companyId, Boolean completed) throws WorkflowException {
        try {
            ServiceContext serviceContext = new ServiceContext();
            serviceContext.setCompanyId(companyId);
            return this._kaleoTaskInstanceTokenLocalService.getKaleoTaskInstanceTokensCount(completed, serviceContext);
        }
        catch (Exception exception) {
            throw new WorkflowException((Throwable)exception);
        }
    }

    public int getWorkflowTaskCountByRole(long companyId, long roleId, Boolean completed) throws WorkflowException {
        try {
            ServiceContext serviceContext = new ServiceContext();
            serviceContext.setCompanyId(companyId);
            return this._kaleoTaskInstanceTokenLocalService.getKaleoTaskInstanceTokensCount(Role.class.getName(), roleId, completed, serviceContext);
        }
        catch (Exception exception) {
            throw new WorkflowException((Throwable)exception);
        }
    }

    public int getWorkflowTaskCountBySubmittingUser(long companyId, long userId, Boolean completed) throws WorkflowException {
        try {
            ServiceContext serviceContext = new ServiceContext();
            serviceContext.setCompanyId(companyId);
            return this._kaleoTaskInstanceTokenLocalService.getSubmittingUserKaleoTaskInstanceTokensCount(userId, completed, serviceContext);
        }
        catch (Exception exception) {
            throw new WorkflowException((Throwable)exception);
        }
    }

    public int getWorkflowTaskCountByUser(long companyId, long userId, Boolean completed) throws WorkflowException {
        try {
            ServiceContext serviceContext = new ServiceContext();
            serviceContext.setCompanyId(companyId);
            serviceContext.setUserId(userId);
            return this._kaleoTaskInstanceTokenLocalService.getKaleoTaskInstanceTokensCount(User.class.getName(), serviceContext.getUserId(), completed, serviceContext);
        }
        catch (Exception exception) {
            throw new WorkflowException((Throwable)exception);
        }
    }

    public int getWorkflowTaskCountByUserRoles(long companyId, long userId, Boolean completed) throws WorkflowException {
        try {
            ServiceContext serviceContext = new ServiceContext();
            serviceContext.setCompanyId(companyId);
            serviceContext.setUserId(userId);
            return this._kaleoTaskInstanceTokenLocalService.searchCount(null, completed, Boolean.TRUE, serviceContext);
        }
        catch (Exception exception) {
            throw new WorkflowException((Throwable)exception);
        }
    }

    public int getWorkflowTaskCountByUserRoles(long companyId, long userId, long workflowInstanceId, Boolean completed) throws WorkflowException {
        try {
            ServiceContext serviceContext = new ServiceContext();
            serviceContext.setCompanyId(companyId);
            serviceContext.setUserId(userId);
            return this._kaleoTaskInstanceTokenLocalService.searchCount(workflowInstanceId, completed, Boolean.TRUE, serviceContext);
        }
        catch (Exception exception) {
            throw new WorkflowException((Throwable)exception);
        }
    }

    public int getWorkflowTaskCountByWorkflowInstance(long companyId, Long userId, long workflowInstanceId, Boolean completed) throws WorkflowException {
        try {
            ServiceContext serviceContext = new ServiceContext();
            serviceContext.setCompanyId(companyId);
            if (userId != null) {
                serviceContext.setUserId(userId.longValue());
            }
            return this._kaleoTaskInstanceTokenLocalService.getKaleoTaskInstanceTokensCount(workflowInstanceId, completed, serviceContext);
        }
        catch (Exception exception) {
            throw new WorkflowException((Throwable)exception);
        }
    }

    public List<WorkflowTask> getWorkflowTasks(long companyId, Boolean completed, int start, int end, OrderByComparator<WorkflowTask> orderByComparator) throws WorkflowException {
        try {
            ServiceContext serviceContext = new ServiceContext();
            serviceContext.setCompanyId(companyId);
            List kaleoTaskInstanceTokens = this._kaleoTaskInstanceTokenLocalService.getKaleoTaskInstanceTokens(completed, start, end, KaleoTaskInstanceTokenOrderByComparator.getOrderByComparator(orderByComparator, (KaleoWorkflowModelConverter)this._kaleoWorkflowModelConverter), serviceContext);
            return this._toWorkflowTasks(kaleoTaskInstanceTokens);
        }
        catch (Exception exception) {
            throw new WorkflowException((Throwable)exception);
        }
    }

    public List<WorkflowTask> getWorkflowTasksByRole(long companyId, long roleId, Boolean completed, int start, int end, OrderByComparator<WorkflowTask> orderByComparator) throws WorkflowException {
        try {
            ServiceContext serviceContext = new ServiceContext();
            serviceContext.setCompanyId(companyId);
            List kaleoTaskInstanceTokens = this._kaleoTaskInstanceTokenLocalService.getKaleoTaskInstanceTokens(Role.class.getName(), roleId, completed, start, end, KaleoTaskInstanceTokenOrderByComparator.getOrderByComparator(orderByComparator, (KaleoWorkflowModelConverter)this._kaleoWorkflowModelConverter), serviceContext);
            return this._toWorkflowTasks(kaleoTaskInstanceTokens);
        }
        catch (Exception exception) {
            throw new WorkflowException((Throwable)exception);
        }
    }

    public List<WorkflowTask> getWorkflowTasksBySubmittingUser(long companyId, long userId, Boolean completed, int start, int end, OrderByComparator<WorkflowTask> orderByComparator) throws WorkflowException {
        try {
            ServiceContext serviceContext = new ServiceContext();
            serviceContext.setCompanyId(companyId);
            List kaleoTaskInstanceTokens = this._kaleoTaskInstanceTokenLocalService.getSubmittingUserKaleoTaskInstanceTokens(userId, completed, start, end, KaleoTaskInstanceTokenOrderByComparator.getOrderByComparator(orderByComparator, (KaleoWorkflowModelConverter)this._kaleoWorkflowModelConverter), serviceContext);
            return this._toWorkflowTasks(kaleoTaskInstanceTokens);
        }
        catch (Exception exception) {
            throw new WorkflowException((Throwable)exception);
        }
    }

    public List<WorkflowTask> getWorkflowTasksByUser(long companyId, long userId, Boolean completed, int start, int end, OrderByComparator<WorkflowTask> orderByComparator) throws WorkflowException {
        try {
            ServiceContext serviceContext = new ServiceContext();
            serviceContext.setCompanyId(companyId);
            List kaleoTaskInstanceTokens = this._kaleoTaskInstanceTokenLocalService.getKaleoTaskInstanceTokens(User.class.getName(), userId, completed, start, end, KaleoTaskInstanceTokenOrderByComparator.getOrderByComparator(orderByComparator, (KaleoWorkflowModelConverter)this._kaleoWorkflowModelConverter), serviceContext);
            return this._toWorkflowTasks(kaleoTaskInstanceTokens);
        }
        catch (Exception exception) {
            throw new WorkflowException((Throwable)exception);
        }
    }

    public List<WorkflowTask> getWorkflowTasksByUserRoles(long companyId, long userId, Boolean completed, int start, int end, OrderByComparator<WorkflowTask> orderByComparator) throws WorkflowException {
        try {
            ServiceContext serviceContext = new ServiceContext();
            serviceContext.setCompanyId(companyId);
            serviceContext.setUserId(userId);
            List kaleoTaskInstanceTokens = this._kaleoTaskInstanceTokenLocalService.search(null, completed, Boolean.TRUE, start, end, KaleoTaskInstanceTokenOrderByComparator.getOrderByComparator(orderByComparator, (KaleoWorkflowModelConverter)this._kaleoWorkflowModelConverter), serviceContext);
            return this._toWorkflowTasks(kaleoTaskInstanceTokens);
        }
        catch (Exception exception) {
            throw new WorkflowException((Throwable)exception);
        }
    }

    public List<WorkflowTask> getWorkflowTasksByWorkflowInstance(long companyId, Long userId, long workflowInstanceId, Boolean completed, int start, int end, OrderByComparator<WorkflowTask> orderByComparator) throws WorkflowException {
        try {
            ServiceContext serviceContext = new ServiceContext();
            serviceContext.setCompanyId(companyId);
            if (userId != null) {
                serviceContext.setUserId(userId.longValue());
            }
            List kaleoTaskInstanceTokens = this._kaleoTaskInstanceTokenLocalService.getKaleoTaskInstanceTokens(workflowInstanceId, completed, start, end, KaleoTaskInstanceTokenOrderByComparator.getOrderByComparator(orderByComparator, (KaleoWorkflowModelConverter)this._kaleoWorkflowModelConverter), serviceContext);
            return this._toWorkflowTasks(kaleoTaskInstanceTokens);
        }
        catch (Exception exception) {
            throw new WorkflowException((Throwable)exception);
        }
    }

    public boolean hasAssignableUsers(long companyId, long workflowTaskId) throws WorkflowException {
        try {
            KaleoTaskInstanceToken kaleoTaskInstanceToken = this._kaleoTaskInstanceTokenLocalService.getKaleoTaskInstanceToken(workflowTaskId);
            if (kaleoTaskInstanceToken.isCompleted()) {
                return false;
            }
            long assignedUserId = this._getAssignedUserId(workflowTaskId);
            ExecutionContext executionContext = this._createExecutionContext(kaleoTaskInstanceToken);
            List configuredKaleoTaskAssignments = this._kaleoTaskAssignmentLocalService.getKaleoTaskAssignments(kaleoTaskInstanceToken.getKaleoTaskId());
            for (KaleoTaskAssignment configuredKaleoTaskAssignment : configuredKaleoTaskAssignments) {
                Collection<KaleoTaskAssignment> calculatedKaleoTaskAssignments = this._getKaleoTaskAssignments(configuredKaleoTaskAssignment, executionContext);
                for (KaleoTaskAssignment calculatedKaleoTaskAssignment : calculatedKaleoTaskAssignments) {
                    if (!this._hasAssignableUsers(calculatedKaleoTaskAssignment, kaleoTaskInstanceToken, assignedUserId)) continue;
                    return true;
                }
            }
            return false;
        }
        catch (WorkflowException workflowException) {
            throw workflowException;
        }
        catch (Exception exception) {
            throw new WorkflowException((Throwable)exception);
        }
    }

    @Deprecated
    public boolean hasOtherAssignees(long workflowTaskId, long userId) throws WorkflowException {
        return this.hasAssignableUsers(CompanyThreadLocal.getCompanyId(), workflowTaskId);
    }

    @Deprecated
    public List<WorkflowTask> search(long companyId, long userId, String keywords, Boolean completed, Boolean searchByUserRoles, int start, int end, OrderByComparator<WorkflowTask> orderByComparator) throws WorkflowException {
        return this.search(companyId, userId, null, this._getTaskNames(keywords), this._getAssetTypes(keywords), null, null, null, null, null, completed, searchByUserRoles, null, null, false, start, end, orderByComparator);
    }

    @Deprecated
    public List<WorkflowTask> search(long companyId, long userId, String taskName, String assetType, Long[] assetPrimaryKeys, Date dueDateGT, Date dueDateLT, Boolean completed, Boolean searchByUserRoles, boolean andOperator, int start, int end, OrderByComparator<WorkflowTask> orderByComparator) throws WorkflowException {
        return this.search(companyId, userId, null, this._getTaskNames(taskName), this._getAssetTypes(assetType), assetPrimaryKeys, null, null, dueDateGT, dueDateLT, completed, searchByUserRoles, null, null, andOperator, start, end, orderByComparator);
    }

    @Deprecated
    public List<WorkflowTask> search(long companyId, long userId, String assetTitle, String taskName, String[] assetTypes, Long[] assetPrimaryKeys, Date dueDateGT, Date dueDateLT, Boolean completed, Boolean searchByUserRoles, Boolean andOperator, int start, int end, OrderByComparator<WorkflowTask> orderByComparator) throws WorkflowException {
        return this.search(companyId, userId, assetTitle, this._getTaskNames(taskName), assetTypes, assetPrimaryKeys, null, null, dueDateGT, dueDateLT, completed, searchByUserRoles, null, null, andOperator, start, end, orderByComparator);
    }

    @Deprecated
    public List<WorkflowTask> search(long companyId, long userId, String keywords, String[] assetTypes, Boolean completed, Boolean searchByUserRoles, int start, int end, OrderByComparator<WorkflowTask> orderByComparator) throws WorkflowException {
        return this.search(companyId, userId, keywords, this._getTaskNames(keywords), assetTypes, null, null, null, null, null, completed, searchByUserRoles, null, null, false, start, end, orderByComparator);
    }

    @Deprecated
    public List<WorkflowTask> search(long companyId, long userId, String assetTitle, String[] taskNames, String[] assetTypes, Long[] assetPrimaryKeys, Long[] assigneeIds, Date dueDateGT, Date dueDateLT, Boolean completed, Boolean searchByUserRoles, Long[] workflowInstanceIds, Boolean andOperator, int start, int end, OrderByComparator<WorkflowTask> orderByComparator) throws WorkflowException {
        return this.search(companyId, userId, assetTitle, taskNames, assetTypes, assetPrimaryKeys, null, assigneeIds, dueDateGT, dueDateLT, completed, searchByUserRoles, null, workflowInstanceIds, andOperator, start, end, orderByComparator);
    }

    public List<WorkflowTask> search(long companyId, long userId, String assetTitle, String[] taskNames, String[] assetTypes, Long[] assetPrimaryKeys, String assigneeClassName, Long[] assigneeIds, Date dueDateGT, Date dueDateLT, Boolean completed, Boolean searchByUserRoles, Long workflowDefinitionId, Long[] workflowInstanceIds, Boolean andOperator, int start, int end, OrderByComparator<WorkflowTask> orderByComparator) throws WorkflowException {
        try {
            WorkflowModelSearchResult<WorkflowTask> workflowModelSearchResult = this.searchWorkflowTasks(companyId, userId, assetTitle, taskNames, assetTypes, assetPrimaryKeys, assigneeClassName, assigneeIds, dueDateGT, dueDateLT, completed, searchByUserRoles, workflowDefinitionId, workflowInstanceIds, andOperator, start, end, orderByComparator);
            return workflowModelSearchResult.getWorkflowModels();
        }
        catch (Exception exception) {
            throw new WorkflowException((Throwable)exception);
        }
    }

    @Deprecated
    public int searchCount(long companyId, long userId, String keywords, Boolean completed, Boolean searchByUserRoles) throws WorkflowException {
        return this.searchCount(companyId, userId, null, this._getTaskNames(keywords), this._getAssetTypes(keywords), null, null, null, null, null, completed, searchByUserRoles, null, null, false);
    }

    @Deprecated
    public int searchCount(long companyId, long userId, String taskName, String assetType, Long[] assetPrimaryKeys, Date dueDateGT, Date dueDateLT, Boolean completed, Boolean searchByUserRoles, boolean andOperator) throws WorkflowException {
        return this.searchCount(companyId, userId, null, this._getTaskNames(taskName), this._getAssetTypes(assetType), assetPrimaryKeys, null, null, dueDateGT, dueDateLT, completed, searchByUserRoles, null, null, andOperator);
    }

    @Deprecated
    public int searchCount(long companyId, long userId, String assetTitle, String taskName, String[] assetTypes, Long[] assetPrimaryKeys, Date dueDateGT, Date dueDateLT, Boolean completed, Boolean searchByUserRoles, Boolean andOperator) throws WorkflowException {
        return this.searchCount(companyId, userId, assetTitle, this._getTaskNames(taskName), assetTypes, assetPrimaryKeys, null, null, dueDateGT, dueDateLT, completed, searchByUserRoles, null, null, andOperator);
    }

    @Deprecated
    public int searchCount(long companyId, long userId, String keywords, String[] assetTypes, Boolean completed, Boolean searchByUserRoles) throws WorkflowException {
        return this.searchCount(companyId, userId, keywords, this._getTaskNames(keywords), assetTypes, null, null, null, null, null, completed, searchByUserRoles, null, null, false);
    }

    @Deprecated
    public int searchCount(long companyId, long userId, String assetTitle, String[] taskNames, String[] assetTypes, Long[] assetPrimaryKeys, Long[] assigneeIds, Date dueDateGT, Date dueDateLT, Boolean completed, Boolean searchByUserRoles, Long[] workflowInstanceIds, Boolean andOperator) throws WorkflowException {
        return this.searchCount(companyId, userId, assetTitle, taskNames, assetTypes, assetPrimaryKeys, null, assigneeIds, dueDateGT, dueDateLT, completed, searchByUserRoles, null, workflowInstanceIds, andOperator);
    }

    public int searchCount(long companyId, long userId, String assetTitle, String[] taskNames, String[] assetTypes, Long[] assetPrimaryKeys, String assigneeClassName, Long[] assigneeIds, Date dueDateGT, Date dueDateLT, Boolean completed, Boolean searchByUserRoles, Long workflowDefinitionId, Long[] workflowInstanceIds, Boolean andOperator) throws WorkflowException {
        try {
            ServiceContext serviceContext = new ServiceContext();
            serviceContext.setCompanyId(companyId);
            serviceContext.setUserId(userId);
            return this._kaleoTaskInstanceTokenLocalService.searchCount(assetTitle, taskNames, assetTypes, assetPrimaryKeys, assigneeClassName, assigneeIds, dueDateGT, dueDateLT, completed, workflowDefinitionId, workflowInstanceIds, searchByUserRoles, andOperator.booleanValue(), serviceContext);
        }
        catch (Exception exception) {
            throw new WorkflowException((Throwable)exception);
        }
    }

    public WorkflowModelSearchResult<WorkflowTask> searchWorkflowTasks(long companyId, long userId, String assetTitle, String[] taskNames, String[] assetTypes, Long[] assetPrimaryKeys, String assigneeClassName, Long[] assigneeIds, Date dueDateGT, Date dueDateLT, Boolean completed, Boolean searchByUserRoles, Long workflowDefinitionId, Long[] workflowInstanceIds, Boolean andOperator, int start, int end, OrderByComparator<WorkflowTask> orderByComparator) throws WorkflowException {
        try {
            ServiceContext serviceContext = new ServiceContext();
            serviceContext.setCompanyId(companyId);
            serviceContext.setUserId(userId);
            BaseModelSearchResult baseModelSearchResult = this._kaleoTaskInstanceTokenLocalService.searchKaleoTaskInstanceTokens(assetTitle, taskNames, assetTypes, assetPrimaryKeys, assigneeClassName, assigneeIds, dueDateGT, dueDateLT, completed, workflowDefinitionId, workflowInstanceIds, searchByUserRoles, andOperator.booleanValue(), start, end, KaleoTaskInstanceTokenOrderByComparator.getOrderByComparator(orderByComparator, (KaleoWorkflowModelConverter)this._kaleoWorkflowModelConverter), serviceContext);
            return new WorkflowModelSearchResult(this._toWorkflowTasks(baseModelSearchResult.getBaseModels()), baseModelSearchResult.getLength());
        }
        catch (Exception exception) {
            throw new WorkflowException((Throwable)exception);
        }
    }

    public WorkflowTask updateDueDate(long companyId, long userId, long workflowTaskId, String comment, Date dueDate) throws WorkflowException {
        ServiceContext serviceContext = new ServiceContext();
        serviceContext.setCompanyId(companyId);
        serviceContext.setUserId(userId);
        return this._taskManager.updateDueDate(workflowTaskId, comment, dueDate, serviceContext);
    }

    private ExecutionContext _createExecutionContext(KaleoTaskInstanceToken kaleoTaskInstanceToken) throws PortalException {
        KaleoInstanceToken kaleoInstanceToken = kaleoTaskInstanceToken.getKaleoInstanceToken();
        Map workflowContext = WorkflowContextUtil.convert((String)kaleoTaskInstanceToken.getWorkflowContext());
        ServiceContext workflowContextServiceContext = (ServiceContext)workflowContext.get("serviceContext");
        return new ExecutionContext(kaleoInstanceToken, workflowContext, workflowContextServiceContext);
    }

    private String[] _getAssetTypes(String assetType) {
        if (Validator.isNull((String)assetType)) {
            return null;
        }
        return new String[]{assetType};
    }

    private long _getAssignedUserId(long kaleoTaskInstanceTokenId) {
        return Stream.of(this._kaleoTaskAssignmentInstanceLocalService.getKaleoTaskAssignmentInstances(kaleoTaskInstanceTokenId)).flatMap(Collection::parallelStream).filter(kaleoTaskAssignmentInstance -> {
            String assigneeClassName = kaleoTaskAssignmentInstance.getAssigneeClassName();
            return assigneeClassName.equals(User.class.getName());
        }).map(KaleoTaskAssignmentInstanceModel::getAssigneeClassPK).findFirst().orElseGet(() -> 0L);
    }

    private List<KaleoTaskAssignment> _getCalculatedKaleoTaskAssignments(KaleoTaskInstanceToken kaleoTaskInstanceToken) throws PortalException {
        ArrayList<KaleoTaskAssignment> calculatedKaleoTaskAssignments = new ArrayList<KaleoTaskAssignment>();
        ExecutionContext executionContext = this._createExecutionContext(kaleoTaskInstanceToken);
        List configuredKaleoTaskAssignments = this._kaleoTaskAssignmentLocalService.getKaleoTaskAssignments(kaleoTaskInstanceToken.getKaleoTaskId());
        for (KaleoTaskAssignment configuredKaleoTaskAssignment : configuredKaleoTaskAssignments) {
            calculatedKaleoTaskAssignments.addAll(this._getKaleoTaskAssignments(configuredKaleoTaskAssignment, executionContext));
        }
        return calculatedKaleoTaskAssignments;
    }

    private Collection<KaleoTaskAssignment> _getKaleoTaskAssignments(KaleoTaskAssignment kaleoTaskAssignment, ExecutionContext executionContext) throws PortalException {
        TaskAssignmentSelector taskAssignmentSelector = this._taskAssignmentSelectorRegistry.getTaskAssignmentSelector(kaleoTaskAssignment.getAssigneeClassName());
        return taskAssignmentSelector.calculateTaskAssignments(kaleoTaskAssignment, executionContext);
    }

    private String[] _getTaskNames(String taskName) {
        if (Validator.isNull((String)taskName)) {
            return null;
        }
        return new String[]{taskName};
    }

    private boolean _hasAssignableUsers(KaleoTaskAssignment kaleoTaskAssignment, KaleoTaskInstanceToken kaleoTaskInstanceToken, long assignedUserId) throws PortalException {
        String assigneeClassName = kaleoTaskAssignment.getAssigneeClassName();
        long assigneeClassPK = kaleoTaskAssignment.getAssigneeClassPK();
        if (assigneeClassName.equals(User.class.getName())) {
            if (assignedUserId == assigneeClassPK) {
                return false;
            }
            User user = this._userLocalService.fetchUser(assigneeClassPK);
            return user != null && user.isActive();
        }
        Role role = this._roleLocalService.getRole(assigneeClassPK);
        if (role.getType() == 5 || role.getType() == 3 || role.getType() == 2) {
            if (Objects.equals(role.getName(), "Asset Library Member") || Objects.equals(role.getName(), "Site Member")) {
                List users = this._userLocalService.getGroupUsers(kaleoTaskInstanceToken.getGroupId(), 0, null);
                for (User user : users) {
                    if (user.getUserId() == assignedUserId) continue;
                    return true;
                }
            }
            List userGroupRoles = this._userGroupRoleLocalService.getUserGroupRolesByGroupAndRole(kaleoTaskInstanceToken.getGroupId(), assigneeClassPK);
            for (Object userGroupRole : userGroupRoles) {
                User user = userGroupRole.getUser();
                if (!user.isActive() || user.getUserId() == assignedUserId) continue;
                return true;
            }
            List userGroupGroupRoles = this._userGroupGroupRoleLocalService.getUserGroupGroupRolesByGroupAndRole(kaleoTaskInstanceToken.getGroupId(), assigneeClassPK);
            for (UserGroupGroupRole userGroupGroupRole : userGroupGroupRoles) {
                List userGroupUsers = this._userLocalService.getUserGroupUsers(userGroupGroupRole.getUserGroupId());
                for (User user : userGroupUsers) {
                    if (!user.isActive() || user.getUserId() == assignedUserId) continue;
                    return true;
                }
            }
        } else {
            List inheritedRoleUsers = this._userLocalService.getInheritedRoleUsers(assigneeClassPK, -1, -1, null);
            for (User user : inheritedRoleUsers) {
                if (!user.isActive() || user.getUserId() == assignedUserId) continue;
                return true;
            }
        }
        return false;
    }

    private void _populateAssignableUsers(KaleoTaskAssignment kaleoTaskAssignment, KaleoTaskInstanceToken kaleoTaskInstanceToken, Set<User> assignableUsers, long assignedUserId) throws PortalException {
        String assigneeClassName = kaleoTaskAssignment.getAssigneeClassName();
        long assigneeClassPK = kaleoTaskAssignment.getAssigneeClassPK();
        if (assigneeClassName.equals(User.class.getName())) {
            if (assignedUserId == assigneeClassPK) {
                return;
            }
            User user2 = this._userLocalService.fetchUser(assigneeClassPK);
            if (user2 != null && user2.isActive()) {
                assignableUsers.add(user2);
            }
            return;
        }
        Role role = this._roleLocalService.getRole(assigneeClassPK);
        if (role.getType() == 5 || role.getType() == 3 || role.getType() == 2) {
            if (Objects.equals(role.getName(), "Asset Library Member") || Objects.equals(role.getName(), "Site Member")) {
                assignableUsers.addAll(Stream.of(this._userLocalService.getGroupUsers(kaleoTaskInstanceToken.getGroupId(), 0, null)).flatMap(Collection::parallelStream).filter(user -> user.getUserId() != assignedUserId).collect(Collectors.toList()));
                return;
            }
            assignableUsers.addAll(Stream.of(this._userGroupRoleLocalService.getUserGroupRolesByGroupAndRole(kaleoTaskInstanceToken.getGroupId(), assigneeClassPK)).flatMap(Collection::parallelStream).map(userGroupRole -> {
                try {
                    return userGroupRole.getUser();
                }
                catch (PortalException portalException) {
                    if (_log.isWarnEnabled()) {
                        _log.warn((Object)portalException, (Throwable)portalException);
                    }
                    return null;
                }
            }).filter(user -> user != null && user.isActive() && user.getUserId() != assignedUserId).collect(Collectors.toList()));
            assignableUsers.addAll(Stream.of(this._userGroupGroupRoleLocalService.getUserGroupGroupRolesByGroupAndRole(kaleoTaskInstanceToken.getGroupId(), assigneeClassPK)).flatMap(Collection::parallelStream).map(userGroupGroupRole -> this._userLocalService.getUserGroupUsers(userGroupGroupRole.getUserGroupId())).flatMap(Collection::parallelStream).filter(user -> user.isActive() && user.getUserId() != assignedUserId).collect(Collectors.toList()));
        } else {
            assignableUsers.addAll(Stream.of(this._userLocalService.getInheritedRoleUsers(assigneeClassPK, -1, -1, null)).flatMap(Collection::parallelStream).filter(user -> user.isActive() && user.getUserId() != assignedUserId).collect(Collectors.toList()));
        }
    }

    private List<WorkflowTask> _toWorkflowTasks(List<KaleoTaskInstanceToken> kaleoTaskInstanceTokens) throws PortalException {
        ArrayList<WorkflowTask> workflowTasks = new ArrayList<WorkflowTask>(kaleoTaskInstanceTokens.size());
        for (KaleoTaskInstanceToken kaleoTaskInstanceToken : kaleoTaskInstanceTokens) {
            WorkflowTask workflowTask = this._kaleoWorkflowModelConverter.toWorkflowTask(kaleoTaskInstanceToken, WorkflowContextUtil.convert((String)kaleoTaskInstanceToken.getWorkflowContext()));
            workflowTasks.add(workflowTask);
        }
        return workflowTasks;
    }
}

