/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.workflow.kaleo.runtime.integration.internal;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.io.unsync.UnsyncByteArrayInputStream;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.WorkflowDefinitionLinkLocalService;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.uuid.PortalUUID;
import com.liferay.portal.kernel.workflow.RequiredWorkflowDefinitionException;
import com.liferay.portal.kernel.workflow.WorkflowDefinition;
import com.liferay.portal.kernel.workflow.WorkflowDefinitionManager;
import com.liferay.portal.kernel.workflow.WorkflowException;
import com.liferay.portal.kernel.workflow.comparator.WorkflowComparatorFactory;
import com.liferay.portal.lock.service.LockLocalService;
import com.liferay.portal.workflow.kaleo.KaleoWorkflowModelConverter;
import com.liferay.portal.workflow.kaleo.definition.parser.WorkflowModelParser;
import com.liferay.portal.workflow.kaleo.model.KaleoDefinition;
import com.liferay.portal.workflow.kaleo.model.KaleoDefinitionVersion;
import com.liferay.portal.workflow.kaleo.runtime.WorkflowEngine;
import com.liferay.portal.workflow.kaleo.runtime.integration.internal.util.WorkflowLockUtil;
import com.liferay.portal.workflow.kaleo.runtime.util.comparator.KaleoDefinitionOrderByComparator;
import com.liferay.portal.workflow.kaleo.service.KaleoDefinitionLocalService;
import com.liferay.portal.workflow.kaleo.service.KaleoDefinitionVersionLocalService;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"proxy.bean=false"}, service={WorkflowDefinitionManager.class})
public class WorkflowDefinitionManagerImpl
implements WorkflowDefinitionManager {
    @Reference
    protected PortalUUID portalUUID;
    @Reference
    private KaleoDefinitionLocalService _kaleoDefinitionLocalService;
    @Reference
    private KaleoDefinitionVersionLocalService _kaleoDefinitionVersionLocalService;
    @Reference
    private KaleoWorkflowModelConverter _kaleoWorkflowModelConverter;
    @Reference
    private LockLocalService _lockLocalService;
    @Reference
    private WorkflowComparatorFactory _workflowComparatorFactory;
    @Reference
    private WorkflowDefinitionLinkLocalService _workflowDefinitionLinkLocalService;
    @Reference
    private WorkflowEngine _workflowEngine;
    @Reference
    private WorkflowModelParser _workflowModelParser;

    public WorkflowDefinition deployWorkflowDefinition(long companyId, long userId, String title, String name, byte[] bytes) throws WorkflowException {
        return this.deployWorkflowDefinition(companyId, userId, title, name, "all", bytes);
    }

    public WorkflowDefinition deployWorkflowDefinition(long companyId, long userId, String title, String name, String scope, byte[] bytes) throws WorkflowException {
        ServiceContext serviceContext = new ServiceContext();
        serviceContext.setCompanyId(companyId);
        serviceContext.setUserId(userId);
        return this._workflowEngine.deployWorkflowDefinition(title, name, scope, (InputStream)new UnsyncByteArrayInputStream(bytes), serviceContext);
    }

    public List<WorkflowDefinition> getActiveWorkflowDefinitions(long companyId, int start, int end, OrderByComparator<WorkflowDefinition> orderByComparator) throws WorkflowException {
        try {
            if (orderByComparator == null) {
                orderByComparator = this._workflowComparatorFactory.getDefinitionNameComparator(true);
            }
            ServiceContext serviceContext = new ServiceContext();
            serviceContext.setCompanyId(companyId);
            List kaleoDefinitions = this._kaleoDefinitionLocalService.getScopeKaleoDefinitions("all", true, start, end, KaleoDefinitionOrderByComparator.getOrderByComparator((OrderByComparator)orderByComparator, (KaleoWorkflowModelConverter)this._kaleoWorkflowModelConverter), serviceContext);
            int size = kaleoDefinitions.size();
            return this._toWorkflowDefinitions(kaleoDefinitions.toArray(new KaleoDefinition[size]), (OrderByComparator<WorkflowDefinition>)orderByComparator);
        }
        catch (Exception exception) {
            throw new WorkflowException((Throwable)exception);
        }
    }

    public List<WorkflowDefinition> getActiveWorkflowDefinitions(long companyId, String name, int start, int end, OrderByComparator<WorkflowDefinition> orderByComparator) throws WorkflowException {
        try {
            ServiceContext serviceContext = new ServiceContext();
            serviceContext.setCompanyId(companyId);
            ArrayList<KaleoDefinition> kaleoDefinitions = new ArrayList<KaleoDefinition>();
            KaleoDefinition kaleoDefinition = this._kaleoDefinitionLocalService.getKaleoDefinition(name, serviceContext);
            if (kaleoDefinition.isActive()) {
                kaleoDefinitions.add(kaleoDefinition);
            }
            int size = kaleoDefinitions.size();
            return this._toWorkflowDefinitions(kaleoDefinitions.toArray(new KaleoDefinition[size]), orderByComparator);
        }
        catch (WorkflowException workflowException) {
            throw workflowException;
        }
        catch (Exception exception) {
            throw new WorkflowException((Throwable)exception);
        }
    }

    public int getActiveWorkflowDefinitionsCount(long companyId) throws WorkflowException {
        try {
            ServiceContext serviceContext = new ServiceContext();
            serviceContext.setCompanyId(companyId);
            return this._kaleoDefinitionLocalService.getScopeKaleoDefinitionsCount("all", true, serviceContext);
        }
        catch (Exception exception) {
            throw new WorkflowException((Throwable)exception);
        }
    }

    public WorkflowDefinition getLatestWorkflowDefinition(long companyId, String name) throws WorkflowException {
        try {
            ServiceContext serviceContext = new ServiceContext();
            serviceContext.setCompanyId(companyId);
            return this._kaleoWorkflowModelConverter.toWorkflowDefinition(this._kaleoDefinitionLocalService.getKaleoDefinition(name, serviceContext));
        }
        catch (WorkflowException workflowException) {
            throw workflowException;
        }
        catch (Exception exception) {
            throw new WorkflowException((Throwable)exception);
        }
    }

    public List<WorkflowDefinition> getLatestWorkflowDefinitions(Boolean active, long companyId, int start, int end, OrderByComparator<WorkflowDefinition> orderByComparator) throws WorkflowException {
        try {
            ServiceContext serviceContext = new ServiceContext();
            serviceContext.setCompanyId(companyId);
            List kaleoDefinitions = null;
            kaleoDefinitions = active == null ? this._kaleoDefinitionLocalService.getScopeKaleoDefinitions("all", start, end, KaleoDefinitionOrderByComparator.getOrderByComparator(orderByComparator, (KaleoWorkflowModelConverter)this._kaleoWorkflowModelConverter), serviceContext) : this._kaleoDefinitionLocalService.getScopeKaleoDefinitions("all", active.booleanValue(), start, end, KaleoDefinitionOrderByComparator.getOrderByComparator(orderByComparator, (KaleoWorkflowModelConverter)this._kaleoWorkflowModelConverter), serviceContext);
            int size = kaleoDefinitions.size();
            return this._toWorkflowDefinitions(kaleoDefinitions.toArray(new KaleoDefinition[size]), orderByComparator);
        }
        catch (Exception exception) {
            throw new WorkflowException((Throwable)exception);
        }
    }

    public int getLatestWorkflowDefinitionsCount(Boolean active, long companyId) throws WorkflowException {
        try {
            ServiceContext serviceContext = new ServiceContext();
            serviceContext.setCompanyId(companyId);
            if (active == null) {
                return this._kaleoDefinitionLocalService.getScopeKaleoDefinitionsCount("all", serviceContext);
            }
            return this._kaleoDefinitionLocalService.getScopeKaleoDefinitionsCount("all", active.booleanValue(), serviceContext);
        }
        catch (Exception exception) {
            throw new WorkflowException((Throwable)exception);
        }
    }

    public WorkflowDefinition getWorkflowDefinition(long companyId, String name, int version) throws WorkflowException {
        try {
            return this._kaleoWorkflowModelConverter.toWorkflowDefinition(this._kaleoDefinitionVersionLocalService.getKaleoDefinitionVersion(companyId, name, this.getVersion(version)));
        }
        catch (WorkflowException workflowException) {
            throw workflowException;
        }
        catch (Exception exception) {
            throw new WorkflowException((Throwable)exception);
        }
    }

    public List<WorkflowDefinition> getWorkflowDefinitions(long companyId, String name, int start, int end, OrderByComparator<WorkflowDefinition> orderByComparator) throws WorkflowException {
        try {
            List kaleoDefinitionVersions = this._kaleoDefinitionVersionLocalService.getKaleoDefinitionVersions(companyId, name);
            int size = kaleoDefinitionVersions.size();
            return this._toWorkflowDefinitions(kaleoDefinitionVersions.toArray(new KaleoDefinitionVersion[size]), orderByComparator);
        }
        catch (WorkflowException workflowException) {
            throw workflowException;
        }
        catch (Exception exception) {
            throw new WorkflowException((Throwable)exception);
        }
    }

    public int getWorkflowDefinitionsCount(long companyId, String name) throws WorkflowException {
        try {
            return this._kaleoDefinitionVersionLocalService.getKaleoDefinitionVersionsCount(companyId, name);
        }
        catch (Exception exception) {
            throw new WorkflowException((Throwable)exception);
        }
    }

    public WorkflowDefinition saveWorkflowDefinition(long companyId, long userId, String title, String name, byte[] bytes) throws WorkflowException {
        return this.saveWorkflowDefinition(companyId, userId, title, name, "all", bytes);
    }

    public WorkflowDefinition saveWorkflowDefinition(long companyId, long userId, String title, String name, String scope, byte[] bytes) throws WorkflowException {
        ServiceContext serviceContext = new ServiceContext();
        serviceContext.setCompanyId(companyId);
        serviceContext.setUserId(userId);
        return this._workflowEngine.saveWorkflowDefinition(title, name, scope, bytes, serviceContext);
    }

    public void undeployWorkflowDefinition(long companyId, long userId, String name, int version) throws WorkflowException {
        String key;
        String className = WorkflowDefinition.class.getName();
        if (this._lockLocalService.isLocked(className, key = WorkflowLockUtil.encodeKey(name, version))) {
            throw new WorkflowException(StringBundler.concat((Object[])new Object[]{"Workflow definition name ", name, " and version ", version, " is being undeployed"}));
        }
        try {
            this._lockLocalService.lock(userId, className, key, String.valueOf(userId), false, 3600000L);
            ServiceContext serviceContext = new ServiceContext();
            serviceContext.setCompanyId(companyId);
            serviceContext.setUserId(userId);
            this._workflowEngine.deleteWorkflowDefinition(name, version, serviceContext);
        }
        catch (WorkflowException workflowException) {
            throw workflowException;
        }
        catch (Exception exception) {
            throw new WorkflowException((Throwable)exception);
        }
        finally {
            this._lockLocalService.unlock(className, key);
        }
    }

    public WorkflowDefinition updateActive(long companyId, long userId, String name, int version, boolean active) throws WorkflowException {
        try {
            ServiceContext serviceContext = new ServiceContext();
            serviceContext.setCompanyId(companyId);
            serviceContext.setUserId(userId);
            if (active) {
                this._kaleoDefinitionLocalService.activateKaleoDefinition(name, version, serviceContext);
            } else {
                List workflowDefinitionLinks = this._workflowDefinitionLinkLocalService.getWorkflowDefinitionLinks(companyId, name, version);
                if (!workflowDefinitionLinks.isEmpty()) {
                    throw new RequiredWorkflowDefinitionException(workflowDefinitionLinks);
                }
                this._kaleoDefinitionLocalService.deactivateKaleoDefinition(name, version, serviceContext);
            }
            return this.getWorkflowDefinition(companyId, name, version);
        }
        catch (WorkflowException workflowException) {
            throw workflowException;
        }
        catch (Exception exception) {
            throw new WorkflowException((Throwable)exception);
        }
    }

    public void validateWorkflowDefinition(byte[] bytes) throws WorkflowException {
        this._workflowEngine.validateWorkflowDefinition((InputStream)new UnsyncByteArrayInputStream(bytes));
    }

    protected String getVersion(int version) {
        return version + "." + 0;
    }

    private List<WorkflowDefinition> _toWorkflowDefinitions(KaleoDefinition[] kaleoDefinitions, OrderByComparator<WorkflowDefinition> orderByComparator) {
        ArrayList<WorkflowDefinition> workflowDefinitions = new ArrayList<WorkflowDefinition>(kaleoDefinitions.length);
        for (KaleoDefinition kaleoDefinition : kaleoDefinitions) {
            WorkflowDefinition workflowDefinition = this._kaleoWorkflowModelConverter.toWorkflowDefinition(kaleoDefinition);
            workflowDefinitions.add(workflowDefinition);
        }
        if (orderByComparator != null) {
            Collections.sort(workflowDefinitions, orderByComparator);
        }
        return workflowDefinitions;
    }

    private List<WorkflowDefinition> _toWorkflowDefinitions(KaleoDefinitionVersion[] kaleoDefinitionVersions, OrderByComparator<WorkflowDefinition> orderByComparator) throws PortalException {
        ArrayList<WorkflowDefinition> workflowDefinitions = new ArrayList<WorkflowDefinition>(kaleoDefinitionVersions.length);
        for (KaleoDefinitionVersion kaleoDefinitionVersion : kaleoDefinitionVersions) {
            WorkflowDefinition workflowDefinition = this._kaleoWorkflowModelConverter.toWorkflowDefinition(kaleoDefinitionVersion);
            workflowDefinitions.add(workflowDefinition);
        }
        if (orderByComparator != null) {
            Collections.sort(workflowDefinitions, orderByComparator);
        }
        return workflowDefinitions;
    }
}

