/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.workflow.kaleo.runtime.integration.internal;

import com.liferay.petra.function.transform.TransformUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.change.tracking.CTAware;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.lock.DuplicateLockException;
import com.liferay.portal.kernel.lock.Lock;
import com.liferay.portal.kernel.lock.LockManager;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Organization;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.UserGroupGroupRole;
import com.liferay.portal.kernel.model.UserGroupRole;
import com.liferay.portal.kernel.search.BaseModelSearchResult;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.PermissionThreadLocal;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.OrganizationLocalService;
import com.liferay.portal.kernel.service.RoleLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserGroupGroupRoleLocalService;
import com.liferay.portal.kernel.service.UserGroupRoleLocalService;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.transaction.TransactionCommitCallbackUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.comparator.UserScreenNameComparator;
import com.liferay.portal.kernel.workflow.DefaultWorkflowTransition;
import com.liferay.portal.kernel.workflow.WorkflowException;
import com.liferay.portal.kernel.workflow.WorkflowTask;
import com.liferay.portal.kernel.workflow.WorkflowTaskAssignee;
import com.liferay.portal.kernel.workflow.WorkflowTaskManager;
import com.liferay.portal.kernel.workflow.WorkflowTransition;
import com.liferay.portal.kernel.workflow.search.WorkflowModelSearchResult;
import com.liferay.portal.workflow.kaleo.KaleoWorkflowModelConverter;
import com.liferay.portal.workflow.kaleo.model.KaleoInstance;
import com.liferay.portal.workflow.kaleo.model.KaleoInstanceToken;
import com.liferay.portal.workflow.kaleo.model.KaleoNode;
import com.liferay.portal.workflow.kaleo.model.KaleoTask;
import com.liferay.portal.workflow.kaleo.model.KaleoTaskAssignment;
import com.liferay.portal.workflow.kaleo.model.KaleoTaskAssignmentInstance;
import com.liferay.portal.workflow.kaleo.model.KaleoTaskInstanceToken;
import com.liferay.portal.workflow.kaleo.model.KaleoTransition;
import com.liferay.portal.workflow.kaleo.model.KaleoTransitionModel;
import com.liferay.portal.workflow.kaleo.runtime.ExecutionContext;
import com.liferay.portal.workflow.kaleo.runtime.KaleoSignaler;
import com.liferay.portal.workflow.kaleo.runtime.TaskManager;
import com.liferay.portal.workflow.kaleo.runtime.assignment.AggregateKaleoTaskAssignmentSelector;
import com.liferay.portal.workflow.kaleo.runtime.assignment.KaleoTaskAssignmentSelector;
import com.liferay.portal.workflow.kaleo.runtime.assignment.KaleoTaskAssignmentSelectorRegistry;
import com.liferay.portal.workflow.kaleo.runtime.util.WorkflowContextUtil;
import com.liferay.portal.workflow.kaleo.runtime.util.comparator.KaleoTaskInstanceTokenOrderByComparator;
import com.liferay.portal.workflow.kaleo.service.KaleoTaskAssignmentInstanceLocalService;
import com.liferay.portal.workflow.kaleo.service.KaleoTaskAssignmentLocalService;
import com.liferay.portal.workflow.kaleo.service.KaleoTaskInstanceTokenLocalService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@CTAware
@Component(service={WorkflowTaskManager.class})
public class WorkflowTaskManagerImpl
implements WorkflowTaskManager {
    private static final int _ACTION_TYPE_ASSIGN = 1;
    private static final int _ACTION_TYPE_VIEW_NOTIFICATION = 2;
    @Reference
    private AggregateKaleoTaskAssignmentSelector _aggregateKaleoTaskAssignmentSelector;
    @Reference
    private GroupLocalService _groupLocalService;
    @Reference
    private KaleoSignaler _kaleoSignaler;
    @Reference
    private KaleoTaskAssignmentInstanceLocalService _kaleoTaskAssignmentInstanceLocalService;
    @Reference
    private KaleoTaskAssignmentLocalService _kaleoTaskAssignmentLocalService;
    @Reference
    private KaleoTaskAssignmentSelectorRegistry _kaleoTaskAssignmentSelectorRegistry;
    @Reference
    private KaleoTaskInstanceTokenLocalService _kaleoTaskInstanceTokenLocalService;
    @Reference
    private KaleoWorkflowModelConverter _kaleoWorkflowModelConverter;
    @Reference
    private LockManager _lockManager;
    @Reference
    private OrganizationLocalService _organizationLocalService;
    @Reference
    private RoleLocalService _roleLocalService;
    @Reference
    private TaskManager _taskManager;
    @Reference
    private UserGroupGroupRoleLocalService _userGroupGroupRoleLocalService;
    @Reference
    private UserGroupRoleLocalService _userGroupRoleLocalService;
    @Reference
    private UserLocalService _userLocalService;

    public WorkflowTask assignWorkflowTaskToRole(long companyId, long userId, long workflowTaskId, long roleId, String comment, Date dueDate, Map<String, Serializable> workflowContext) throws WorkflowException {
        ServiceContext serviceContext = new ServiceContext();
        serviceContext.setCompanyId(companyId);
        serviceContext.setUserId(userId);
        return this._taskManager.assignWorkflowTaskToRole(workflowTaskId, roleId, comment, dueDate, workflowContext, serviceContext);
    }

    public WorkflowTask assignWorkflowTaskToUser(long companyId, long userId, long workflowTaskId, long assigneeUserId, String comment, Date dueDate, Map<String, Serializable> workflowContext) throws PortalException {
        PermissionChecker permissionChecker = PermissionThreadLocal.getPermissionChecker();
        if (permissionChecker.getUserId() != userId) {
            throw new PrincipalException.MustHavePermission(userId, WorkflowTask.class.getName(), workflowTaskId, new String[]{"VIEW"});
        }
        ServiceContext serviceContext = new ServiceContext();
        serviceContext.setCompanyId(companyId);
        serviceContext.setUserId(userId);
        return this._taskManager.assignWorkflowTaskToUser(workflowTaskId, assigneeUserId, comment, dueDate, workflowContext, serviceContext);
    }

    public WorkflowTask completeWorkflowTask(long companyId, long userId, long workflowTaskId, String transitionName, String comment, Map<String, Serializable> workflowContext) throws PortalException {
        return this.completeWorkflowTask(companyId, userId, workflowTaskId, transitionName, comment, workflowContext, false);
    }

    public WorkflowTask completeWorkflowTask(long companyId, long userId, long workflowTaskId, String transitionName, String comment, Map<String, Serializable> workflowContext, boolean waitForCompletion) throws PortalException {
        WorkflowTask workflowTask = this.getWorkflowTask(workflowTaskId);
        List workflowTaskAssignees = workflowTask.getWorkflowTaskAssignees();
        WorkflowTaskAssignee workflowTaskAssignee = (WorkflowTaskAssignee)workflowTaskAssignees.get(0);
        if (workflowTaskAssignee.getAssigneeClassPK() != userId) {
            throw new PrincipalException.MustHavePermission(userId, WorkflowTask.class.getName(), workflowTaskId, new String[]{"VIEW"});
        }
        Lock lock = null;
        try {
            lock = this._lockManager.lock(userId, WorkflowTask.class.getName(), workflowTaskId, String.valueOf(userId), false, 1000L);
        }
        catch (PortalException portalException) {
            if (portalException instanceof DuplicateLockException) {
                throw new WorkflowException(StringBundler.concat((Object[])new Object[]{"Workflow task ", workflowTaskId, " is locked by user ", userId}), (Throwable)portalException);
            }
            throw new WorkflowException("Unable to lock workflow task " + workflowTaskId, (Throwable)portalException);
        }
        try {
            ServiceContext serviceContext = new ServiceContext();
            serviceContext.setCompanyId(companyId);
            serviceContext.setUserId(userId);
            workflowTask = this._taskManager.completeWorkflowTask(workflowTaskId, transitionName, comment, workflowContext, serviceContext);
            KaleoTaskInstanceToken kaleoTaskInstanceToken = this._kaleoTaskInstanceTokenLocalService.getKaleoTaskInstanceToken(workflowTask.getWorkflowTaskId());
            KaleoInstanceToken kaleoInstanceToken = kaleoTaskInstanceToken.getKaleoInstanceToken();
            if (workflowContext == null) {
                KaleoInstance kaleoInstance = kaleoInstanceToken.getKaleoInstance();
                workflowContext = WorkflowContextUtil.convert((String)kaleoInstance.getWorkflowContext());
            }
            workflowContext.put((String)"taskComments", (Serializable)((Object)comment));
            workflowContext.put("transitionName", transitionName);
            ExecutionContext executionContext = new ExecutionContext(kaleoInstanceToken, kaleoTaskInstanceToken, workflowContext, serviceContext);
            TransactionCommitCallbackUtil.registerCallback(() -> {
                try {
                    this._kaleoSignaler.signalExit(transitionName, executionContext, waitForCompletion);
                }
                catch (Exception exception) {
                    throw new WorkflowException("Unable to signal next transition", (Throwable)exception);
                }
                return null;
            });
            WorkflowTask workflowTask2 = workflowTask;
            return workflowTask2;
        }
        catch (WorkflowException workflowException) {
            throw workflowException;
        }
        catch (Exception exception) {
            throw new WorkflowException("Unable to complete task", (Throwable)exception);
        }
        finally {
            this._lockManager.unlock(lock.getClassName(), lock.getKey());
        }
    }

    public WorkflowTask fetchWorkflowTask(long workflowTaskId) throws WorkflowException {
        KaleoTaskInstanceToken kaleoTaskInstanceToken = this._kaleoTaskInstanceTokenLocalService.fetchKaleoTaskInstanceToken(workflowTaskId);
        if (kaleoTaskInstanceToken == null) {
            return null;
        }
        try {
            return this._kaleoWorkflowModelConverter.toWorkflowTask(kaleoTaskInstanceToken, WorkflowContextUtil.convert((String)kaleoTaskInstanceToken.getWorkflowContext()));
        }
        catch (Exception exception) {
            throw new WorkflowException((Throwable)exception);
        }
    }

    public List<User> getAssignableUsers(long workflowTaskId) throws WorkflowException {
        return this._getUsers(1, workflowTaskId);
    }

    public List<String> getNextTransitionNames(long userId, long workflowTaskId) throws WorkflowException {
        try {
            KaleoTaskInstanceToken kaleoTaskInstanceToken = this._kaleoTaskInstanceTokenLocalService.getKaleoTaskInstanceToken(workflowTaskId);
            if (kaleoTaskInstanceToken.isCompleted()) {
                return Collections.emptyList();
            }
            KaleoTask kaleoTask = kaleoTaskInstanceToken.getKaleoTask();
            KaleoNode kaleoNode = kaleoTask.getKaleoNode();
            return TransformUtil.transform((Collection)kaleoNode.getKaleoTransitions(), KaleoTransitionModel::getName);
        }
        catch (WorkflowException workflowException) {
            throw workflowException;
        }
        catch (Exception exception) {
            throw new WorkflowException((Throwable)exception);
        }
    }

    public List<User> getNotifiableUsers(long workflowTaskId) throws WorkflowException {
        return this._getUsers(2, workflowTaskId);
    }

    public WorkflowTask getWorkflowTask(long workflowTaskId) throws WorkflowException {
        try {
            KaleoTaskInstanceToken kaleoTaskInstanceToken = this._kaleoTaskInstanceTokenLocalService.getKaleoTaskInstanceToken(workflowTaskId);
            return this._kaleoWorkflowModelConverter.toWorkflowTask(kaleoTaskInstanceToken, WorkflowContextUtil.convert((String)kaleoTaskInstanceToken.getWorkflowContext()));
        }
        catch (Exception exception) {
            throw new WorkflowException((Throwable)exception);
        }
    }

    public int getWorkflowTaskCount(long companyId, Boolean completed) throws WorkflowException {
        try {
            ServiceContext serviceContext = new ServiceContext();
            serviceContext.setCompanyId(companyId);
            return this._kaleoTaskInstanceTokenLocalService.getKaleoTaskInstanceTokensCount(completed, serviceContext);
        }
        catch (Exception exception) {
            throw new WorkflowException((Throwable)exception);
        }
    }

    public int getWorkflowTaskCountByRole(long companyId, long roleId, Boolean completed) throws WorkflowException {
        try {
            ServiceContext serviceContext = new ServiceContext();
            serviceContext.setCompanyId(companyId);
            return this._kaleoTaskInstanceTokenLocalService.getKaleoTaskInstanceTokensCount(Role.class.getName(), roleId, completed, serviceContext);
        }
        catch (Exception exception) {
            throw new WorkflowException((Throwable)exception);
        }
    }

    public int getWorkflowTaskCountBySubmittingUser(long companyId, long userId, Boolean completed) throws WorkflowException {
        try {
            ServiceContext serviceContext = new ServiceContext();
            serviceContext.setCompanyId(companyId);
            return this._kaleoTaskInstanceTokenLocalService.getSubmittingUserKaleoTaskInstanceTokensCount(userId, completed, serviceContext);
        }
        catch (Exception exception) {
            throw new WorkflowException((Throwable)exception);
        }
    }

    public int getWorkflowTaskCountByUser(long companyId, long userId, Boolean completed) throws WorkflowException {
        try {
            ServiceContext serviceContext = new ServiceContext();
            serviceContext.setCompanyId(companyId);
            serviceContext.setUserId(userId);
            return this._kaleoTaskInstanceTokenLocalService.getKaleoTaskInstanceTokensCount(User.class.getName(), serviceContext.getUserId(), completed, serviceContext);
        }
        catch (Exception exception) {
            throw new WorkflowException((Throwable)exception);
        }
    }

    public int getWorkflowTaskCountByUserRoles(long companyId, long userId, Boolean completed) throws WorkflowException {
        try {
            ServiceContext serviceContext = new ServiceContext();
            serviceContext.setCompanyId(companyId);
            serviceContext.setUserId(userId);
            return this._kaleoTaskInstanceTokenLocalService.searchCount(null, completed, Boolean.TRUE, serviceContext);
        }
        catch (Exception exception) {
            throw new WorkflowException((Throwable)exception);
        }
    }

    public int getWorkflowTaskCountByUserRoles(long companyId, long userId, long workflowInstanceId, Boolean completed) throws WorkflowException {
        try {
            ServiceContext serviceContext = new ServiceContext();
            serviceContext.setCompanyId(companyId);
            serviceContext.setUserId(userId);
            return this._kaleoTaskInstanceTokenLocalService.searchCount(workflowInstanceId, completed, Boolean.TRUE, serviceContext);
        }
        catch (Exception exception) {
            throw new WorkflowException((Throwable)exception);
        }
    }

    public int getWorkflowTaskCountByWorkflowInstance(long companyId, Long userId, long workflowInstanceId, Boolean completed) throws WorkflowException {
        try {
            ServiceContext serviceContext = new ServiceContext();
            serviceContext.setCompanyId(companyId);
            if (userId != null) {
                serviceContext.setUserId(userId.longValue());
            }
            return this._kaleoTaskInstanceTokenLocalService.getKaleoTaskInstanceTokensCount(workflowInstanceId, completed, serviceContext);
        }
        catch (Exception exception) {
            throw new WorkflowException((Throwable)exception);
        }
    }

    public List<WorkflowTask> getWorkflowTasks(long companyId, Boolean completed, int start, int end, OrderByComparator<WorkflowTask> orderByComparator) throws WorkflowException {
        try {
            ServiceContext serviceContext = new ServiceContext();
            serviceContext.setCompanyId(companyId);
            return this._toWorkflowTasks(this._kaleoTaskInstanceTokenLocalService.getKaleoTaskInstanceTokens(completed, start, end, KaleoTaskInstanceTokenOrderByComparator.getOrderByComparator(orderByComparator, (KaleoWorkflowModelConverter)this._kaleoWorkflowModelConverter), serviceContext));
        }
        catch (Exception exception) {
            throw new WorkflowException((Throwable)exception);
        }
    }

    public List<WorkflowTask> getWorkflowTasksByRole(long companyId, long roleId, Boolean completed, int start, int end, OrderByComparator<WorkflowTask> orderByComparator) throws WorkflowException {
        try {
            ServiceContext serviceContext = new ServiceContext();
            serviceContext.setCompanyId(companyId);
            return this._toWorkflowTasks(this._kaleoTaskInstanceTokenLocalService.getKaleoTaskInstanceTokens(Role.class.getName(), roleId, completed, start, end, KaleoTaskInstanceTokenOrderByComparator.getOrderByComparator(orderByComparator, (KaleoWorkflowModelConverter)this._kaleoWorkflowModelConverter), serviceContext));
        }
        catch (Exception exception) {
            throw new WorkflowException((Throwable)exception);
        }
    }

    public List<WorkflowTask> getWorkflowTasksBySubmittingUser(long companyId, long userId, Boolean completed, int start, int end, OrderByComparator<WorkflowTask> orderByComparator) throws WorkflowException {
        try {
            ServiceContext serviceContext = new ServiceContext();
            serviceContext.setCompanyId(companyId);
            List kaleoTaskInstanceTokens = this._kaleoTaskInstanceTokenLocalService.getSubmittingUserKaleoTaskInstanceTokens(userId, completed, start, end, KaleoTaskInstanceTokenOrderByComparator.getOrderByComparator(orderByComparator, (KaleoWorkflowModelConverter)this._kaleoWorkflowModelConverter), serviceContext);
            return this._toWorkflowTasks(kaleoTaskInstanceTokens);
        }
        catch (Exception exception) {
            throw new WorkflowException((Throwable)exception);
        }
    }

    public List<WorkflowTask> getWorkflowTasksByUser(long companyId, long userId, Boolean completed, int start, int end, OrderByComparator<WorkflowTask> orderByComparator) throws WorkflowException {
        try {
            ServiceContext serviceContext = new ServiceContext();
            serviceContext.setCompanyId(companyId);
            return this._toWorkflowTasks(this._kaleoTaskInstanceTokenLocalService.getKaleoTaskInstanceTokens(User.class.getName(), userId, completed, start, end, KaleoTaskInstanceTokenOrderByComparator.getOrderByComparator(orderByComparator, (KaleoWorkflowModelConverter)this._kaleoWorkflowModelConverter), serviceContext));
        }
        catch (Exception exception) {
            throw new WorkflowException((Throwable)exception);
        }
    }

    public List<WorkflowTask> getWorkflowTasksByUserRoles(long companyId, long userId, Boolean completed, int start, int end, OrderByComparator<WorkflowTask> orderByComparator) throws WorkflowException {
        try {
            ServiceContext serviceContext = new ServiceContext();
            serviceContext.setCompanyId(companyId);
            serviceContext.setUserId(userId);
            List kaleoTaskInstanceTokens = this._kaleoTaskInstanceTokenLocalService.search(null, completed, Boolean.TRUE, start, end, KaleoTaskInstanceTokenOrderByComparator.getOrderByComparator(orderByComparator, (KaleoWorkflowModelConverter)this._kaleoWorkflowModelConverter), serviceContext);
            return this._toWorkflowTasks(kaleoTaskInstanceTokens);
        }
        catch (Exception exception) {
            throw new WorkflowException((Throwable)exception);
        }
    }

    public List<WorkflowTask> getWorkflowTasksByWorkflowInstance(long companyId, Long userId, long workflowInstanceId, Boolean completed, int start, int end, OrderByComparator<WorkflowTask> orderByComparator) throws WorkflowException {
        try {
            ServiceContext serviceContext = new ServiceContext();
            serviceContext.setCompanyId(companyId);
            if (userId != null) {
                serviceContext.setUserId(userId.longValue());
            }
            return this._toWorkflowTasks(this._kaleoTaskInstanceTokenLocalService.getKaleoTaskInstanceTokens(workflowInstanceId, completed, start, end, KaleoTaskInstanceTokenOrderByComparator.getOrderByComparator(orderByComparator, (KaleoWorkflowModelConverter)this._kaleoWorkflowModelConverter), serviceContext));
        }
        catch (Exception exception) {
            throw new WorkflowException((Throwable)exception);
        }
    }

    public List<WorkflowTransition> getWorkflowTaskWorkflowTransitions(long workflowTaskId) throws WorkflowException {
        try {
            KaleoTaskInstanceToken kaleoTaskInstanceToken = this._kaleoTaskInstanceTokenLocalService.getKaleoTaskInstanceToken(workflowTaskId);
            if (kaleoTaskInstanceToken.isCompleted()) {
                return Collections.emptyList();
            }
            KaleoTask kaleoTask = kaleoTaskInstanceToken.getKaleoTask();
            KaleoNode kaleoNode = kaleoTask.getKaleoNode();
            return TransformUtil.transform((Collection)kaleoNode.getKaleoTransitions(), kaleoTransition -> new DefaultWorkflowTransition((KaleoTransition)kaleoTransition){
                final /* synthetic */ KaleoTransition val$kaleoTransition;
                {
                    this.val$kaleoTransition = kaleoTransition;
                    this.setLabelMap(this.val$kaleoTransition.getLabelMap());
                    this.setName(this.val$kaleoTransition.getName());
                    this.setSourceNodeName(this.val$kaleoTransition.getSourceKaleoNodeName());
                    this.setTargetNodeName(this.val$kaleoTransition.getTargetKaleoNodeName());
                }
            });
        }
        catch (PortalException portalException) {
            throw new WorkflowException((Throwable)portalException);
        }
    }

    public boolean hasAssignableUsers(long workflowTaskId) throws WorkflowException {
        try {
            KaleoTaskInstanceToken kaleoTaskInstanceToken = this._kaleoTaskInstanceTokenLocalService.getKaleoTaskInstanceToken(workflowTaskId);
            if (kaleoTaskInstanceToken.isCompleted()) {
                return false;
            }
            long assignedUserId = this._getAssignedUserId(workflowTaskId);
            ExecutionContext executionContext = this._createExecutionContext(kaleoTaskInstanceToken);
            List configuredKaleoTaskAssignments = this._kaleoTaskAssignmentLocalService.getKaleoTaskAssignments(kaleoTaskInstanceToken.getKaleoTaskId());
            for (KaleoTaskAssignment configuredKaleoTaskAssignment : configuredKaleoTaskAssignments) {
                Collection<KaleoTaskAssignment> calculatedKaleoTaskAssignments = this._getKaleoTaskAssignments(configuredKaleoTaskAssignment, executionContext);
                for (KaleoTaskAssignment calculatedKaleoTaskAssignment : calculatedKaleoTaskAssignments) {
                    if (!this._hasAssignableUsers(calculatedKaleoTaskAssignment, kaleoTaskInstanceToken, assignedUserId)) continue;
                    return true;
                }
            }
            return false;
        }
        catch (WorkflowException workflowException) {
            throw workflowException;
        }
        catch (Exception exception) {
            throw new WorkflowException((Throwable)exception);
        }
    }

    public List<WorkflowTask> search(long companyId, long userId, String assetTitle, String[] taskNames, String[] assetTypes, Long[] assetPrimaryKeys, String assigneeClassName, Long[] assigneeIds, Date dueDateGT, Date dueDateLT, Boolean completed, Boolean searchByUserRoles, Long workflowDefinitionId, Long[] workflowInstanceIds, Boolean andOperator, int start, int end, OrderByComparator<WorkflowTask> orderByComparator) throws WorkflowException {
        try {
            WorkflowModelSearchResult<WorkflowTask> workflowModelSearchResult = this.searchWorkflowTasks(companyId, userId, assetTitle, taskNames, assetTypes, assetPrimaryKeys, assigneeClassName, assigneeIds, dueDateGT, dueDateLT, completed, false, searchByUserRoles, workflowDefinitionId, workflowInstanceIds, andOperator, start, end, orderByComparator);
            return workflowModelSearchResult.getWorkflowModels();
        }
        catch (Exception exception) {
            throw new WorkflowException((Throwable)exception);
        }
    }

    public int searchCount(long companyId, long userId, String assetTitle, String[] taskNames, String[] assetTypes, Long[] assetPrimaryKeys, String assigneeClassName, Long[] assigneeIds, Date dueDateGT, Date dueDateLT, Boolean completed, Boolean searchByUserRoles, Long workflowDefinitionId, Long[] workflowInstanceIds, Boolean andOperator) throws WorkflowException {
        try {
            ServiceContext serviceContext = new ServiceContext();
            serviceContext.setCompanyId(companyId);
            serviceContext.setUserId(userId);
            return this._kaleoTaskInstanceTokenLocalService.searchCount(assetTitle, taskNames, assetTypes, assetPrimaryKeys, assigneeClassName, assigneeIds, dueDateGT, dueDateLT, completed, workflowDefinitionId, workflowInstanceIds, searchByUserRoles, andOperator.booleanValue(), serviceContext);
        }
        catch (Exception exception) {
            throw new WorkflowException((Throwable)exception);
        }
    }

    public WorkflowModelSearchResult<WorkflowTask> searchWorkflowTasks(long companyId, long userId, String assetTitle, String[] taskNames, String[] assetTypes, Long[] assetPrimaryKeys, String assigneeClassName, Long[] assigneeIds, Date dueDateGT, Date dueDateLT, Boolean completed, boolean searchByActiveWorkflowHandlers, Boolean searchByUserRoles, Long workflowDefinitionId, Long[] workflowInstanceIds, Boolean andOperator, int start, int end, OrderByComparator<WorkflowTask> orderByComparator) throws WorkflowException {
        try {
            ServiceContext serviceContext = new ServiceContext();
            serviceContext.setCompanyId(companyId);
            serviceContext.setUserId(userId);
            BaseModelSearchResult baseModelSearchResult = this._kaleoTaskInstanceTokenLocalService.searchKaleoTaskInstanceTokens(assetTitle, taskNames, assetTypes, assetPrimaryKeys, assigneeClassName, assigneeIds, dueDateGT, dueDateLT, completed, workflowDefinitionId, workflowInstanceIds, searchByActiveWorkflowHandlers, searchByUserRoles, andOperator.booleanValue(), start, end, KaleoTaskInstanceTokenOrderByComparator.getOrderByComparator(orderByComparator, (KaleoWorkflowModelConverter)this._kaleoWorkflowModelConverter), serviceContext);
            return new WorkflowModelSearchResult(this._toWorkflowTasks(baseModelSearchResult.getBaseModels()), baseModelSearchResult.getLength());
        }
        catch (Exception exception) {
            throw new WorkflowException((Throwable)exception);
        }
    }

    public WorkflowTask updateDueDate(long companyId, long userId, long workflowTaskId, String comment, Date dueDate) throws WorkflowException {
        ServiceContext serviceContext = new ServiceContext();
        serviceContext.setCompanyId(companyId);
        serviceContext.setUserId(userId);
        return this._taskManager.updateDueDate(workflowTaskId, comment, dueDate, serviceContext);
    }

    private ExecutionContext _createExecutionContext(KaleoTaskInstanceToken kaleoTaskInstanceToken) throws PortalException {
        KaleoInstanceToken kaleoInstanceToken = kaleoTaskInstanceToken.getKaleoInstanceToken();
        Map workflowContext = WorkflowContextUtil.convert((String)kaleoTaskInstanceToken.getWorkflowContext());
        ServiceContext workflowContextServiceContext = (ServiceContext)workflowContext.get("serviceContext");
        return new ExecutionContext(kaleoInstanceToken, workflowContext, workflowContextServiceContext);
    }

    private long _getAssignedUserId(long kaleoTaskInstanceTokenId) {
        ArrayList<Long> assignedUserIds = new ArrayList<Long>();
        for (KaleoTaskAssignmentInstance kaleoTaskAssignmentInstance : this._kaleoTaskAssignmentInstanceLocalService.getKaleoTaskAssignmentInstances(kaleoTaskInstanceTokenId)) {
            if (!Objects.equals(User.class.getName(), kaleoTaskAssignmentInstance.getAssigneeClassName())) continue;
            assignedUserIds.add(kaleoTaskAssignmentInstance.getAssigneeClassPK());
        }
        if (assignedUserIds.size() == 1) {
            return (Long)assignedUserIds.get(0);
        }
        return 0L;
    }

    private Collection<KaleoTaskAssignment> _getKaleoTaskAssignments(KaleoTaskAssignment kaleoTaskAssignment, ExecutionContext executionContext) throws PortalException {
        KaleoTaskAssignmentSelector kaleoTaskAssignmentSelector = this._kaleoTaskAssignmentSelectorRegistry.getKaleoTaskAssignmentSelector(kaleoTaskAssignment.getAssigneeClassName());
        return kaleoTaskAssignmentSelector.getKaleoTaskAssignments(kaleoTaskAssignment, executionContext);
    }

    private List<User> _getUsers(int actionType, long workflowTaskId) throws WorkflowException {
        try {
            KaleoTaskInstanceToken kaleoTaskInstanceToken = this._kaleoTaskInstanceTokenLocalService.getKaleoTaskInstanceToken(workflowTaskId);
            if (kaleoTaskInstanceToken.isCompleted() && actionType == 1) {
                return Collections.emptyList();
            }
            TreeSet<User> allowedUsers = new TreeSet<User>((Comparator<User>)new UserScreenNameComparator(true));
            long assignedUserId = this._getAssignedUserId(workflowTaskId);
            Collection kaleoTaskAssignments = this._aggregateKaleoTaskAssignmentSelector.getKaleoTaskAssignments(this._kaleoTaskAssignmentLocalService.getKaleoTaskAssignments(kaleoTaskInstanceToken.getKaleoTaskId()), this._createExecutionContext(kaleoTaskInstanceToken));
            for (KaleoTaskAssignment kaleoTaskAssignment : kaleoTaskAssignments) {
                this._populateAllowedUsers(actionType, allowedUsers, assignedUserId, kaleoTaskAssignment, kaleoTaskInstanceToken);
            }
            for (KaleoTaskAssignmentInstance kaleoTaskAssignmentInstance : kaleoTaskInstanceToken.getKaleoTaskAssignmentInstances()) {
                KaleoTaskAssignment kaleoTaskAssignment = this._kaleoTaskAssignmentLocalService.createKaleoTaskAssignment(0L);
                kaleoTaskAssignment.setAssigneeClassName(kaleoTaskAssignmentInstance.getAssigneeClassName());
                kaleoTaskAssignment.setAssigneeClassPK(kaleoTaskAssignmentInstance.getAssigneeClassPK());
                this._populateAllowedUsers(actionType, allowedUsers, assignedUserId, kaleoTaskAssignment, kaleoTaskInstanceToken);
            }
            return ListUtil.fromCollection(allowedUsers);
        }
        catch (WorkflowException workflowException) {
            throw workflowException;
        }
        catch (Exception exception) {
            throw new WorkflowException((Throwable)exception);
        }
    }

    private List<User> _getUsers(long groupId, long roleId) throws PortalException {
        ArrayList<User> users = new ArrayList<User>();
        List userGroupGroupRoles = this._userGroupRoleLocalService.getUserGroupRolesByGroupAndRole(groupId, roleId);
        for (UserGroupRole userGroupRole : userGroupGroupRoles) {
            users.add(userGroupRole.getUser());
        }
        return users;
    }

    private boolean _hasAssignableUsers(KaleoTaskAssignment kaleoTaskAssignment, KaleoTaskInstanceToken kaleoTaskInstanceToken, long assignedUserId) throws PortalException {
        String assigneeClassName = kaleoTaskAssignment.getAssigneeClassName();
        long assigneeClassPK = kaleoTaskAssignment.getAssigneeClassPK();
        if (assigneeClassName.equals(User.class.getName())) {
            if (assignedUserId == assigneeClassPK) {
                return false;
            }
            User user = this._userLocalService.fetchUser(assigneeClassPK);
            return user != null && user.isActive();
        }
        Role role = this._roleLocalService.getRole(assigneeClassPK);
        if (role.getType() == 5 || role.getType() == 3 || role.getType() == 2) {
            if (Objects.equals(role.getName(), "Asset Library Member") || Objects.equals(role.getName(), "Site Member")) {
                List users = this._userLocalService.getGroupUsers(kaleoTaskInstanceToken.getGroupId(), 0, null);
                for (User user : users) {
                    if (user.getUserId() == assignedUserId) continue;
                    return true;
                }
            }
            List userGroupRoles = this._userGroupRoleLocalService.getUserGroupRolesByGroupAndRole(kaleoTaskInstanceToken.getGroupId(), assigneeClassPK);
            for (Object userGroupRole : userGroupRoles) {
                User user = userGroupRole.getUser();
                if (!user.isActive() || user.getUserId() == assignedUserId) continue;
                return true;
            }
            List userGroupGroupRoles = this._userGroupGroupRoleLocalService.getUserGroupGroupRolesByGroupAndRole(kaleoTaskInstanceToken.getGroupId(), assigneeClassPK);
            for (UserGroupGroupRole userGroupGroupRole : userGroupGroupRoles) {
                List userGroupUsers = this._userLocalService.getUserGroupUsers(userGroupGroupRole.getUserGroupId());
                for (User user : userGroupUsers) {
                    if (!user.isActive() || user.getUserId() == assignedUserId) continue;
                    return true;
                }
            }
        } else {
            List inheritedRoleUsers = this._userLocalService.getInheritedRoleUsers(assigneeClassPK, -1, -1, null);
            for (User user : inheritedRoleUsers) {
                if (!user.isActive() || user.getUserId() == assignedUserId) continue;
                return true;
            }
        }
        return false;
    }

    private void _populateAllowedUsers(int actionType, Set<User> allowedUsers, long assignedUserId, KaleoTaskAssignment kaleoTaskAssignment, KaleoTaskInstanceToken kaleoTaskInstanceToken) throws PortalException {
        if (Objects.equals(kaleoTaskAssignment.getAssigneeClassName(), User.class.getName())) {
            User user2 = null;
            if (actionType == 1) {
                if (assignedUserId == kaleoTaskAssignment.getAssigneeClassPK()) {
                    return;
                }
                user2 = this._userLocalService.fetchUser(kaleoTaskAssignment.getAssigneeClassPK());
            } else {
                List kaleoTaskAssignmentInstances = this._kaleoTaskAssignmentInstanceLocalService.getKaleoTaskAssignmentInstances(kaleoTaskInstanceToken.getKaleoTaskInstanceTokenId());
                KaleoTaskAssignmentInstance kaleoTaskAssignmentInstance = (KaleoTaskAssignmentInstance)kaleoTaskAssignmentInstances.get(0);
                user2 = this._userLocalService.fetchUser(kaleoTaskAssignmentInstance.getAssigneeClassPK());
            }
            if (user2 != null && user2.isActive()) {
                allowedUsers.add(user2);
            }
            return;
        }
        Role role = this._roleLocalService.getRole(kaleoTaskAssignment.getAssigneeClassPK());
        if (role.getType() == 5 || role.getType() == 3 || role.getType() == 2) {
            if (Objects.equals(role.getName(), "Asset Library Member") || Objects.equals(role.getName(), "Site Member")) {
                List groupUsers = this._userLocalService.getGroupUsers(kaleoTaskInstanceToken.getGroupId(), 0, null);
                if (actionType == 1) {
                    groupUsers = ListUtil.filter((List)groupUsers, user -> user.getUserId() != assignedUserId);
                }
                allowedUsers.addAll(groupUsers);
                return;
            }
            List users = this._getUsers(kaleoTaskInstanceToken.getGroupId(), kaleoTaskAssignment.getAssigneeClassPK());
            Group group = this._groupLocalService.getGroup(kaleoTaskInstanceToken.getGroupId());
            if (group.isOrganization()) {
                Organization organization = this._organizationLocalService.getOrganization(group.getOrganizationId());
                for (Organization ancestorOrganization : organization.getAncestors()) {
                    users.addAll(this._getUsers(ancestorOrganization.getGroupId(), kaleoTaskAssignment.getAssigneeClassPK()));
                }
            }
            users = actionType == 1 ? ListUtil.filter(users, user -> user != null && user.isActive() && user.getUserId() != assignedUserId) : ListUtil.filter(users, user -> user != null && user.isActive());
            allowedUsers.addAll(users);
            ArrayList userGroupGroupRolesUsers = new ArrayList();
            for (UserGroupGroupRole userGroupGroupRole : this._userGroupGroupRoleLocalService.getUserGroupGroupRolesByGroupAndRole(kaleoTaskInstanceToken.getGroupId(), kaleoTaskAssignment.getAssigneeClassPK())) {
                userGroupGroupRolesUsers.addAll(this._userLocalService.getUserGroupUsers(userGroupGroupRole.getUserGroupId()));
            }
            if (actionType == 1) {
                ListUtil.filter(userGroupGroupRolesUsers, user -> user.isActive() && user.getUserId() != assignedUserId);
            } else {
                ListUtil.filter(userGroupGroupRolesUsers, User::isActive);
            }
            allowedUsers.addAll(userGroupGroupRolesUsers);
        } else {
            List inheritedRoleUsers = this._userLocalService.getInheritedRoleUsers(kaleoTaskAssignment.getAssigneeClassPK(), -1, -1, null);
            inheritedRoleUsers = actionType == 1 ? ListUtil.filter((List)inheritedRoleUsers, user -> user.isActive() && user.getUserId() != assignedUserId) : ListUtil.filter((List)inheritedRoleUsers, User::isActive);
            allowedUsers.addAll(inheritedRoleUsers);
        }
    }

    private List<WorkflowTask> _toWorkflowTasks(List<KaleoTaskInstanceToken> kaleoTaskInstanceTokens) throws PortalException {
        ArrayList<WorkflowTask> workflowTasks = new ArrayList<WorkflowTask>(kaleoTaskInstanceTokens.size());
        for (KaleoTaskInstanceToken kaleoTaskInstanceToken : kaleoTaskInstanceTokens) {
            WorkflowTask workflowTask = this._kaleoWorkflowModelConverter.toWorkflowTask(kaleoTaskInstanceToken, WorkflowContextUtil.convert((String)kaleoTaskInstanceToken.getWorkflowContext()));
            workflowTasks.add(workflowTask);
        }
        return workflowTasks;
    }
}

