/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.workflow.kaleo.runtime.integration.internal.security.permission.resource;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.security.permission.resource.PortletResourcePermission;
import com.liferay.portal.kernel.workflow.WorkflowInstance;
import com.liferay.portal.kernel.workflow.permission.WorkflowPermission;
import com.liferay.portal.workflow.kaleo.model.KaleoInstance;
import com.liferay.portal.workflow.kaleo.service.KaleoInstanceLocalService;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"model.class.name=com.liferay.portal.kernel.workflow.WorkflowInstance"}, service={ModelResourcePermission.class})
public class WorkflowInstanceModelResourcePermission
implements ModelResourcePermission<KaleoInstance> {
    @Reference
    private KaleoInstanceLocalService _kaleoInstanceLocalService;
    @Reference(target="(resource.name=com.liferay.portal.workflow)")
    private PortletResourcePermission _portletResourcePermission;
    @Reference
    private WorkflowPermission _workflowPermission;

    public void check(PermissionChecker permissionChecker, KaleoInstance kaleoInstance, String actionId) throws PortalException {
        if (!this.contains(permissionChecker, kaleoInstance, actionId)) {
            throw new PrincipalException.MustHavePermission(permissionChecker, WorkflowInstance.class.getName(), kaleoInstance.getKaleoInstanceId(), new String[]{actionId});
        }
    }

    public void check(PermissionChecker permissionChecker, long primaryKey, String actionId) throws PortalException {
        this.check(permissionChecker, this._kaleoInstanceLocalService.getKaleoInstance(primaryKey), actionId);
    }

    public boolean contains(PermissionChecker permissionChecker, KaleoInstance kaleoInstance, String actionId) throws PortalException {
        return this._workflowPermission.hasPermission(permissionChecker, kaleoInstance.getGroupId(), kaleoInstance.getClassName(), kaleoInstance.getClassPK(), actionId);
    }

    public boolean contains(PermissionChecker permissionChecker, long primaryKey, String actionId) throws PortalException {
        return this.contains(permissionChecker, this._kaleoInstanceLocalService.getKaleoInstance(primaryKey), actionId);
    }

    public String getModelName() {
        return KaleoInstance.class.getName();
    }

    public PortletResourcePermission getPortletResourcePermission() {
        return this._portletResourcePermission;
    }
}

