/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.workflow.kaleo.runtime.integration.internal.security.permission.resource;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.security.permission.resource.PortletResourcePermission;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.workflow.WorkflowTask;
import com.liferay.portal.workflow.kaleo.KaleoWorkflowModelConverter;
import com.liferay.portal.workflow.kaleo.model.KaleoInstance;
import com.liferay.portal.workflow.kaleo.model.KaleoTaskInstanceToken;
import com.liferay.portal.workflow.kaleo.runtime.util.WorkflowContextUtil;
import com.liferay.portal.workflow.kaleo.service.KaleoTaskInstanceTokenLocalService;
import com.liferay.portal.workflow.security.permission.WorkflowTaskPermission;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"model.class.name=com.liferay.portal.kernel.workflow.WorkflowTask"}, service={ModelResourcePermission.class})
public class WorkflowTaskModelResourcePermission
implements ModelResourcePermission<KaleoTaskInstanceToken> {
    @Reference
    private KaleoTaskInstanceTokenLocalService _kaleoTaskInstanceTokenLocalService;
    @Reference
    private KaleoWorkflowModelConverter _kaleoWorkflowModelConverter;
    @Reference(target="(resource.name=com.liferay.portal.workflow)")
    private PortletResourcePermission _portletResourcePermission;
    @Reference
    private WorkflowTaskPermission _workflowTaskPermission;

    public void check(PermissionChecker permissionChecker, KaleoTaskInstanceToken kaleoTaskInstanceToken, String actionId) throws PortalException {
        if (!this.contains(permissionChecker, kaleoTaskInstanceToken, actionId)) {
            throw new PrincipalException.MustHavePermission(permissionChecker, WorkflowTask.class.getName(), kaleoTaskInstanceToken.getKaleoInstanceId(), new String[]{actionId});
        }
    }

    public void check(PermissionChecker permissionChecker, long primaryKey, String actionId) throws PortalException {
        this.check(permissionChecker, this._kaleoTaskInstanceTokenLocalService.getKaleoTaskInstanceToken(primaryKey), actionId);
    }

    public boolean contains(PermissionChecker permissionChecker, KaleoTaskInstanceToken kaleoTaskInstanceToken, String actionId) throws PortalException {
        WorkflowTask workflowTask = this._kaleoWorkflowModelConverter.toWorkflowTask(kaleoTaskInstanceToken, WorkflowContextUtil.convert((String)kaleoTaskInstanceToken.getWorkflowContext()));
        return this._workflowTaskPermission.contains(permissionChecker, workflowTask, MapUtil.getLong((Map)workflowTask.getOptionalAttributes(), (String)"groupId"));
    }

    public boolean contains(PermissionChecker permissionChecker, long primaryKey, String actionId) throws PortalException {
        return this.contains(permissionChecker, this._kaleoTaskInstanceTokenLocalService.getKaleoTaskInstanceToken(primaryKey), actionId);
    }

    public String getModelName() {
        return KaleoInstance.class.getName();
    }

    public PortletResourcePermission getPortletResourcePermission() {
        return this._portletResourcePermission;
    }
}

