/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.workflow.kaleo.runtime.integration.internal;

import com.liferay.petra.function.transform.TransformUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.workflow.DefaultWorkflowDefinition;
import com.liferay.portal.kernel.workflow.DefaultWorkflowInstance;
import com.liferay.portal.kernel.workflow.DefaultWorkflowLog;
import com.liferay.portal.kernel.workflow.DefaultWorkflowNode;
import com.liferay.portal.kernel.workflow.DefaultWorkflowTask;
import com.liferay.portal.kernel.workflow.DefaultWorkflowTransition;
import com.liferay.portal.kernel.workflow.WorkflowDefinition;
import com.liferay.portal.kernel.workflow.WorkflowInstance;
import com.liferay.portal.kernel.workflow.WorkflowLog;
import com.liferay.portal.kernel.workflow.WorkflowNode;
import com.liferay.portal.kernel.workflow.WorkflowTask;
import com.liferay.portal.kernel.workflow.WorkflowTaskAssignee;
import com.liferay.portal.kernel.workflow.WorkflowTransition;
import com.liferay.portal.workflow.kaleo.KaleoWorkflowModelConverter;
import com.liferay.portal.workflow.kaleo.definition.NodeType;
import com.liferay.portal.workflow.kaleo.definition.export.DefinitionExporter;
import com.liferay.portal.workflow.kaleo.definition.util.KaleoLogUtil;
import com.liferay.portal.workflow.kaleo.model.KaleoDefinition;
import com.liferay.portal.workflow.kaleo.model.KaleoDefinitionVersion;
import com.liferay.portal.workflow.kaleo.model.KaleoInstance;
import com.liferay.portal.workflow.kaleo.model.KaleoInstanceToken;
import com.liferay.portal.workflow.kaleo.model.KaleoLog;
import com.liferay.portal.workflow.kaleo.model.KaleoNode;
import com.liferay.portal.workflow.kaleo.model.KaleoTask;
import com.liferay.portal.workflow.kaleo.model.KaleoTaskInstanceToken;
import com.liferay.portal.workflow.kaleo.model.KaleoTransition;
import com.liferay.portal.workflow.kaleo.runtime.integration.internal.util.LazyWorkflowTaskAssigneeList;
import com.liferay.portal.workflow.kaleo.runtime.integration.internal.util.WorkflowTaskAssigneesSupplier;
import com.liferay.portal.workflow.kaleo.runtime.util.WorkflowContextUtil;
import com.liferay.portal.workflow.kaleo.service.KaleoDefinitionLocalService;
import com.liferay.portal.workflow.kaleo.service.KaleoDefinitionVersionLocalService;
import com.liferay.portal.workflow.kaleo.service.KaleoInstanceTokenLocalService;
import com.liferay.portal.workflow.kaleo.service.KaleoNodeLocalService;
import com.liferay.portal.workflow.kaleo.service.KaleoTaskAssignmentInstanceLocalService;
import com.liferay.portal.workflow.kaleo.service.KaleoTransitionLocalService;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={KaleoWorkflowModelConverter.class})
public class KaleoWorkflowModelConverterImpl
implements KaleoWorkflowModelConverter {
    private static final Log _log = LogFactoryUtil.getLog(KaleoWorkflowModelConverterImpl.class);
    @Reference
    private DefinitionExporter _definitionExporter;
    @Reference
    private KaleoDefinitionLocalService _kaleoDefinitionLocalService;
    @Reference
    private KaleoDefinitionVersionLocalService _kaleoDefinitionVersionLocalService;
    @Reference
    private KaleoInstanceTokenLocalService _kaleoInstanceTokenLocalService;
    @Reference
    private KaleoNodeLocalService _kaleoNodeLocalService;
    @Reference
    private KaleoTaskAssignmentInstanceLocalService _kaleoTaskAssignmentInstanceLocalService;
    @Reference
    private KaleoTransitionLocalService _kaleoTransitionLocalService;

    public List<WorkflowTaskAssignee> getWorkflowTaskAssignees(KaleoTaskInstanceToken kaleoTaskInstanceToken) {
        WorkflowTaskAssigneesSupplier workflowTaskAssigneesSupplier = new WorkflowTaskAssigneesSupplier(kaleoTaskInstanceToken);
        return workflowTaskAssigneesSupplier.get();
    }

    public WorkflowDefinition toWorkflowDefinition(KaleoDefinition kaleoDefinition) {
        DefaultWorkflowDefinition defaultWorkflowDefinition;
        block9: {
            block8: {
                String content;
                block7: {
                    defaultWorkflowDefinition = new DefaultWorkflowDefinition();
                    defaultWorkflowDefinition.setActive(kaleoDefinition.isActive());
                    defaultWorkflowDefinition.setCompanyId(kaleoDefinition.getCompanyId());
                    content = kaleoDefinition.getContent();
                    if (Validator.isNull((String)content)) {
                        try {
                            content = this._definitionExporter.export(kaleoDefinition.getKaleoDefinitionId());
                            kaleoDefinition.setContent(content);
                            kaleoDefinition = this._kaleoDefinitionLocalService.updateKaleoDefinition(kaleoDefinition);
                        }
                        catch (Exception exception) {
                            if (!_log.isWarnEnabled()) break block7;
                            _log.warn((Object)"Unable to export definition to string", (Throwable)exception);
                        }
                    }
                }
                defaultWorkflowDefinition.setContent(content);
                try {
                    KaleoDefinitionVersion firstKaleoDefinitionVersion = this._kaleoDefinitionVersionLocalService.getFirstKaleoDefinitionVersion(kaleoDefinition.getCompanyId(), kaleoDefinition.getName());
                    defaultWorkflowDefinition.setCreateDate(firstKaleoDefinitionVersion.getCreateDate());
                }
                catch (PortalException portalException) {
                    if (!_log.isWarnEnabled()) break block8;
                    _log.warn((Throwable)portalException);
                }
            }
            defaultWorkflowDefinition.setDescription(kaleoDefinition.getDescription());
            defaultWorkflowDefinition.setModifiedDate(kaleoDefinition.getModifiedDate());
            defaultWorkflowDefinition.setName(kaleoDefinition.getName());
            defaultWorkflowDefinition.setScope(kaleoDefinition.getScope());
            defaultWorkflowDefinition.setTitle(kaleoDefinition.getTitle());
            defaultWorkflowDefinition.setUserId(kaleoDefinition.getUserId());
            defaultWorkflowDefinition.setVersion(kaleoDefinition.getVersion());
            defaultWorkflowDefinition.setWorkflowDefinitionId(kaleoDefinition.getKaleoDefinitionId());
            try {
                KaleoDefinitionVersion kaleoDefinitionVersion = this._kaleoDefinitionVersionLocalService.getKaleoDefinitionVersion(kaleoDefinition.getCompanyId(), kaleoDefinition.getName(), kaleoDefinition.getVersion() + "." + 0);
                defaultWorkflowDefinition.setWorkflowNodes(this._getWorkflowNodes(kaleoDefinitionVersion.getKaleoDefinitionVersionId()));
                defaultWorkflowDefinition.setWorkflowTransitions(this._getWorkflowTransitions(kaleoDefinitionVersion.getKaleoDefinitionVersionId()));
            }
            catch (PortalException portalException) {
                if (!_log.isWarnEnabled()) break block9;
                _log.warn((Throwable)portalException);
            }
        }
        return defaultWorkflowDefinition;
    }

    public WorkflowDefinition toWorkflowDefinition(KaleoDefinitionVersion kaleoDefinitionVersion) {
        String content;
        DefaultWorkflowDefinition defaultWorkflowDefinition;
        block6: {
            defaultWorkflowDefinition = new DefaultWorkflowDefinition();
            try {
                KaleoDefinition kaleoDefinition = kaleoDefinitionVersion.getKaleoDefinition();
                defaultWorkflowDefinition.setActive(kaleoDefinition.isActive());
                defaultWorkflowDefinition.setScope(kaleoDefinition.getScope());
                defaultWorkflowDefinition.setWorkflowDefinitionId(kaleoDefinition.getKaleoDefinitionId());
            }
            catch (PortalException portalException) {
                if (_log.isWarnEnabled()) {
                    _log.warn((Throwable)portalException);
                }
                defaultWorkflowDefinition.setActive(false);
                defaultWorkflowDefinition.setScope("all");
            }
            content = kaleoDefinitionVersion.getContent();
            if (Validator.isNull((String)content)) {
                try {
                    content = this._definitionExporter.export(kaleoDefinitionVersion.getCompanyId(), kaleoDefinitionVersion.getName(), this.getVersion(kaleoDefinitionVersion.getVersion()));
                    kaleoDefinitionVersion.setContent(content);
                    kaleoDefinitionVersion = this._kaleoDefinitionVersionLocalService.updateKaleoDefinitionVersion(kaleoDefinitionVersion);
                }
                catch (PortalException portalException) {
                    if (!_log.isWarnEnabled()) break block6;
                    _log.warn((Object)"Unable to export definition to string", (Throwable)portalException);
                }
            }
        }
        defaultWorkflowDefinition.setContent(content);
        defaultWorkflowDefinition.setCreateDate(kaleoDefinitionVersion.getCreateDate());
        defaultWorkflowDefinition.setDescription(kaleoDefinitionVersion.getDescription());
        defaultWorkflowDefinition.setModifiedDate(kaleoDefinitionVersion.getModifiedDate());
        defaultWorkflowDefinition.setName(kaleoDefinitionVersion.getName());
        defaultWorkflowDefinition.setTitle(kaleoDefinitionVersion.getTitle());
        defaultWorkflowDefinition.setUserId(kaleoDefinitionVersion.getUserId());
        defaultWorkflowDefinition.setVersion(this.getVersion(kaleoDefinitionVersion.getVersion()));
        defaultWorkflowDefinition.setWorkflowNodes(this._getWorkflowNodes(kaleoDefinitionVersion.getKaleoDefinitionVersionId()));
        defaultWorkflowDefinition.setWorkflowTransitions(this._getWorkflowTransitions(kaleoDefinitionVersion.getKaleoDefinitionVersionId()));
        return defaultWorkflowDefinition;
    }

    public WorkflowInstance toWorkflowInstance(KaleoInstance kaleoInstance) {
        return this.toWorkflowInstance(kaleoInstance, null);
    }

    public WorkflowInstance toWorkflowInstance(KaleoInstance kaleoInstance, Map<String, Serializable> workflowContext) {
        DefaultWorkflowInstance defaultWorkflowInstance = new DefaultWorkflowInstance();
        defaultWorkflowInstance.setActive(kaleoInstance.isActive());
        defaultWorkflowInstance.setCurrentWorkflowNodes(TransformUtil.transform((Collection)this._kaleoInstanceTokenLocalService.getKaleoInstanceTokens(kaleoInstance.getKaleoInstanceId()), kaleoInstanceToken -> {
            KaleoNode kaleoNode = this._kaleoNodeLocalService.fetchKaleoNode(kaleoInstanceToken.getCurrentKaleoNodeId());
            if (kaleoNode == null || Objects.equals(kaleoNode.getType(), NodeType.FORK.name())) {
                return null;
            }
            return this._toWorkflowNode(kaleoNode);
        }));
        defaultWorkflowInstance.setEndDate(kaleoInstance.getCompletionDate());
        defaultWorkflowInstance.setStartDate(kaleoInstance.getCreateDate());
        if (workflowContext != null) {
            defaultWorkflowInstance.setWorkflowContext(workflowContext);
        } else {
            defaultWorkflowInstance.setWorkflowContext(WorkflowContextUtil.convert((String)kaleoInstance.getWorkflowContext()));
        }
        defaultWorkflowInstance.setWorkflowDefinitionName(kaleoInstance.getKaleoDefinitionName());
        defaultWorkflowInstance.setWorkflowDefinitionVersion(kaleoInstance.getKaleoDefinitionVersion());
        defaultWorkflowInstance.setWorkflowInstanceId(kaleoInstance.getKaleoInstanceId());
        return defaultWorkflowInstance;
    }

    public WorkflowLog toWorkflowLog(KaleoLog kaleoLog) {
        long currentAssigneeClassPK;
        DefaultWorkflowLog defaultWorkflowLog = new DefaultWorkflowLog();
        defaultWorkflowLog.setAuditUserId(kaleoLog.getUserId());
        defaultWorkflowLog.setComment(kaleoLog.getComment());
        defaultWorkflowLog.setCreateDate(kaleoLog.getCreateDate());
        defaultWorkflowLog.setPreviousWorkflowNode(this._getWorkflowNode(kaleoLog.getPreviousKaleoNodeId()));
        long previousAssigneeClassPK = kaleoLog.getPreviousAssigneeClassPK();
        if (previousAssigneeClassPK > 0L) {
            String previousAssigneeClassName = kaleoLog.getPreviousAssigneeClassName();
            if (previousAssigneeClassName.equals(Role.class.getName())) {
                defaultWorkflowLog.setPreviousRoleId(previousAssigneeClassPK);
            } else {
                defaultWorkflowLog.setPreviousUserId(previousAssigneeClassPK);
            }
        }
        if ((currentAssigneeClassPK = kaleoLog.getCurrentAssigneeClassPK()) > 0L) {
            String currentAssigneeClassName = kaleoLog.getCurrentAssigneeClassName();
            if (currentAssigneeClassName.equals(Role.class.getName())) {
                defaultWorkflowLog.setRoleId(currentAssigneeClassPK);
            } else {
                defaultWorkflowLog.setUserId(currentAssigneeClassPK);
            }
        }
        defaultWorkflowLog.setCurrentWorkflowNode(this._getWorkflowNode(kaleoLog.getKaleoClassPK()));
        defaultWorkflowLog.setType(KaleoLogUtil.convert((String)kaleoLog.getType()));
        defaultWorkflowLog.setWorkflowLogId(kaleoLog.getKaleoLogId());
        defaultWorkflowLog.setWorkflowTaskId(kaleoLog.getKaleoTaskInstanceTokenId());
        return defaultWorkflowLog;
    }

    public WorkflowTask toWorkflowTask(KaleoTaskInstanceToken kaleoTaskInstanceToken, Map<String, Serializable> workflowContext) throws PortalException {
        DefaultWorkflowTask defaultWorkflowTask = new DefaultWorkflowTask();
        defaultWorkflowTask.setCreateDate(kaleoTaskInstanceToken.getCreateDate());
        defaultWorkflowTask.setCompletionDate(kaleoTaskInstanceToken.getCompletionDate());
        KaleoTask kaleoTask = kaleoTaskInstanceToken.getKaleoTask();
        defaultWorkflowTask.setDescription(kaleoTask.getDescription());
        defaultWorkflowTask.setDueDate(kaleoTaskInstanceToken.getDueDate());
        KaleoNode kaleoNode = kaleoTask.getKaleoNode();
        defaultWorkflowTask.setLabelMap(kaleoNode.getLabelMap());
        defaultWorkflowTask.setName(kaleoTask.getName());
        if (workflowContext != null) {
            defaultWorkflowTask.setOptionalAttributes(workflowContext);
        } else {
            defaultWorkflowTask.setOptionalAttributes(WorkflowContextUtil.convert((String)kaleoTaskInstanceToken.getWorkflowContext()));
        }
        defaultWorkflowTask.setUserName(kaleoTaskInstanceToken.getUserName());
        KaleoDefinitionVersion kaleoDefinitionVersion = this._kaleoDefinitionVersionLocalService.getKaleoDefinitionVersion(kaleoTaskInstanceToken.getKaleoDefinitionVersionId());
        KaleoDefinition kaleoDefinition = kaleoDefinitionVersion.getKaleoDefinition();
        defaultWorkflowTask.setWorkflowDefinitionId(kaleoDefinition.getKaleoDefinitionId());
        KaleoInstanceToken kaleoInstanceToken = kaleoTaskInstanceToken.getKaleoInstanceToken();
        KaleoInstance kaleoInstance = kaleoInstanceToken.getKaleoInstance();
        defaultWorkflowTask.setWorkflowDefinitionName(kaleoInstance.getKaleoDefinitionName());
        defaultWorkflowTask.setWorkflowDefinitionVersion(kaleoInstance.getKaleoDefinitionVersion());
        defaultWorkflowTask.setWorkflowInstanceId(kaleoInstance.getKaleoInstanceId());
        LazyWorkflowTaskAssigneeList workflowTaskAssignees = new LazyWorkflowTaskAssigneeList(kaleoTaskInstanceToken, this._kaleoTaskAssignmentInstanceLocalService);
        defaultWorkflowTask.setWorkflowTaskAssignees((Collection)workflowTaskAssignees);
        defaultWorkflowTask.setWorkflowTaskId(kaleoTaskInstanceToken.getKaleoTaskInstanceTokenId());
        return defaultWorkflowTask;
    }

    protected int getVersion(String version) {
        int[] versionParts = StringUtil.split((String)version, (String)".", (int)0);
        return versionParts[0];
    }

    private WorkflowNode _getWorkflowNode(long kaleoNodeId) {
        if (kaleoNodeId == 0L) {
            return null;
        }
        try {
            return this._toWorkflowNode(this._kaleoNodeLocalService.getKaleoNode(kaleoNodeId));
        }
        catch (PortalException portalException) {
            if (_log.isDebugEnabled()) {
                _log.debug((Throwable)portalException);
            }
            return null;
        }
    }

    private List<WorkflowNode> _getWorkflowNodes(long kaleoDefinitionVersionId) {
        return TransformUtil.transform((Collection)this._kaleoNodeLocalService.getKaleoDefinitionVersionKaleoNodes(kaleoDefinitionVersionId), this::_toWorkflowNode);
    }

    private List<WorkflowTransition> _getWorkflowTransitions(long kaleoDefinitionVersionId) {
        return TransformUtil.transform((Collection)this._kaleoTransitionLocalService.getKaleoDefinitionVersionKaleoTransitions(kaleoDefinitionVersionId), kaleoTransition -> new DefaultWorkflowTransition((KaleoTransition)kaleoTransition){
            final /* synthetic */ KaleoTransition val$kaleoTransition;
            {
                this.val$kaleoTransition = kaleoTransition;
                this.setLabelMap(this.val$kaleoTransition.getLabelMap());
                this.setName(this.val$kaleoTransition.getName());
                this.setSourceNodeName(this.val$kaleoTransition.getSourceKaleoNodeName());
                this.setTargetNodeName(this.val$kaleoTransition.getTargetKaleoNodeName());
            }
        });
    }

    private WorkflowNode _toWorkflowNode(KaleoNode kaleoNode) {
        DefaultWorkflowNode defaultWorkflowNode = new DefaultWorkflowNode();
        defaultWorkflowNode.setLabelMap(kaleoNode.getLabelMap());
        defaultWorkflowNode.setName(kaleoNode.getName());
        WorkflowNode.Type workflowNodeType = WorkflowNode.Type.valueOf((String)kaleoNode.getType());
        if (Objects.equals(workflowNodeType, WorkflowNode.Type.STATE)) {
            if (kaleoNode.isInitial()) {
                workflowNodeType = WorkflowNode.Type.INITIAL_STATE;
            } else if (kaleoNode.isTerminal()) {
                workflowNodeType = WorkflowNode.Type.TERMINAL_STATE;
            }
        }
        defaultWorkflowNode.setType(workflowNodeType);
        return defaultWorkflowNode;
    }
}

