/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.workflow.kaleo.runtime.integration.internal;

import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.workflow.WorkflowException;
import com.liferay.portal.kernel.workflow.WorkflowLog;
import com.liferay.portal.workflow.kaleo.KaleoWorkflowModelConverter;
import com.liferay.portal.workflow.kaleo.model.KaleoLog;
import com.liferay.portal.workflow.kaleo.runtime.util.comparator.KaleoLogOrderByComparator;
import com.liferay.portal.workflow.kaleo.service.KaleoLogLocalService;
import com.liferay.portal.workflow.manager.WorkflowLogManager;
import java.util.ArrayList;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={WorkflowLogManager.class})
public class WorkflowLogManagerImpl
implements WorkflowLogManager {
    @Reference
    private KaleoLogLocalService _kaleoLogLocalService;
    @Reference
    private KaleoWorkflowModelConverter _kaleoWorkflowModelConverter;

    public int getWorkflowLogCountByWorkflowInstance(long companyId, long workflowInstanceId, List<Integer> logTypes) throws WorkflowException {
        try {
            return this._kaleoLogLocalService.getKaleoInstanceKaleoLogsCount(companyId, workflowInstanceId, logTypes);
        }
        catch (Exception exception) {
            throw new WorkflowException((Throwable)exception);
        }
    }

    public int getWorkflowLogCountByWorkflowTask(long companyId, long workflowTaskId, List<Integer> logTypes) throws WorkflowException {
        try {
            return this._kaleoLogLocalService.getKaleoTaskInstanceTokenKaleoLogsCount(companyId, workflowTaskId, logTypes);
        }
        catch (Exception exception) {
            throw new WorkflowException((Throwable)exception);
        }
    }

    public List<WorkflowLog> getWorkflowLogsByWorkflowInstance(long companyId, long workflowInstanceId, List<Integer> logTypes, int start, int end, OrderByComparator<WorkflowLog> orderByComparator) throws WorkflowException {
        try {
            List kaleoLogs = this._kaleoLogLocalService.getKaleoInstanceKaleoLogs(companyId, workflowInstanceId, logTypes, start, end, KaleoLogOrderByComparator.getOrderByComparator(orderByComparator, (KaleoWorkflowModelConverter)this._kaleoWorkflowModelConverter));
            return this._toWorkflowLogs(kaleoLogs);
        }
        catch (Exception exception) {
            throw new WorkflowException((Throwable)exception);
        }
    }

    public List<WorkflowLog> getWorkflowLogsByWorkflowTask(long companyId, long workflowTaskId, List<Integer> logTypes, int start, int end, OrderByComparator<WorkflowLog> orderByComparator) throws WorkflowException {
        try {
            List kaleoLogs = this._kaleoLogLocalService.getKaleoTaskInstanceTokenKaleoLogs(companyId, workflowTaskId, logTypes, start, end, KaleoLogOrderByComparator.getOrderByComparator(orderByComparator, (KaleoWorkflowModelConverter)this._kaleoWorkflowModelConverter));
            return this._toWorkflowLogs(kaleoLogs);
        }
        catch (Exception exception) {
            throw new WorkflowException((Throwable)exception);
        }
    }

    private List<WorkflowLog> _toWorkflowLogs(List<KaleoLog> kaleoLogs) {
        ArrayList<WorkflowLog> workflowLogs = new ArrayList<WorkflowLog>(kaleoLogs.size());
        for (KaleoLog kaleoLog : kaleoLogs) {
            workflowLogs.add(this._kaleoWorkflowModelConverter.toWorkflowLog(kaleoLog));
        }
        return workflowLogs;
    }
}

