/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.workflow.kaleo.internal.search.spi.model.index.contributor;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.search.spi.model.index.contributor.ModelDocumentContributor;
import com.liferay.portal.workflow.kaleo.model.KaleoInstance;
import com.liferay.portal.workflow.kaleo.model.KaleoInstanceToken;
import com.liferay.portal.workflow.kaleo.runtime.util.WorkflowContextUtil;
import java.util.Map;
import org.osgi.service.component.annotations.Component;

@Component(immediate=true, property={"indexer.class.name=com.liferay.portal.workflow.kaleo.model.KaleoInstance"}, service={ModelDocumentContributor.class})
public class KaleoInstanceModelDocumentContributor
implements ModelDocumentContributor<KaleoInstance> {
    private static final Log _log = LogFactoryUtil.getLog(KaleoInstanceModelDocumentContributor.class);

    public void contribute(Document document, KaleoInstance kaleoInstance) {
        block2: {
            document.addDateSortable("createDate", kaleoInstance.getCreateDate());
            document.addDateSortable("modified", kaleoInstance.getModifiedDate());
            document.addKeyword("className", kaleoInstance.getClassName());
            document.addKeyword("classPK", kaleoInstance.getClassPK());
            document.addKeywordSortable("completed", Boolean.valueOf(kaleoInstance.isCompleted()));
            document.addDateSortable("completionDate", kaleoInstance.getCompletionDate());
            try {
                Map workflowContext = WorkflowContextUtil.convert((String)kaleoInstance.getWorkflowContext());
                ServiceContext serviceContext = (ServiceContext)workflowContext.get("serviceContext");
                KaleoInstanceToken rootKaleoInstanceToken = kaleoInstance.getRootKaleoInstanceToken(serviceContext);
                document.addKeywordSortable("currentKaleoNodeName", rootKaleoInstanceToken.getCurrentKaleoNodeName());
            }
            catch (PortalException portalException) {
                if (!_log.isWarnEnabled()) break block2;
                _log.warn((Object)portalException, (Throwable)portalException);
            }
        }
        document.addKeyword("kaleoDefinitionName", kaleoInstance.getKaleoDefinitionName());
        document.addKeyword("kaleoDefinitionVersionId", kaleoInstance.getKaleoDefinitionVersionId());
        document.addKeyword("kaleoDefinitionVersion", kaleoInstance.getKaleoDefinitionVersion());
        document.addNumberSortable("kaleoInstanceId", Long.valueOf(kaleoInstance.getKaleoInstanceId()));
        document.addKeyword("rootKaleoInstanceTokenId", kaleoInstance.getRootKaleoInstanceTokenId());
    }
}

