/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.workflow.kaleo.internal.search.spi.model.index.contributor;

import com.liferay.asset.kernel.AssetRendererFactoryRegistryUtil;
import com.liferay.asset.kernel.model.AssetEntry;
import com.liferay.asset.kernel.model.AssetRenderer;
import com.liferay.asset.kernel.model.AssetRendererFactory;
import com.liferay.asset.kernel.service.AssetEntryLocalService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.service.ClassNameLocalService;
import com.liferay.portal.kernel.util.LocalizationUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.workflow.WorkflowHandler;
import com.liferay.portal.kernel.workflow.WorkflowHandlerRegistryUtil;
import com.liferay.portal.search.spi.model.index.contributor.ModelDocumentContributor;
import com.liferay.portal.workflow.kaleo.model.KaleoInstance;
import com.liferay.portal.workflow.kaleo.model.KaleoInstanceToken;
import com.liferay.portal.workflow.kaleo.service.KaleoInstanceLocalService;
import java.util.Locale;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"indexer.class.name=com.liferay.portal.workflow.kaleo.model.KaleoInstanceToken"}, service={ModelDocumentContributor.class})
public class KaleoInstanceTokenModelDocumentContributor
implements ModelDocumentContributor<KaleoInstanceToken> {
    @Reference
    protected AssetEntryLocalService assetEntryLocalService;
    @Reference
    protected ClassNameLocalService classNameLocalService;
    @Reference
    protected KaleoInstanceLocalService kaleoInstanceLocalService;
    @Reference
    protected Portal portal;
    private static final Log _log = LogFactoryUtil.getLog(KaleoInstanceTokenModelDocumentContributor.class);

    public void contribute(Document document, KaleoInstanceToken kaleoInstanceToken) {
        block5: {
            document.addKeyword("className", kaleoInstanceToken.getClassName());
            document.addKeyword("classPK", kaleoInstanceToken.getClassPK());
            document.addKeywordSortable("completed", Boolean.valueOf(kaleoInstanceToken.isCompleted()));
            document.addDateSortable("completionDate", kaleoInstanceToken.getCompletionDate());
            document.addDateSortable("createDate", kaleoInstanceToken.getCreateDate());
            document.addKeywordSortable("currentKaleoNodeName", kaleoInstanceToken.getCurrentKaleoNodeName());
            document.addNumberSortable("kaleoInstanceId", Long.valueOf(kaleoInstanceToken.getKaleoInstanceId()));
            document.addKeyword("kaleoInstanceTokenId", kaleoInstanceToken.getKaleoInstanceTokenId());
            document.addDateSortable("modified", kaleoInstanceToken.getModifiedDate());
            document.addKeyword("parentKaleoInstanceTokenId", kaleoInstanceToken.getParentKaleoInstanceTokenId());
            try {
                KaleoInstance kaleoInstance = this.kaleoInstanceLocalService.getKaleoInstance(kaleoInstanceToken.getKaleoInstanceId());
                document.addKeyword("kaleoDefinitionName", kaleoInstance.getKaleoDefinitionName());
            }
            catch (PortalException portalException) {
                if (!_log.isWarnEnabled()) break block5;
                _log.warn((Object)portalException, (Throwable)portalException);
            }
        }
        AssetEntry assetEntry = this.getAssetEntry(kaleoInstanceToken);
        if (assetEntry != null) {
            document.addLocalizedText("assetDescription", LocalizationUtil.populateLocalizationMap((Map)assetEntry.getDescriptionMap(), (String)assetEntry.getDefaultLanguageId(), (long)assetEntry.getGroupId()));
            document.addLocalizedText("assetTitle", LocalizationUtil.populateLocalizationMap((Map)assetEntry.getTitleMap(), (String)assetEntry.getDefaultLanguageId(), (long)assetEntry.getGroupId()));
        } else {
            WorkflowHandler workflowHandler = WorkflowHandlerRegistryUtil.getWorkflowHandler((String)kaleoInstanceToken.getClassName());
            for (Locale availableLocale : LanguageUtil.getAvailableLocales((long)kaleoInstanceToken.getGroupId())) {
                document.addText(LocalizationUtil.getLocalizedName((String)"assetTitle", (String)availableLocale.getLanguage()), workflowHandler.getTitle(kaleoInstanceToken.getClassPK(), availableLocale));
            }
        }
    }

    protected AssetEntry getAssetEntry(KaleoInstanceToken kaleoInstanceToken) {
        block3: {
            try {
                AssetRenderer<?> assetRenderer = this.getAssetRenderer(kaleoInstanceToken.getClassName(), kaleoInstanceToken.getClassPK());
                if (assetRenderer != null) {
                    return this.assetEntryLocalService.getEntry(assetRenderer.getClassName(), assetRenderer.getClassPK());
                }
            }
            catch (PortalException portalException) {
                if (!_log.isDebugEnabled()) break block3;
                _log.debug((Object)portalException, (Throwable)portalException);
            }
        }
        return null;
    }

    protected AssetRenderer<?> getAssetRenderer(String className, long classPK) throws PortalException {
        AssetRendererFactory<?> assetRendererFactory = this.getAssetRendererFactory(className);
        if (assetRendererFactory != null) {
            return assetRendererFactory.getAssetRenderer(classPK);
        }
        return null;
    }

    protected AssetRendererFactory<?> getAssetRendererFactory(String className) {
        return AssetRendererFactoryRegistryUtil.getAssetRendererFactoryByClassName((String)className);
    }

    protected String[] getLanguageIds(String defaultLanguageId, String content) {
        String[] languageIds = LocalizationUtil.getAvailableLanguageIds((String)content);
        if (languageIds.length == 0) {
            languageIds = new String[]{defaultLanguageId};
        }
        return languageIds;
    }
}

