/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.workflow.kaleo.internal.search.spi.model.index.contributor;

import com.liferay.asset.kernel.AssetRendererFactoryRegistryUtil;
import com.liferay.asset.kernel.model.AssetEntry;
import com.liferay.asset.kernel.model.AssetRenderer;
import com.liferay.asset.kernel.model.AssetRendererFactory;
import com.liferay.asset.kernel.service.AssetEntryLocalService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.service.ClassNameLocalService;
import com.liferay.portal.kernel.util.LocalizationUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.workflow.WorkflowHandler;
import com.liferay.portal.kernel.workflow.WorkflowHandlerRegistryUtil;
import com.liferay.portal.search.spi.model.index.contributor.ModelDocumentContributor;
import com.liferay.portal.workflow.kaleo.model.KaleoDefinition;
import com.liferay.portal.workflow.kaleo.model.KaleoDefinitionVersion;
import com.liferay.portal.workflow.kaleo.model.KaleoTaskAssignmentInstance;
import com.liferay.portal.workflow.kaleo.model.KaleoTaskInstanceToken;
import com.liferay.portal.workflow.kaleo.service.KaleoDefinitionVersionLocalService;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"indexer.class.name=com.liferay.portal.workflow.kaleo.model.KaleoTaskInstanceToken"}, service={ModelDocumentContributor.class})
public class KaleoTaskInstanceTokenModelDocumentContributor
implements ModelDocumentContributor<KaleoTaskInstanceToken> {
    @Reference
    protected AssetEntryLocalService assetEntryLocalService;
    @Reference
    protected ClassNameLocalService classNameLocalService;
    @Reference
    protected KaleoDefinitionVersionLocalService kaleoDefinitionVersionLocalService;
    @Reference
    protected Portal portal;
    private static final Log _log = LogFactoryUtil.getLog(KaleoTaskInstanceTokenModelDocumentContributor.class);

    public void contribute(Document document, KaleoTaskInstanceToken kaleoTaskInstanceToken) {
        block6: {
            List kaleoTaskAssignmentInstances = kaleoTaskInstanceToken.getKaleoTaskAssignmentInstances();
            HashSet<Long> assigneeClassNameIds = new HashSet<Long>();
            HashSet<Long> assigneeClassPKs = new HashSet<Long>();
            HashSet<Long> assigneeGroupIds = new HashSet<Long>();
            for (KaleoTaskAssignmentInstance kaleoTaskAssignmentInstance : kaleoTaskAssignmentInstances) {
                assigneeClassNameIds.add(this.portal.getClassNameId(kaleoTaskAssignmentInstance.getAssigneeClassName()));
                assigneeClassPKs.add(kaleoTaskAssignmentInstance.getAssigneeClassPK());
                assigneeGroupIds.add(kaleoTaskAssignmentInstance.getGroupId());
            }
            document.addKeyword("assigneeClassNameIds", assigneeClassNameIds.toArray(new Long[0]));
            document.addKeyword("assigneeClassPKs", assigneeClassPKs.toArray(new Long[0]));
            document.addKeyword("assigneeGroupIds", assigneeGroupIds.toArray(new Long[0]));
            document.addKeyword("className", kaleoTaskInstanceToken.getClassName());
            document.addKeyword("classPK", kaleoTaskInstanceToken.getClassPK());
            document.addKeywordSortable("completed", Boolean.valueOf(kaleoTaskInstanceToken.isCompleted()));
            document.addDateSortable("completionDate", kaleoTaskInstanceToken.getCompletionDate());
            document.addDateSortable("createDate", kaleoTaskInstanceToken.getCreateDate());
            document.addDateSortable("dueDate", kaleoTaskInstanceToken.getDueDate());
            try {
                KaleoDefinitionVersion kaleoDefinitionVersion = this.kaleoDefinitionVersionLocalService.getKaleoDefinitionVersion(kaleoTaskInstanceToken.getKaleoDefinitionVersionId());
                KaleoDefinition kaleoDefinition = kaleoDefinitionVersion.getKaleoDefinition();
                document.addKeyword("kaleoDefinitionId", kaleoDefinition.getKaleoDefinitionId());
            }
            catch (PortalException portalException) {
                if (!_log.isWarnEnabled()) break block6;
                _log.warn((Object)portalException, (Throwable)portalException);
            }
        }
        document.addNumberSortable("kaleoInstanceId", Long.valueOf(kaleoTaskInstanceToken.getKaleoInstanceId()));
        document.addNumberSortable("kaleoTaskId", Long.valueOf(kaleoTaskInstanceToken.getKaleoTaskId()));
        document.addNumberSortable("kaleoTaskInstanceTokenId", Long.valueOf(kaleoTaskInstanceToken.getKaleoTaskInstanceTokenId()));
        document.addDateSortable("modified", kaleoTaskInstanceToken.getModifiedDate());
        document.addKeywordSortable("taskName", kaleoTaskInstanceToken.getKaleoTaskName());
        document.addNumberSortable("userId", Long.valueOf(kaleoTaskInstanceToken.getUserId()));
        AssetEntry assetEntry = this.getAssetEntry(kaleoTaskInstanceToken);
        if (assetEntry != null) {
            document.addKeyword("assetClassNameId", assetEntry.getClassNameId());
            document.addKeyword("assetClassPK", assetEntry.getClassPK());
            document.addLocalizedText("assetDescription", LocalizationUtil.populateLocalizationMap((Map)assetEntry.getDescriptionMap(), (String)assetEntry.getDefaultLanguageId(), (long)assetEntry.getGroupId()));
            document.addLocalizedText("assetTitle", LocalizationUtil.populateLocalizationMap((Map)assetEntry.getTitleMap(), (String)assetEntry.getDefaultLanguageId(), (long)assetEntry.getGroupId()));
        } else {
            WorkflowHandler workflowHandler = WorkflowHandlerRegistryUtil.getWorkflowHandler((String)kaleoTaskInstanceToken.getClassName());
            for (Locale availableLocale : LanguageUtil.getAvailableLocales((long)kaleoTaskInstanceToken.getGroupId())) {
                document.addText(LocalizationUtil.getLocalizedName((String)"assetTitle", (String)availableLocale.getLanguage()), workflowHandler.getTitle(kaleoTaskInstanceToken.getClassPK(), availableLocale));
            }
        }
    }

    protected AssetEntry getAssetEntry(KaleoTaskInstanceToken kaleoTaskInstanceToken) {
        block3: {
            try {
                AssetRenderer<?> assetRenderer = this.getAssetRenderer(kaleoTaskInstanceToken.getClassName(), kaleoTaskInstanceToken.getClassPK());
                if (assetRenderer != null) {
                    return this.assetEntryLocalService.getEntry(assetRenderer.getClassName(), assetRenderer.getClassPK());
                }
            }
            catch (PortalException portalException) {
                if (!_log.isDebugEnabled()) break block3;
                _log.debug((Object)portalException, (Throwable)portalException);
            }
        }
        return null;
    }

    protected AssetRenderer<?> getAssetRenderer(String className, long classPK) throws PortalException {
        AssetRendererFactory<?> assetRendererFactory = this.getAssetRendererFactory(className);
        if (assetRendererFactory != null) {
            return assetRendererFactory.getAssetRenderer(classPK);
        }
        return null;
    }

    protected AssetRendererFactory<?> getAssetRendererFactory(String className) {
        return AssetRendererFactoryRegistryUtil.getAssetRendererFactoryByClassName((String)className);
    }

    protected String[] getLanguageIds(String defaultLanguageId, String content) {
        String[] languageIds = LocalizationUtil.getAvailableLanguageIds((String)content);
        if (languageIds.length == 0) {
            languageIds = new String[]{defaultLanguageId};
        }
        return languageIds;
    }
}

