/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.workflow.kaleo.internal.search.spi.model.query.contributor;

import com.liferay.portal.kernel.search.BooleanClauseOccur;
import com.liferay.portal.kernel.search.ParseException;
import com.liferay.portal.kernel.search.Query;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.filter.BooleanFilter;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.kernel.search.filter.QueryFilter;
import com.liferay.portal.kernel.search.generic.BooleanQueryImpl;
import com.liferay.portal.kernel.util.FastDateFormatFactoryUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.search.filter.DateRangeFilterBuilder;
import com.liferay.portal.search.filter.FilterBuilders;
import com.liferay.portal.search.spi.model.query.contributor.ModelPreFilterContributor;
import com.liferay.portal.search.spi.model.registrar.ModelSearchSettings;
import com.liferay.portal.workflow.kaleo.service.persistence.KaleoInstanceQuery;
import java.text.Format;
import java.util.Date;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"indexer.class.name=com.liferay.portal.workflow.kaleo.model.KaleoInstance"}, service={ModelPreFilterContributor.class})
public class KaleoInstanceModelPreFilterContributor
implements ModelPreFilterContributor {
    @Reference
    protected FilterBuilders filterBuilders;

    public void contribute(BooleanFilter booleanFilter, ModelSearchSettings modelSearchSettings, SearchContext searchContext) {
        KaleoInstanceQuery kaleoInstanceQuery = (KaleoInstanceQuery)searchContext.getAttribute("kaleoInstanceQuery");
        if (kaleoInstanceQuery == null) {
            return;
        }
        BooleanFilter innerBooleanFilter = new BooleanFilter();
        this.appendClassName(innerBooleanFilter, kaleoInstanceQuery);
        this.appendCurrentKaleoNodeNameTerm(innerBooleanFilter, kaleoInstanceQuery);
        this.appendKaleoDefinitionNameTerm(innerBooleanFilter, kaleoInstanceQuery);
        if (innerBooleanFilter.hasClauses()) {
            booleanFilter.add((Filter)innerBooleanFilter, BooleanClauseOccur.MUST);
        }
        this.appendClassPKTerm(booleanFilter, kaleoInstanceQuery);
        this.appendCompletedTerm(booleanFilter, kaleoInstanceQuery);
        this.appendCompletionDateRangeTerm(booleanFilter, kaleoInstanceQuery);
        this.appendKaleoDefinitionVersionIdTerm(booleanFilter, kaleoInstanceQuery);
        this.appendKaleoDefinitionVersionTerm(booleanFilter, kaleoInstanceQuery);
        this.appendKaleoInstanceIdTerm(booleanFilter, kaleoInstanceQuery);
        this.appendRootKaleoInstanceTokenIdTerm(booleanFilter, kaleoInstanceQuery);
    }

    protected void appendClassName(BooleanFilter booleanFilter, KaleoInstanceQuery kaleoInstanceQuery) {
        Object[] classNames = kaleoInstanceQuery.getClassNames();
        if (ListUtil.isNull((List)ListUtil.fromArray((Object[])classNames))) {
            return;
        }
        BooleanQueryImpl booleanQuery = new BooleanQueryImpl();
        for (Object className : classNames) {
            try {
                booleanQuery.addTerm("className", (String)className);
            }
            catch (ParseException parseException) {
                throw new RuntimeException(parseException);
            }
        }
        booleanFilter.add((Filter)new QueryFilter((Query)booleanQuery));
    }

    protected void appendClassPKTerm(BooleanFilter booleanFilter, KaleoInstanceQuery kaleoInstanceQuery) {
        Long classPK = kaleoInstanceQuery.getClassPK();
        if (classPK == null) {
            return;
        }
        booleanFilter.addRequiredTerm("classPK", classPK);
    }

    protected void appendCompletedTerm(BooleanFilter booleanFilter, KaleoInstanceQuery kaleoInstanceQuery) {
        Boolean completed = kaleoInstanceQuery.isCompleted();
        if (completed == null) {
            return;
        }
        booleanFilter.addRequiredTerm("completed", completed);
    }

    protected void appendCompletionDateRangeTerm(BooleanFilter booleanFilter, KaleoInstanceQuery kaleoInstanceQuery) {
        Date completionDateGT = kaleoInstanceQuery.getCompletionDateGT();
        Date completionDateLT = kaleoInstanceQuery.getCompletionDateLT();
        if (completionDateGT == null && completionDateLT == null) {
            return;
        }
        String formatPattern = PropsUtil.get((String)"index.date.format.pattern");
        Format dateFormat = FastDateFormatFactoryUtil.getSimpleDateFormat((String)formatPattern);
        DateRangeFilterBuilder dueDateRangeFilterBuilder = this.filterBuilders.dateRangeFilterBuilder();
        dueDateRangeFilterBuilder.setFieldName("completionDate");
        if (completionDateGT != null) {
            dueDateRangeFilterBuilder.setFrom(dateFormat.format(completionDateGT));
        }
        if (completionDateLT != null) {
            dueDateRangeFilterBuilder.setTo(dateFormat.format(completionDateLT));
        }
        booleanFilter.add((Filter)dueDateRangeFilterBuilder.build(), BooleanClauseOccur.MUST);
    }

    protected void appendCurrentKaleoNodeNameTerm(BooleanFilter booleanFilter, KaleoInstanceQuery kaleoInstanceQuery) {
        String currentKaleoNodeName = kaleoInstanceQuery.getCurrentKaleoNodeName();
        if (Validator.isNull((String)currentKaleoNodeName)) {
            return;
        }
        BooleanQueryImpl booleanQuery = new BooleanQueryImpl();
        try {
            booleanQuery.addTerm("currentKaleoNodeName", currentKaleoNodeName);
        }
        catch (ParseException parseException) {
            throw new RuntimeException(parseException);
        }
        booleanFilter.add((Filter)new QueryFilter((Query)booleanQuery));
    }

    protected void appendKaleoDefinitionNameTerm(BooleanFilter booleanFilter, KaleoInstanceQuery kaleoInstanceQuery) {
        String kaleoDefinitionName = kaleoInstanceQuery.getKaleoDefinitionName();
        if (Validator.isNull((String)kaleoDefinitionName)) {
            return;
        }
        BooleanQueryImpl booleanQuery = new BooleanQueryImpl();
        try {
            booleanQuery.addTerm("kaleoDefinitionName", kaleoDefinitionName);
        }
        catch (ParseException parseException) {
            throw new RuntimeException(parseException);
        }
        booleanFilter.add((Filter)new QueryFilter((Query)booleanQuery));
    }

    protected void appendKaleoDefinitionVersionIdTerm(BooleanFilter booleanFilter, KaleoInstanceQuery kaleoInstanceQuery) {
        Long kaleoDefinitionVersionId = kaleoInstanceQuery.getKaleoDefinitionVersionId();
        if (kaleoDefinitionVersionId == null) {
            return;
        }
        booleanFilter.addRequiredTerm("kaleoDefinitionVersionId", kaleoDefinitionVersionId);
    }

    protected void appendKaleoDefinitionVersionTerm(BooleanFilter booleanFilter, KaleoInstanceQuery kaleoInstanceQuery) {
        Integer kaleoDefinitionVersion = kaleoInstanceQuery.getKaleoDefinitionVersion();
        if (kaleoDefinitionVersion == null) {
            return;
        }
        booleanFilter.addRequiredTerm("kaleoDefinitionVersion", kaleoDefinitionVersion);
    }

    protected void appendKaleoInstanceIdTerm(BooleanFilter booleanFilter, KaleoInstanceQuery kaleoInstanceQuery) {
        Long kaleoInstanceId = kaleoInstanceQuery.getKaleoInstanceId();
        if (kaleoInstanceId == null) {
            return;
        }
        booleanFilter.addRequiredTerm("kaleoInstanceId", kaleoInstanceId);
    }

    protected void appendRootKaleoInstanceTokenIdTerm(BooleanFilter booleanFilter, KaleoInstanceQuery kaleoInstanceQuery) {
        Long rootKaleoInstanceTokenId = kaleoInstanceQuery.getRootKaleoInstanceTokenId();
        if (rootKaleoInstanceTokenId == null) {
            return;
        }
        booleanFilter.addRequiredTerm("rootKaleoInstanceTokenId", rootKaleoInstanceTokenId);
    }
}

