/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.workflow.kaleo.internal.search.spi.model.query.contributor;

import com.liferay.portal.kernel.search.BooleanClauseOccur;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.filter.BooleanFilter;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.kernel.util.FastDateFormatFactoryUtil;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.search.filter.DateRangeFilterBuilder;
import com.liferay.portal.search.filter.FilterBuilders;
import com.liferay.portal.search.spi.model.query.contributor.ModelPreFilterContributor;
import com.liferay.portal.search.spi.model.registrar.ModelSearchSettings;
import com.liferay.portal.workflow.kaleo.service.persistence.KaleoInstanceTokenQuery;
import java.text.Format;
import java.util.Date;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"indexer.class.name=com.liferay.portal.workflow.kaleo.model.KaleoInstanceToken"}, service={ModelPreFilterContributor.class})
public class KaleoInstanceTokenModelPreFilterContributor
implements ModelPreFilterContributor {
    @Reference
    protected FilterBuilders filterBuilders;

    public void contribute(BooleanFilter booleanFilter, ModelSearchSettings modelSearchSettings, SearchContext searchContext) {
        KaleoInstanceTokenQuery kaleoInstanceTokenQuery = (KaleoInstanceTokenQuery)searchContext.getAttribute("kaleoInstanceTokenQuery");
        if (kaleoInstanceTokenQuery == null) {
            return;
        }
        this.appendCompletedTerm(booleanFilter, kaleoInstanceTokenQuery);
        this.appendCompletionDateRangeTerm(booleanFilter, kaleoInstanceTokenQuery);
        this.appendKaleoInstanceIdTerm(booleanFilter, kaleoInstanceTokenQuery);
        this.appendKaleoInstanceTokenIdTerm(booleanFilter, kaleoInstanceTokenQuery);
        this.appendParentKaleoInstanceTokenIdTerm(booleanFilter, kaleoInstanceTokenQuery);
        this.appendUserIdTerm(booleanFilter, kaleoInstanceTokenQuery);
    }

    protected void appendCompletedTerm(BooleanFilter booleanFilter, KaleoInstanceTokenQuery kaleoInstanceTokenQuery) {
        Boolean completed = kaleoInstanceTokenQuery.isCompleted();
        if (completed == null) {
            return;
        }
        booleanFilter.addRequiredTerm("completed", completed);
    }

    protected void appendCompletionDateRangeTerm(BooleanFilter booleanFilter, KaleoInstanceTokenQuery kaleoInstanceTokenQuery) {
        Date completionDateGT = kaleoInstanceTokenQuery.getCompletionDateGT();
        Date completionDateLT = kaleoInstanceTokenQuery.getCompletionDateLT();
        if (completionDateGT == null && completionDateLT == null) {
            return;
        }
        String formatPattern = PropsUtil.get((String)"index.date.format.pattern");
        Format dateFormat = FastDateFormatFactoryUtil.getSimpleDateFormat((String)formatPattern);
        DateRangeFilterBuilder completionDateRangeFilterBuilder = this.filterBuilders.dateRangeFilterBuilder();
        completionDateRangeFilterBuilder.setFieldName("completionDate");
        if (completionDateGT != null) {
            completionDateRangeFilterBuilder.setFrom(dateFormat.format(completionDateGT));
        }
        if (completionDateLT != null) {
            completionDateRangeFilterBuilder.setTo(dateFormat.format(completionDateLT));
        }
        booleanFilter.add((Filter)completionDateRangeFilterBuilder.build(), BooleanClauseOccur.MUST);
    }

    protected void appendKaleoInstanceIdTerm(BooleanFilter booleanFilter, KaleoInstanceTokenQuery kaleoInstanceTokenQuery) {
        Long kaleoInstanceId = kaleoInstanceTokenQuery.getKaleoInstanceId();
        if (kaleoInstanceId == null) {
            return;
        }
        booleanFilter.addRequiredTerm("kaleoInstanceId", kaleoInstanceId);
    }

    protected void appendKaleoInstanceTokenIdTerm(BooleanFilter booleanFilter, KaleoInstanceTokenQuery kaleoInstanceTokenQuery) {
        Long kaleoInstanceTokenId = kaleoInstanceTokenQuery.getKaleoInstanceTokenId();
        if (kaleoInstanceTokenId == null) {
            return;
        }
        booleanFilter.addRequiredTerm("kaleoInstanceTokenId", kaleoInstanceTokenId);
    }

    protected void appendParentKaleoInstanceTokenIdTerm(BooleanFilter booleanFilter, KaleoInstanceTokenQuery kaleoInstanceTokenQuery) {
        Long parentKaleoInstanceTokenId = kaleoInstanceTokenQuery.getParentKaleoInstanceTokenId();
        if (parentKaleoInstanceTokenId == null) {
            return;
        }
        booleanFilter.addRequiredTerm("parentKaleoInstanceTokenId", parentKaleoInstanceTokenId);
    }

    protected void appendUserIdTerm(BooleanFilter booleanFilter, KaleoInstanceTokenQuery kaleoInstanceTokenQuery) {
        Long userId = kaleoInstanceTokenQuery.getUserId();
        if (userId == null) {
            return;
        }
        booleanFilter.addRequiredTerm("userId", userId);
    }
}

