/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.workflow.kaleo.internal.upgrade.v1_4_1;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.dao.jdbc.AutoBatchPreparedStatementUtil;
import com.liferay.portal.kernel.dao.jdbc.DataAccess;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.LoggingTimer;
import com.liferay.portal.workflow.kaleo.internal.upgrade.v1_4_1.util.KaleoDefinitionTable;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;

public class KaleoDefinitionVersionUpgradeProcess
extends UpgradeProcess {
    private static final String[] _TABLE_NAMES = new String[]{"KaleoAction", "KaleoCondition", "KaleoInstance", "KaleoInstanceToken", "KaleoLog", "KaleoNode", "KaleoNotification", "KaleoNotificationRecipient", "KaleoTask", "KaleoTaskAssignment", "KaleoTaskAssignmentInstance", "KaleoTaskForm", "KaleoTaskFormInstance", "KaleoTaskInstanceToken", "KaleoTimer", "KaleoTimerInstanceToken", "KaleoTransition"};

    protected void addBatch(PreparedStatement preparedStatement, long kaleoDefinitionId, long kaleoDefinitionVersionId) throws SQLException {
        preparedStatement.setLong(1, kaleoDefinitionVersionId);
        preparedStatement.setLong(2, kaleoDefinitionId);
        preparedStatement.addBatch();
    }

    protected void doUpgrade() throws Exception {
        this.upgradeKaleoDefinitionVersion();
        this.removeDuplicateKaleoDefinitions();
        this.removeStartKaleoNodeId();
    }

    protected String getVersion(int version) {
        return version + "." + 0;
    }

    protected void removeDuplicateKaleoDefinitions() throws IOException, SQLException {
        try (LoggingTimer loggingTimer = new LoggingTimer();
             PreparedStatement preparedStatement1 = this.connection.prepareStatement("select companyId, name, MAX(version) as version from KaleoDefinition group by companyId, name");
             PreparedStatement preparedStatement2 = AutoBatchPreparedStatementUtil.concurrentAutoBatch((Connection)this.connection, (String)"delete from KaleoDefinition where companyId = ? and name = ? and version < ?");
             ResultSet resultSet = preparedStatement1.executeQuery();){
            while (resultSet.next()) {
                long companyId = resultSet.getLong("companyId");
                String name = resultSet.getString("name");
                int version = resultSet.getInt("version");
                preparedStatement2.setLong(1, companyId);
                preparedStatement2.setString(2, name);
                preparedStatement2.setInt(3, version);
                preparedStatement2.addBatch();
            }
            preparedStatement2.executeBatch();
        }
    }

    protected void removeStartKaleoNodeId() throws Exception {
        if (this.hasColumn("KaleoDefinition", "startKaleoNodeId")) {
            this.alter(KaleoDefinitionTable.class, new UpgradeProcess.Alterable[]{new UpgradeProcess.AlterTableDropColumn((UpgradeProcess)this, "startKaleoNodeId")});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void upgradeKaleoDefinitionVersion() throws Exception {
        StringBundler sb1 = new StringBundler(3);
        sb1.append("select * from KaleoDefinition kd where not exists ");
        sb1.append("(select 1 from KaleoDefinitionVersion kdv where kdv.name ");
        sb1.append("= kd.name and kdv.companyId = kd.companyId)");
        StringBundler sb2 = new StringBundler(6);
        sb2.append("insert into KaleoDefinitionVersion ");
        sb2.append("(kaleoDefinitionVersionId, groupId, companyId, userId, ");
        sb2.append("userName, statusByUserId, statusByUserName, statusDate, ");
        sb2.append("createDate, modifiedDate, name, title, description, ");
        sb2.append("content, version, startKaleoNodeId, status) values (?, ");
        sb2.append("?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ? )");
        ArrayList<PreparedStatement> preparedStatements = new ArrayList<PreparedStatement>(17);
        try (LoggingTimer loggingTimer = new LoggingTimer();
             PreparedStatement preparedStatement1 = this.connection.prepareStatement(sb1.toString());
             PreparedStatement preparedStatement2 = AutoBatchPreparedStatementUtil.concurrentAutoBatch((Connection)this.connection, (String)sb2.toString());
             ResultSet resultSet = preparedStatement1.executeQuery();){
            for (String tableName : _TABLE_NAMES) {
                if (!this.hasColumn(tableName, "kaleoDefinitionId")) continue;
                StringBundler sb3 = new StringBundler(4);
                sb3.append("update ");
                sb3.append(tableName);
                sb3.append(" set kaleoDefinitionVersionId = ? where ");
                sb3.append("kaleoDefinitionId = ? ");
                preparedStatements.add(AutoBatchPreparedStatementUtil.concurrentAutoBatch((Connection)this.connection, (String)sb3.toString()));
            }
            while (resultSet.next()) {
                long kaleoDefinitionId = resultSet.getLong("kaleoDefinitionId");
                long groupId = resultSet.getLong("groupId");
                long companyId = resultSet.getLong("companyId");
                long userId = resultSet.getLong("userId");
                String userName = resultSet.getString("userName");
                Timestamp createDate = resultSet.getTimestamp("createDate");
                Timestamp modifiedDate = resultSet.getTimestamp("modifiedDate");
                String name = resultSet.getString("name");
                String title = resultSet.getString("title");
                String description = resultSet.getString("description");
                String content = resultSet.getString("content");
                int version = resultSet.getInt("version");
                long startKaleoNodeId = resultSet.getLong("startKaleoNodeId");
                long kaleoDefinitionVersionId = this.increment();
                preparedStatement2.setLong(1, kaleoDefinitionVersionId);
                preparedStatement2.setLong(2, groupId);
                preparedStatement2.setLong(3, companyId);
                preparedStatement2.setLong(4, userId);
                preparedStatement2.setString(5, userName);
                preparedStatement2.setLong(6, userId);
                preparedStatement2.setString(7, userName);
                preparedStatement2.setTimestamp(8, modifiedDate);
                preparedStatement2.setTimestamp(9, createDate);
                preparedStatement2.setTimestamp(10, modifiedDate);
                preparedStatement2.setString(11, name);
                preparedStatement2.setString(12, title);
                preparedStatement2.setString(13, description);
                preparedStatement2.setString(14, content);
                preparedStatement2.setString(15, this.getVersion(version));
                preparedStatement2.setLong(16, startKaleoNodeId);
                preparedStatement2.setInt(17, 0);
                preparedStatement2.addBatch();
                for (PreparedStatement preparedStatement : preparedStatements) {
                    this.addBatch(preparedStatement, kaleoDefinitionId, kaleoDefinitionVersionId);
                }
            }
            preparedStatement2.executeBatch();
            for (PreparedStatement preparedStatement : preparedStatements) {
                preparedStatement.executeBatch();
            }
        }
        finally {
            for (PreparedStatement preparedStatement : preparedStatements) {
                DataAccess.cleanUp((Statement)preparedStatement);
            }
        }
    }
}

