/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.workflow.kaleo.internal.upgrade.v3_0_0;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.dao.jdbc.AutoBatchPreparedStatementUtil;
import com.liferay.portal.kernel.dao.jdbc.DataAccess;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.LoggingTimer;
import com.liferay.portal.workflow.kaleo.internal.upgrade.v3_0_0.util.KaleoActionTable;
import com.liferay.portal.workflow.kaleo.internal.upgrade.v3_0_0.util.KaleoConditionTable;
import com.liferay.portal.workflow.kaleo.internal.upgrade.v3_0_0.util.KaleoDefinitionVersionTable;
import com.liferay.portal.workflow.kaleo.internal.upgrade.v3_0_0.util.KaleoInstanceTable;
import com.liferay.portal.workflow.kaleo.internal.upgrade.v3_0_0.util.KaleoInstanceTokenTable;
import com.liferay.portal.workflow.kaleo.internal.upgrade.v3_0_0.util.KaleoLogTable;
import com.liferay.portal.workflow.kaleo.internal.upgrade.v3_0_0.util.KaleoNodeTable;
import com.liferay.portal.workflow.kaleo.internal.upgrade.v3_0_0.util.KaleoNotificationRecipientTable;
import com.liferay.portal.workflow.kaleo.internal.upgrade.v3_0_0.util.KaleoNotificationTable;
import com.liferay.portal.workflow.kaleo.internal.upgrade.v3_0_0.util.KaleoTaskAssignmentInstanceTable;
import com.liferay.portal.workflow.kaleo.internal.upgrade.v3_0_0.util.KaleoTaskAssignmentTable;
import com.liferay.portal.workflow.kaleo.internal.upgrade.v3_0_0.util.KaleoTaskFormInstanceTable;
import com.liferay.portal.workflow.kaleo.internal.upgrade.v3_0_0.util.KaleoTaskFormTable;
import com.liferay.portal.workflow.kaleo.internal.upgrade.v3_0_0.util.KaleoTaskInstanceTokenTable;
import com.liferay.portal.workflow.kaleo.internal.upgrade.v3_0_0.util.KaleoTaskTable;
import com.liferay.portal.workflow.kaleo.internal.upgrade.v3_0_0.util.KaleoTimerInstanceTokenTable;
import com.liferay.portal.workflow.kaleo.internal.upgrade.v3_0_0.util.KaleoTimerTable;
import com.liferay.portal.workflow.kaleo.internal.upgrade.v3_0_0.util.KaleoTransitionTable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;

public class SchemaUpgradeProcess
extends UpgradeProcess {
    private static final String[] _TABLE_NAMES = new String[]{"KaleoAction", "KaleoCondition", "KaleoDefinitionVersion", "KaleoInstance", "KaleoInstanceToken", "KaleoLog", "KaleoNode", "KaleoNotification", "KaleoNotificationRecipient", "KaleoTask", "KaleoTaskAssignment", "KaleoTaskAssignmentInstance", "KaleoTaskForm", "KaleoTaskFormInstance", "KaleoTaskInstanceToken", "KaleoTimer", "KaleoTimerInstanceToken", "KaleoTransition"};

    protected void addBatch(PreparedStatement preparedStatement, long kaleoDefinitionId, long kaleoDefinitionVersionId) throws SQLException {
        preparedStatement.setLong(1, kaleoDefinitionId);
        preparedStatement.setLong(2, kaleoDefinitionVersionId);
        preparedStatement.addBatch();
    }

    protected void addKaleoDefinitionId() throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer();){
            if (!this.hasColumn("KaleoAction", "kaleoDefinitionId")) {
                this.alter(KaleoActionTable.class, new UpgradeProcess.Alterable[]{new UpgradeProcess.AlterTableAddColumn((UpgradeProcess)this, "kaleoDefinitionId", "LONG")});
            }
            if (!this.hasColumn("KaleoCondition", "kaleoDefinitionId")) {
                this.alter(KaleoConditionTable.class, new UpgradeProcess.Alterable[]{new UpgradeProcess.AlterTableAddColumn((UpgradeProcess)this, "kaleoDefinitionId", "LONG")});
            }
            if (!this.hasColumn("KaleoDefinitionVersion", "kaleoDefinitionId")) {
                this.alter(KaleoDefinitionVersionTable.class, new UpgradeProcess.Alterable[]{new UpgradeProcess.AlterTableAddColumn((UpgradeProcess)this, "kaleoDefinitionId", "LONG")});
            }
            if (!this.hasColumn("KaleoInstance", "kaleoDefinitionId")) {
                this.alter(KaleoInstanceTable.class, new UpgradeProcess.Alterable[]{new UpgradeProcess.AlterTableAddColumn((UpgradeProcess)this, "kaleoDefinitionId", "LONG")});
            }
            if (!this.hasColumn("KaleoInstanceToken", "kaleoDefinitionId")) {
                this.alter(KaleoInstanceTokenTable.class, new UpgradeProcess.Alterable[]{new UpgradeProcess.AlterTableAddColumn((UpgradeProcess)this, "kaleoDefinitionId", "LONG")});
            }
            if (!this.hasColumn("KaleoLog", "kaleoDefinitionId")) {
                this.alter(KaleoLogTable.class, new UpgradeProcess.Alterable[]{new UpgradeProcess.AlterTableAddColumn((UpgradeProcess)this, "kaleoDefinitionId", "LONG")});
            }
            if (!this.hasColumn("KaleoNode", "kaleoDefinitionId")) {
                this.alter(KaleoNodeTable.class, new UpgradeProcess.Alterable[]{new UpgradeProcess.AlterTableAddColumn((UpgradeProcess)this, "kaleoDefinitionId", "LONG")});
            }
            if (!this.hasColumn("KaleoNotification", "kaleoDefinitionId")) {
                this.alter(KaleoNotificationTable.class, new UpgradeProcess.Alterable[]{new UpgradeProcess.AlterTableAddColumn((UpgradeProcess)this, "kaleoDefinitionId", "LONG")});
            }
            if (!this.hasColumn("KaleoNotificationRecipient", "kaleoDefinitionId")) {
                this.alter(KaleoNotificationRecipientTable.class, new UpgradeProcess.Alterable[]{new UpgradeProcess.AlterTableAddColumn((UpgradeProcess)this, "kaleoDefinitionId", "LONG")});
            }
            if (!this.hasColumn("KaleoTask", "kaleoDefinitionId")) {
                this.alter(KaleoTaskTable.class, new UpgradeProcess.Alterable[]{new UpgradeProcess.AlterTableAddColumn((UpgradeProcess)this, "kaleoDefinitionId", "LONG")});
            }
            if (!this.hasColumn("KaleoTaskAssignment", "kaleoDefinitionId")) {
                this.alter(KaleoTaskAssignmentTable.class, new UpgradeProcess.Alterable[]{new UpgradeProcess.AlterTableAddColumn((UpgradeProcess)this, "kaleoDefinitionId", "LONG")});
            }
            if (!this.hasColumn("KaleoTaskAssignmentInstance", "kaleoDefinitionId")) {
                this.alter(KaleoTaskAssignmentInstanceTable.class, new UpgradeProcess.Alterable[]{new UpgradeProcess.AlterTableAddColumn((UpgradeProcess)this, "kaleoDefinitionId", "LONG")});
            }
            if (!this.hasColumn("KaleoTaskForm", "kaleoDefinitionId")) {
                this.alter(KaleoTaskFormTable.class, new UpgradeProcess.Alterable[]{new UpgradeProcess.AlterTableAddColumn((UpgradeProcess)this, "kaleoDefinitionId", "LONG")});
            }
            if (!this.hasColumn("KaleoTaskFormInstance", "kaleoDefinitionId")) {
                this.alter(KaleoTaskFormInstanceTable.class, new UpgradeProcess.Alterable[]{new UpgradeProcess.AlterTableAddColumn((UpgradeProcess)this, "kaleoDefinitionId", "LONG")});
            }
            if (!this.hasColumn("KaleoTaskInstanceToken", "kaleoDefinitionId")) {
                this.alter(KaleoTaskInstanceTokenTable.class, new UpgradeProcess.Alterable[]{new UpgradeProcess.AlterTableAddColumn((UpgradeProcess)this, "kaleoDefinitionId", "LONG")});
            }
            if (!this.hasColumn("KaleoTimer", "kaleoDefinitionId")) {
                this.alter(KaleoTimerTable.class, new UpgradeProcess.Alterable[]{new UpgradeProcess.AlterTableAddColumn((UpgradeProcess)this, "kaleoDefinitionId", "LONG")});
            }
            if (!this.hasColumn("KaleoTimerInstanceToken", "kaleoDefinitionId")) {
                this.alter(KaleoTimerInstanceTokenTable.class, new UpgradeProcess.Alterable[]{new UpgradeProcess.AlterTableAddColumn((UpgradeProcess)this, "kaleoDefinitionId", "LONG")});
            }
            if (!this.hasColumn("KaleoTransition", "kaleoDefinitionId")) {
                this.alter(KaleoTransitionTable.class, new UpgradeProcess.Alterable[]{new UpgradeProcess.AlterTableAddColumn((UpgradeProcess)this, "kaleoDefinitionId", "LONG")});
            }
        }
    }

    protected void doUpgrade() throws Exception {
        this.addKaleoDefinitionId();
        this.upgradeKaleoDefinitionId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void upgradeKaleoDefinitionId() throws Exception {
        StringBundler sb1 = new StringBundler(6);
        sb1.append("select KaleoDefinition.kaleoDefinitionId, ");
        sb1.append("KaleoDefinitionVersion.kaleoDefinitionVersionId from ");
        sb1.append("KaleoDefinitionVersion inner join KaleoDefinition on ");
        sb1.append("KaleoDefinition.companyId = ");
        sb1.append("KaleoDefinitionVersion.companyId and ");
        sb1.append("KaleoDefinition.name = KaleoDefinitionVersion.name");
        ArrayList<PreparedStatement> preparedStatements = new ArrayList<PreparedStatement>(18);
        try (LoggingTimer loggingTimer = new LoggingTimer();
             PreparedStatement preparedStatement = this.connection.prepareStatement(sb1.toString());
             ResultSet resultSet = preparedStatement.executeQuery();){
            for (String tableName : _TABLE_NAMES) {
                StringBundler sb2 = new StringBundler(4);
                sb2.append("update ");
                sb2.append(tableName);
                sb2.append(" set kaleoDefinitionId = ? where ");
                sb2.append("kaleoDefinitionVersionId = ? ");
                preparedStatements.add(AutoBatchPreparedStatementUtil.concurrentAutoBatch((Connection)this.connection, (String)sb2.toString()));
            }
            while (resultSet.next()) {
                long kaleoDefinitionId = resultSet.getLong("kaleoDefinitionId");
                long kaleoDefinitionVersionId = resultSet.getLong("kaleoDefinitionVersionId");
                for (PreparedStatement curPreparedStatement : preparedStatements) {
                    this.addBatch(curPreparedStatement, kaleoDefinitionId, kaleoDefinitionVersionId);
                }
            }
            for (PreparedStatement curPreparedStatement : preparedStatements) {
                curPreparedStatement.executeBatch();
            }
        }
        finally {
            for (PreparedStatement curPreparedStatement : preparedStatements) {
                DataAccess.cleanUp((Statement)curPreparedStatement);
            }
        }
    }
}

