/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.workflow.kaleo.internal.upgrade.v3_1_1;

import com.liferay.portal.kernel.upgrade.UpgradeException;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.workflow.kaleo.definition.NotificationType;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Objects;
import java.util.stream.Stream;

public class KaleoNotificationUpgradeProcess
extends UpgradeProcess {
    protected void doUpgrade() throws Exception {
        try (PreparedStatement preparedStatement1 = this.connection.prepareStatement("select kaleoNotificationId, notificationTypes  from KaleoNotification where notificationTypes like ? OR notificationTypes like ?");
             PreparedStatement preparedStatement2 = this.connection.prepareStatement("update KaleoNotification set notificationTypes = ? where kaleoNotificationId = ?");){
            preparedStatement1.setString(1, "%im%");
            preparedStatement1.setString(2, "%private-message%");
            ResultSet resultSet = preparedStatement1.executeQuery();
            while (resultSet.next()) {
                Object[] notificationTypes = (String[])Stream.of(StringUtil.split((String)resultSet.getString("notificationTypes"))).filter(notificationType -> !Objects.equals(notificationType, "im")).filter(notificationType -> !Objects.equals(notificationType, "private-message")).toArray(String[]::new);
                if (ArrayUtil.isEmpty((Object[])notificationTypes)) {
                    notificationTypes = new String[]{NotificationType.USER_NOTIFICATION.getValue()};
                }
                preparedStatement2.setString(1, StringUtil.merge((Object[])notificationTypes));
                preparedStatement2.setLong(2, resultSet.getLong("kaleoNotificationId"));
                preparedStatement2.addBatch();
            }
            preparedStatement2.executeBatch();
        }
        catch (SQLException sqlException) {
            throw new UpgradeException((Throwable)sqlException);
        }
    }
}

