/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.workflow.kaleo.service.impl;

import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.workflow.kaleo.definition.Condition;
import com.liferay.portal.workflow.kaleo.definition.ScriptLanguage;
import com.liferay.portal.workflow.kaleo.model.KaleoCondition;
import com.liferay.portal.workflow.kaleo.service.base.KaleoConditionLocalServiceBaseImpl;
import java.util.Date;
import org.osgi.service.component.annotations.Component;

@Component(property={"model.class.name=com.liferay.portal.workflow.kaleo.model.KaleoCondition"}, service={AopService.class})
public class KaleoConditionLocalServiceImpl
extends KaleoConditionLocalServiceBaseImpl {
    public KaleoCondition addKaleoCondition(long kaleoDefinitionId, long kaleoDefinitionVersionId, long kaleoNodeId, Condition condition, ServiceContext serviceContext) throws PortalException {
        User user = this.userLocalService.getUser(serviceContext.getGuestOrUserId());
        Date date = new Date();
        long kaleoConditionId = this.counterLocalService.increment();
        KaleoCondition kaleoCondition = this.kaleoConditionPersistence.create(kaleoConditionId);
        kaleoCondition.setCompanyId(user.getCompanyId());
        kaleoCondition.setUserId(user.getUserId());
        kaleoCondition.setUserName(user.getFullName());
        kaleoCondition.setCreateDate(date);
        kaleoCondition.setModifiedDate(date);
        kaleoCondition.setKaleoDefinitionId(kaleoDefinitionId);
        kaleoCondition.setKaleoDefinitionVersionId(kaleoDefinitionVersionId);
        kaleoCondition.setKaleoNodeId(kaleoNodeId);
        kaleoCondition.setScript(condition.getScript());
        ScriptLanguage scriptLanguage = condition.getScriptLanguage();
        kaleoCondition.setScriptLanguage(scriptLanguage.getValue());
        kaleoCondition.setScriptRequiredContexts(condition.getScriptRequiredContexts());
        return (KaleoCondition)this.kaleoConditionPersistence.update((BaseModel)kaleoCondition);
    }

    public void deleteCompanyKaleoConditions(long companyId) {
        this.kaleoConditionPersistence.removeByCompanyId(companyId);
    }

    public void deleteKaleoDefinitionVersionKaleoCondition(long kaleoDefinitionVersionId) {
        this.kaleoConditionPersistence.removeByKaleoDefinitionVersionId(kaleoDefinitionVersionId);
    }

    public KaleoCondition getKaleoNodeKaleoCondition(long kaleoNodeId) throws PortalException {
        return this.kaleoConditionPersistence.findByKaleoNodeId(kaleoNodeId);
    }
}

